/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertFromProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertToProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperations;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendReturnValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.impl.MessageImpl;

public final class AmqpsDeviceTwin
extends AmqpsDeviceOperations {
    private static final String CORRELATION_ID_KEY = "com.microsoft:channel-correlation-id";
    private static final String CORRELATION_ID_KEY_PREFIX = "twin:";
    private static final String SENDER_LINK_ENDPOINT_PATH = "/devices/%s/twin";
    private static final String RECEIVER_LINK_ENDPOINT_PATH = "/devices/%s/twin";
    private static final String SENDER_LINK_TAG_PREFIX = "sender_link_devicetwin-";
    private static final String RECEIVER_LINK_TAG_PREFIX = "receiver_link_devicetwin-";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_OPERATION = "operation";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE = "resource";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_STATUS = "status";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_VERSION = "version";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_GET = "GET";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_PATCH = "PATCH";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_PUT = "PUT";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_DELETE = "DELETE";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_PROPERTIES_REPORTED = "/properties/reported";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_NOTIFICATIONS_TWIN_PROPERTIES_DESIRED = "/notifications/twin/properties/desired";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_PROPERTIES_DESIRED = "/properties/desired";
    Map<String, DeviceOperations> correlationIdList;

    AmqpsDeviceTwin(String deviceId) throws IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("The deviceId cannot be null or empty.");
        }
        this.senderLinkEndpointPath = "/devices/%s/twin";
        this.receiverLinkEndpointPath = "/devices/%s/twin";
        this.senderLinkTag = SENDER_LINK_TAG_PREFIX + this.senderLinkTag;
        this.receiverLinkTag = RECEIVER_LINK_TAG_PREFIX + this.receiverLinkTag;
        this.senderLinkAddress = String.format(this.senderLinkEndpointPath, deviceId);
        this.receiverLinkAddress = String.format(this.receiverLinkEndpointPath, deviceId);
        this.amqpProperties.put(Symbol.getSymbol((String)"com.microsoft:api-version"), "2016-11-14");
        this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)(CORRELATION_ID_KEY_PREFIX + UUID.randomUUID().toString())));
        this.correlationIdList = new HashMap<String, DeviceOperations>();
    }

    @Override
    protected AmqpsSendReturnValue sendMessageAndGetDeliveryHash(MessageType messageType, byte[] msgData, int offset, int length, byte[] deliveryTag) throws IllegalStateException, IllegalArgumentException {
        if (messageType == MessageType.DEVICE_TWIN) {
            return super.sendMessageAndGetDeliveryHash(messageType, msgData, offset, length, deliveryTag);
        }
        return new AmqpsSendReturnValue(false, -1);
    }

    @Override
    protected AmqpsMessage getMessageFromReceiverLink(String linkName) throws IllegalArgumentException, IOException {
        AmqpsMessage amqpsMessage = super.getMessageFromReceiverLink(linkName);
        if (amqpsMessage != null) {
            amqpsMessage.setAmqpsMessageType(MessageType.DEVICE_TWIN);
        }
        return amqpsMessage;
    }

    @Override
    protected AmqpsConvertFromProtonReturnValue convertFromProton(AmqpsMessage amqpsMessage, DeviceClientConfig deviceClientConfig) throws IOException {
        if (amqpsMessage.getAmqpsMessageType() == MessageType.DEVICE_TWIN) {
            Message message = null;
            message = this.protonMessageToIoTHubMessage(amqpsMessage);
            MessageCallback messageCallback = deviceClientConfig.getDeviceTwinMessageCallback();
            Object messageContext = deviceClientConfig.getDeviceTwinMessageContext();
            return new AmqpsConvertFromProtonReturnValue(message, messageCallback, messageContext);
        }
        return null;
    }

    @Override
    protected AmqpsConvertToProtonReturnValue convertToProton(Message message) throws IOException {
        if (message.getMessageType() == MessageType.DEVICE_TWIN) {
            MessageImpl protonMessage = this.iotHubMessageToProtonMessage(message);
            return new AmqpsConvertToProtonReturnValue(protonMessage, MessageType.DEVICE_TWIN);
        }
        return null;
    }

    @Override
    protected Message protonMessageToIoTHubMessage(MessageImpl protonMsg) throws IOException {
        Properties properties;
        byte[] msgBody;
        Data d = (Data)protonMsg.getBody();
        if (d != null) {
            Binary b = d.getValue();
            msgBody = new byte[b.getLength()];
            ByteBuffer buffer = b.asByteBuffer();
            buffer.get(msgBody);
        } else {
            msgBody = new byte[]{};
        }
        IotHubTransportMessage iotHubTransportMessage = new IotHubTransportMessage(msgBody, MessageType.DEVICE_TWIN);
        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
        MessageAnnotations messageAnnotations = protonMsg.getMessageAnnotations();
        if (messageAnnotations != null) {
            for (Map.Entry entry : messageAnnotations.getValue().entrySet()) {
                Symbol key = (Symbol)entry.getKey();
                Object value = entry.getValue();
                if (key.toString().equals(MESSAGE_ANNOTATION_FIELD_KEY_STATUS)) {
                    iotHubTransportMessage.setStatus(value.toString());
                    continue;
                }
                if (key.toString().equals(MESSAGE_ANNOTATION_FIELD_KEY_VERSION)) {
                    iotHubTransportMessage.setVersion(value.toString());
                    continue;
                }
                if (!key.toString().equals(MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE) || !value.toString().equals(MESSAGE_ANNOTATION_FIELD_VALUE_PROPERTIES_DESIRED)) continue;
                iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
            }
        }
        if ((properties = protonMsg.getProperties()) != null) {
            if (properties.getCorrelationId() != null) {
                iotHubTransportMessage.setCorrelationId(properties.getCorrelationId().toString());
                if (this.correlationIdList.containsKey(properties.getCorrelationId().toString())) {
                    DeviceOperations deviceOperations = this.correlationIdList.get(properties.getCorrelationId().toString());
                    switch (deviceOperations) {
                        case DEVICE_OPERATION_TWIN_GET_REQUEST: {
                            iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_GET_RESPONSE);
                            break;
                        }
                        case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST: {
                            iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_RESPONSE);
                            break;
                        }
                        case DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                            iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
                            break;
                        }
                        case DEVICE_OPERATION_TWIN_UNSUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                            iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UNSUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
                            break;
                        }
                        default: {
                            throw new IOException("Invalid device operation type in protonMessageToIoTHubMessage!");
                        }
                    }
                    this.correlationIdList.remove(properties.getCorrelationId().toString());
                }
            } else if (iotHubTransportMessage.getDeviceOperationType() == DeviceOperations.DEVICE_OPERATION_UNKNOWN) {
                iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
            }
            if (properties.getMessageId() != null) {
                iotHubTransportMessage.setMessageId(properties.getMessageId().toString());
            }
            if (properties.getTo() != null) {
                iotHubTransportMessage.setProperty("iothub-app-to", properties.getTo());
            }
            if (properties.getUserId() != null) {
                iotHubTransportMessage.setProperty("iothub-app-userId", properties.getUserId().toString());
            }
        }
        if (protonMsg.getApplicationProperties() != null) {
            Map applicationProperties = protonMsg.getApplicationProperties().getValue();
            for (Map.Entry entry : applicationProperties.entrySet()) {
                String propertyKey = (String)entry.getKey();
                if (MessageProperty.RESERVED_PROPERTY_NAMES.contains(propertyKey)) continue;
                iotHubTransportMessage.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return iotHubTransportMessage;
    }

    @Override
    protected MessageImpl iotHubMessageToProtonMessage(Message message) throws IOException {
        IotHubTransportMessage deviceTwinMessage = (IotHubTransportMessage)message;
        MessageImpl outgoingMessage = (MessageImpl)Proton.message();
        Properties properties = new Properties();
        if (deviceTwinMessage.getMessageId() != null) {
            properties.setMessageId((Object)deviceTwinMessage.getMessageId());
        }
        if (deviceTwinMessage.getCorrelationId() != null) {
            properties.setCorrelationId((Object)UUID.fromString(deviceTwinMessage.getCorrelationId()));
            this.correlationIdList.put(deviceTwinMessage.getCorrelationId(), deviceTwinMessage.getDeviceOperationType());
        }
        outgoingMessage.setProperties(properties);
        int propertiesLength = deviceTwinMessage.getProperties().length;
        HashMap<String, String> userProperties = new HashMap<String, String>(propertiesLength);
        if (propertiesLength > 0) {
            for (MessageProperty messageProperty : deviceTwinMessage.getProperties()) {
                if (MessageProperty.RESERVED_PROPERTY_NAMES.contains(messageProperty.getName())) continue;
                userProperties.put(messageProperty.getName(), messageProperty.getValue());
            }
        }
        ApplicationProperties applicationProperties = new ApplicationProperties(userProperties);
        outgoingMessage.setApplicationProperties(applicationProperties);
        HashMap<Symbol, String> messageAnnotationsMap = new HashMap<Symbol, String>();
        switch (deviceTwinMessage.getDeviceOperationType()) {
            case DEVICE_OPERATION_TWIN_GET_REQUEST: {
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_OPERATION), MESSAGE_ANNOTATION_FIELD_VALUE_GET);
                break;
            }
            case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST: {
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_OPERATION), MESSAGE_ANNOTATION_FIELD_VALUE_PATCH);
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE), MESSAGE_ANNOTATION_FIELD_VALUE_PROPERTIES_REPORTED);
                break;
            }
            case DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_OPERATION), MESSAGE_ANNOTATION_FIELD_VALUE_PUT);
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE), MESSAGE_ANNOTATION_FIELD_VALUE_NOTIFICATIONS_TWIN_PROPERTIES_DESIRED);
                break;
            }
            case DEVICE_OPERATION_TWIN_UNSUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_OPERATION), MESSAGE_ANNOTATION_FIELD_VALUE_DELETE);
                messageAnnotationsMap.put(Symbol.valueOf((String)MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE), MESSAGE_ANNOTATION_FIELD_VALUE_NOTIFICATIONS_TWIN_PROPERTIES_DESIRED);
                break;
            }
            default: {
                throw new IOException("Invalid device operation type in iotHubMessageToProtonMessage!");
            }
        }
        MessageAnnotations messageAnnotations = new MessageAnnotations(messageAnnotationsMap);
        outgoingMessage.setMessageAnnotations(messageAnnotations);
        Binary binary = new Binary(deviceTwinMessage.getBytes());
        Data section = new Data(binary);
        outgoingMessage.setBody((Section)section);
        return outgoingMessage;
    }
}

