/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class HttpsConnection {
    private final HttpsURLConnection connection;
    private byte[] body;

    public HttpsConnection(URL url, HttpsMethod method) throws IOException {
        String protocol = url.getProtocol();
        if (!protocol.equalsIgnoreCase("HTTPS")) {
            String errMsg = String.format("Expected URL that uses protocol HTTPS but received one that uses protocol '%s'.%n", protocol);
            throw new IllegalArgumentException(errMsg);
        }
        this.connection = (HttpsURLConnection)url.openConnection();
        this.connection.setRequestMethod(method.name());
        this.body = new byte[0];
    }

    public void connect() throws IOException {
        if (this.body.length > 0) {
            this.connection.setDoOutput(true);
            this.connection.getOutputStream().write(this.body);
        }
        this.connection.connect();
    }

    public void setRequestMethod(HttpsMethod method) {
        if (method != HttpsMethod.POST && method != HttpsMethod.PUT && this.body.length > 0) {
            throw new IllegalArgumentException("Cannot change the request method from POST or PUT when the request body is non-empty.");
        }
        try {
            this.connection.setRequestMethod(method.name());
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
    }

    public void setRequestHeader(String field, String value) {
        this.connection.setRequestProperty(field, value);
    }

    public void setReadTimeoutMillis(int timeout) {
        this.connection.setReadTimeout(timeout);
    }

    public void writeOutput(byte[] body) {
        HttpsMethod method = HttpsMethod.valueOf(this.connection.getRequestMethod());
        if (method != HttpsMethod.POST && method != HttpsMethod.PUT) {
            if (body.length > 0) {
                throw new IllegalArgumentException("Cannot write a body to a request that is not a POST or a PUT request.");
            }
        } else {
            this.body = Arrays.copyOf(body, body.length);
        }
    }

    public byte[] readInput() throws IOException {
        InputStream inputStream = this.connection.getInputStream();
        byte[] input = HttpsConnection.readInputStream(inputStream);
        inputStream.close();
        return input;
    }

    public byte[] readError() throws IOException {
        InputStream errorStream = this.connection.getErrorStream();
        byte[] error = new byte[]{};
        if (errorStream != null) {
            error = HttpsConnection.readInputStream(errorStream);
            errorStream.close();
        }
        return error;
    }

    public int getResponseStatus() throws IOException {
        return this.connection.getResponseCode();
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.connection.getHeaderFields();
    }

    private static byte[] readInputStream(InputStream stream) throws IOException {
        ArrayList<Byte> byteBuffer = new ArrayList<Byte>();
        int nextByte = -1;
        while ((nextByte = stream.read()) > -1) {
            byteBuffer.add((byte)nextByte);
        }
        int bufferSize = byteBuffer.size();
        byte[] byteArray = new byte[bufferSize];
        for (int i = 0; i < bufferSize; ++i) {
            byteArray[i] = (Byte)byteBuffer.get(i);
        }
        return byteArray;
    }

    void setSSLContext(SSLContext sslContext) throws IllegalArgumentException {
        if (sslContext == null) {
            throw new IllegalArgumentException("SSL context cannot be null");
        }
        this.connection.setSSLSocketFactory(sslContext.getSocketFactory());
    }

    protected HttpsConnection() {
        this.connection = null;
    }
}

