/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.ResponseMessage;
import com.microsoft.azure.sdk.iot.device.net.IotHubAbandonUri;
import com.microsoft.azure.sdk.iot.device.net.IotHubCompleteUri;
import com.microsoft.azure.sdk.iot.device.net.IotHubEventUri;
import com.microsoft.azure.sdk.iot.device.net.IotHubMessageUri;
import com.microsoft.azure.sdk.iot.device.net.IotHubRejectUri;
import com.microsoft.azure.sdk.iot.device.net.IotHubUri;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsRequest;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsResponse;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsSingleMessage;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class HttpsIotHubConnection {
    private static final String HTTPS_HEAD_TAG = "https://";
    private static final String HTTPS_PROPERTY_AUTHORIZATION_TAG = "authorization";
    private static final String HTTPS_PROPERTY_IOTHUB_TO_TAG = "iothub-to";
    private static final String HTTPS_PROPERTY_CONTENT_TYPE_TAG = "content-type";
    private static final String HTTPS_PROPERTY_IOTHUB_MESSAGELOCKTIMEOUT_TAG = "iothub-messagelocktimeout";
    private static final String HTTPS_PROPERTY_IF_MATCH_TAG = "if-match";
    private static final String HTTPS_PROPERTY_ETAG_TAG = "etag";
    private final Object HTTPS_CONNECTION_LOCK;
    private final DeviceClientConfig config;
    private String messageEtag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpsIotHubConnection(DeviceClientConfig config) {
        Object object = this.HTTPS_CONNECTION_LOCK = new Object();
        synchronized (object) {
            this.config = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendEvent(HttpsMessage msg) throws IOException {
        Object object = this.HTTPS_CONNECTION_LOCK;
        synchronized (object) {
            String iotHubHostname = this.config.getIotHubHostname();
            String deviceId = this.config.getDeviceId();
            int readTimeoutMillis = this.config.getReadTimeoutMillis();
            IotHubEventUri iotHubEventUri = new IotHubEventUri(iotHubHostname, deviceId);
            URL eventUrl = new URL(HTTPS_HEAD_TAG + iotHubEventUri.toString());
            HttpsRequest request = new HttpsRequest(eventUrl, HttpsMethod.POST, msg.getBody());
            for (MessageProperty property : msg.getProperties()) {
                request.setHeaderField(property.getName(), property.getValue());
            }
            Map<String, String> systemProperties = msg.getSystemProperties();
            for (String systemProperty : systemProperties.keySet()) {
                request.setHeaderField(systemProperty, systemProperties.get(systemProperty));
            }
            SSLContext sslContext = null;
            if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
                sslContext = this.config.getSasTokenAuthentication().getSSLContext();
                if (this.config.getSasTokenAuthentication().isRenewalNecessary()) {
                    return new ResponseMessage("Your sas token has expired".getBytes(), IotHubStatusCode.UNAUTHORIZED);
                }
                request.setHeaderField(HTTPS_PROPERTY_AUTHORIZATION_TAG, this.config.getSasTokenAuthentication().getRenewedSasToken());
            } else if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
                sslContext = this.config.getX509Authentication().getSSLContext();
            }
            request.setSSLContext(sslContext);
            request.setReadTimeoutMillis(readTimeoutMillis).setHeaderField(HTTPS_PROPERTY_IOTHUB_TO_TAG, iotHubEventUri.getPath()).setHeaderField(HTTPS_PROPERTY_CONTENT_TYPE_TAG, msg.getContentType());
            HttpsResponse response = request.send();
            IotHubStatusCode status = IotHubStatusCode.getIotHubStatusCode(response.getStatus());
            byte[] body = response.getBody();
            return new ResponseMessage(body, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendHttpsMessage(HttpsMessage httpsMessage, HttpsMethod httpsMethod, String httpsPath) throws IOException {
        Object object = this.HTTPS_CONNECTION_LOCK;
        synchronized (object) {
            String iotHubHostname = this.config.getIotHubHostname();
            String deviceId = this.config.getDeviceId();
            int readTimeoutMillis = this.config.getReadTimeoutMillis();
            IotHubUri iotHubUri = new IotHubUri(iotHubHostname, deviceId, httpsPath);
            URL messageUrl = new URL(HTTPS_HEAD_TAG + iotHubUri.toString());
            HttpsRequest request = new HttpsRequest(messageUrl, httpsMethod, httpsMessage.getBody());
            for (MessageProperty property : httpsMessage.getProperties()) {
                request.setHeaderField(property.getName(), property.getValue());
            }
            SSLContext sslContext = null;
            if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
                sslContext = this.config.getSasTokenAuthentication().getSSLContext();
                if (this.config.getSasTokenAuthentication().isRenewalNecessary()) {
                    return new ResponseMessage("Your sas token has expired".getBytes(), IotHubStatusCode.UNAUTHORIZED);
                }
                request.setHeaderField(HTTPS_PROPERTY_AUTHORIZATION_TAG, this.config.getSasTokenAuthentication().getRenewedSasToken());
            } else if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
                sslContext = this.config.getX509Authentication().getSSLContext();
            }
            request.setReadTimeoutMillis(readTimeoutMillis).setHeaderField(HTTPS_PROPERTY_IOTHUB_TO_TAG, iotHubUri.getPath()).setHeaderField(HTTPS_PROPERTY_CONTENT_TYPE_TAG, httpsMessage.getContentType());
            request.setSSLContext(sslContext);
            HttpsResponse response = request.send();
            IotHubStatusCode status = IotHubStatusCode.getIotHubStatusCode(response.getStatus());
            byte[] body = response.getBody();
            return new ResponseMessage(body, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveMessage() throws IOException {
        Object object = this.HTTPS_CONNECTION_LOCK;
        synchronized (object) {
            String iotHubHostname = this.config.getIotHubHostname();
            String deviceId = this.config.getDeviceId();
            int readTimeoutMillis = this.config.getReadTimeoutMillis();
            int messageLockTimeoutSecs = this.config.getMessageLockTimeoutSecs();
            IotHubMessageUri messageUri = new IotHubMessageUri(iotHubHostname, deviceId);
            URL messageUrl = new URL(HTTPS_HEAD_TAG + messageUri.toString());
            HttpsRequest request = new HttpsRequest(messageUrl, HttpsMethod.GET, new byte[0]).setReadTimeoutMillis(readTimeoutMillis).setHeaderField(HTTPS_PROPERTY_IOTHUB_TO_TAG, messageUri.getPath()).setHeaderField(HTTPS_PROPERTY_IOTHUB_MESSAGELOCKTIMEOUT_TAG, Integer.toString(messageLockTimeoutSecs));
            SSLContext sslContext = null;
            if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
                sslContext = this.config.getSasTokenAuthentication().getSSLContext();
                if (this.config.getSasTokenAuthentication().isRenewalNecessary()) {
                    return new ResponseMessage("Your sas token has expired".getBytes(), IotHubStatusCode.UNAUTHORIZED);
                }
                request.setHeaderField(HTTPS_PROPERTY_AUTHORIZATION_TAG, this.config.getSasTokenAuthentication().getRenewedSasToken());
            } else if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
                sslContext = this.config.getX509Authentication().getSSLContext();
            }
            request.setSSLContext(sslContext);
            HttpsResponse response = request.send();
            Message msg = null;
            IotHubStatusCode messageStatus = IotHubStatusCode.getIotHubStatusCode(response.getStatus());
            if (messageStatus == IotHubStatusCode.OK) {
                this.messageEtag = HttpsIotHubConnection.sanitizeEtag(response.getHeaderField(HTTPS_PROPERTY_ETAG_TAG));
                HttpsSingleMessage httpsMsg = HttpsSingleMessage.parseHttpsMessage(response);
                msg = httpsMsg.toMessage();
            }
            return msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageResult(IotHubMessageResult result) throws IOException, SecurityException {
        Object object = this.HTTPS_CONNECTION_LOCK;
        synchronized (object) {
            HttpsRequest request;
            String resultPath;
            if (this.messageEtag == null) {
                throw new IllegalStateException("Cannot send a message result before a message is received.");
            }
            String iotHubHostname = this.config.getIotHubHostname();
            String deviceId = this.config.getDeviceId();
            int readTimeoutMillis = this.config.getReadTimeoutMillis();
            String resultUri = HTTPS_HEAD_TAG;
            switch (result) {
                case COMPLETE: {
                    IotHubCompleteUri completeUri = new IotHubCompleteUri(iotHubHostname, deviceId, this.messageEtag);
                    resultUri = resultUri + completeUri.toString();
                    resultPath = completeUri.getPath();
                    URL resultUrl = new URL(resultUri);
                    request = new HttpsRequest(resultUrl, HttpsMethod.DELETE, new byte[0]);
                    break;
                }
                case ABANDON: {
                    IotHubAbandonUri abandonUri = new IotHubAbandonUri(iotHubHostname, deviceId, this.messageEtag);
                    resultUri = resultUri + abandonUri.toString();
                    resultPath = abandonUri.getPath();
                    URL resultUrl = new URL(resultUri);
                    request = new HttpsRequest(resultUrl, HttpsMethod.POST, new byte[1]);
                    break;
                }
                case REJECT: {
                    IotHubRejectUri rejectUri = new IotHubRejectUri(iotHubHostname, deviceId, this.messageEtag);
                    resultUri = resultUri + rejectUri.toString();
                    resultPath = rejectUri.getPath();
                    URL resultUrl = new URL(resultUri);
                    request = new HttpsRequest(resultUrl, HttpsMethod.DELETE, new byte[0]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid message result specified.");
                }
            }
            SSLContext sslContext = null;
            if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
                sslContext = this.config.getSasTokenAuthentication().getSSLContext();
                if (this.config.getSasTokenAuthentication().isRenewalNecessary()) {
                    throw new SecurityException("Your SAS token has expired");
                }
                request.setHeaderField(HTTPS_PROPERTY_AUTHORIZATION_TAG, this.config.getSasTokenAuthentication().getRenewedSasToken());
            } else if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
                sslContext = this.config.getX509Authentication().getSSLContext();
            }
            request.setReadTimeoutMillis(readTimeoutMillis).setHeaderField(HTTPS_PROPERTY_IOTHUB_TO_TAG, resultPath).setHeaderField(HTTPS_PROPERTY_IF_MATCH_TAG, this.messageEtag);
            request.setSSLContext(sslContext);
            HttpsResponse response = request.send();
            IotHubStatusCode resultStatus = IotHubStatusCode.getIotHubStatusCode(response.getStatus());
            if (resultStatus != IotHubStatusCode.OK_EMPTY) {
                String errMsg = String.format("Sending message result failed with status %s.%n", resultStatus.name());
                throw new IOException(errMsg);
            }
        }
    }

    private static String sanitizeEtag(String dirtyEtag) {
        return dirtyEtag.replace("\"", "");
    }
}

