/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionState;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStateCallback;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubResponseCallback;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.ResponseMessage;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubSizeExceededException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubCallbackPacket;
import com.microsoft.azure.sdk.iot.device.transport.IotHubOutboundPacket;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsBatchMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsIotHubConnection;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsSingleMessage;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;

public final class HttpsTransport
implements IotHubTransport {
    private HttpsTransportState state;
    private IotHubConnectionStateCallback stateCallback;
    private Object stateCallbackContext;
    private HttpsIotHubConnection connection;
    private final Queue<IotHubOutboundPacket> waitingList = new LinkedBlockingDeque<IotHubOutboundPacket>();
    private final Queue<IotHubOutboundPacket> inProgressList = new LinkedBlockingDeque<IotHubOutboundPacket>();
    private final Queue<IotHubCallbackPacket> callbackList = new LinkedBlockingDeque<IotHubCallbackPacket>();
    private final DeviceClientConfig config;

    public HttpsTransport(DeviceClientConfig config) {
        this.config = config;
        this.state = HttpsTransportState.CLOSED;
    }

    @Override
    public void open() throws IOException {
        if (this.state == HttpsTransportState.OPEN) {
            return;
        }
        this.connection = new HttpsIotHubConnection(this.config);
        this.state = HttpsTransportState.OPEN;
    }

    @Override
    public void close() throws IOException {
        ResponseMessage responseMessage;
        IotHubOutboundPacket packet;
        while (!this.waitingList.isEmpty()) {
            packet = this.waitingList.remove();
            responseMessage = new ResponseMessage(new byte[0], IotHubStatusCode.MESSAGE_CANCELLED_ONCLOSE);
            this.addOutboundPacketToCallbackList(packet, responseMessage);
        }
        while (!this.inProgressList.isEmpty()) {
            packet = this.inProgressList.remove();
            responseMessage = new ResponseMessage(new byte[0], IotHubStatusCode.MESSAGE_CANCELLED_ONCLOSE);
            this.addOutboundPacketToCallbackList(packet, responseMessage);
        }
        this.invokeCallbacks();
        this.state = HttpsTransportState.CLOSED;
    }

    @Override
    public void addMessage(Message message, IotHubEventCallback callback, Object callbackContext) {
        if (this.state == HttpsTransportState.CLOSED) {
            throw new IllegalStateException("Cannot add a message to an HTTPS transport that is closed.");
        }
        IotHubOutboundPacket packet = new IotHubOutboundPacket(message, callback, callbackContext);
        this.waitingList.add(packet);
    }

    @Override
    public void addMessage(Message message, IotHubResponseCallback callback, Object callbackContext) {
        if (this.state == HttpsTransportState.CLOSED) {
            throw new IllegalStateException("Cannot add a message to an HTTPS transport that is closed.");
        }
        IotHubOutboundPacket packet = new IotHubOutboundPacket(message, callback, callbackContext);
        this.waitingList.add(packet);
    }

    @Override
    public void sendMessages() throws IOException {
        HttpsMessage msg;
        if (this.state == HttpsTransportState.CLOSED) {
            throw new IllegalStateException("Cannot send messages from an HTTPS transport that is closed.");
        }
        if (this.inProgressList.size() <= 0) {
            this.moveWaitingListToInProgressList();
        }
        if (this.inProgressList.size() <= 0) {
            return;
        }
        try {
            msg = this.inProgressListToMessage();
        }
        catch (IotHubSizeExceededException e) {
            throw new IllegalStateException(e);
        }
        if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN && this.config.getSasTokenAuthentication().isRenewalNecessary()) {
            this.invokeConnectionStateCallback(IotHubConnectionState.SAS_TOKEN_EXPIRED);
        }
        ResponseMessage responseMessage = this.connection.sendEvent(msg);
        this.moveInProgressListToCallbackList(responseMessage);
    }

    @Override
    public void invokeCallbacks() {
        if (this.state == HttpsTransportState.CLOSED) {
            throw new IllegalStateException("Cannot invoke callbacks from an HTTPS transport that is closed.");
        }
        while (!this.callbackList.isEmpty()) {
            IotHubResponseCallback responseCallback;
            IotHubCallbackPacket packet = this.callbackList.remove();
            Object context = packet.getContext();
            IotHubEventCallback eventCallback = packet.getCallback();
            if (eventCallback != null) {
                eventCallback.execute(packet.getStatus(), context);
            }
            if ((responseCallback = packet.getResponseCallback()) == null) continue;
            responseCallback.execute(packet.getResponseMessage(), context);
        }
    }

    @Override
    public void handleMessage() throws IOException {
        Message message;
        if (this.state == HttpsTransportState.CLOSED) {
            throw new IllegalStateException("Cannot handle a message using an HTTPS transport that is already closed.");
        }
        MessageCallback callback = this.config.getDeviceTelemetryMessageCallback();
        Object context = this.config.getDeviceTelemetryMessageContext();
        if (callback == null) {
            return;
        }
        if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN && this.config.getSasTokenAuthentication().isRenewalNecessary()) {
            this.invokeConnectionStateCallback(IotHubConnectionState.SAS_TOKEN_EXPIRED);
        }
        if ((message = this.connection.receiveMessage()) != null) {
            IotHubMessageResult result = callback.execute(message, context);
            try {
                this.connection.sendMessageResult(result);
            }
            catch (SecurityException sasTokenExpiredException) {
                this.invokeConnectionStateCallback(IotHubConnectionState.SAS_TOKEN_EXPIRED);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.waitingList.isEmpty() && this.inProgressList.isEmpty() && this.callbackList.isEmpty();
    }

    @Override
    public void registerConnectionStateCallback(IotHubConnectionStateCallback callback, Object callbackContext) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.stateCallback = callback;
        this.stateCallbackContext = callbackContext;
    }

    void invokeConnectionStateCallback(IotHubConnectionState statusCode) {
        if (this.stateCallback != null) {
            this.stateCallback.execute(statusCode, this.stateCallbackContext);
        }
    }

    private void moveWaitingListToInProgressList() {
        IotHubOutboundPacket packet;
        HttpsBatchMessage batch = new HttpsBatchMessage();
        while (!this.waitingList.isEmpty()) {
            packet = this.waitingList.peek();
            try {
                HttpsSingleMessage httpsMsg = HttpsSingleMessage.parseHttpsMessage(packet.getMessage());
                batch.addMessage(httpsMsg);
            }
            catch (IotHubSizeExceededException e) {
                break;
            }
            this.waitingList.remove();
            this.inProgressList.add(packet);
        }
        if (!this.waitingList.isEmpty() && batch.numMessages() <= 0) {
            packet = this.waitingList.remove();
            this.inProgressList.add(packet);
        }
    }

    private HttpsMessage inProgressListToMessage() throws IotHubSizeExceededException {
        HttpsMessage msg = null;
        int inProgressListSize = this.inProgressList.size();
        if (inProgressListSize < 1) {
            throw new NoSuchElementException("Cannot convert an empty in progress list to a message.");
        }
        if (inProgressListSize == 1) {
            msg = HttpsSingleMessage.parseHttpsMessage(this.inProgressList.peek().getMessage());
        } else if (this.inProgressList.size() > 1) {
            HttpsBatchMessage batch = new HttpsBatchMessage();
            for (IotHubOutboundPacket packet : this.inProgressList) {
                HttpsSingleMessage httpsMsg = HttpsSingleMessage.parseHttpsMessage(packet.getMessage());
                batch.addMessage(httpsMsg);
            }
            msg = batch;
        }
        return msg;
    }

    private void moveInProgressListToCallbackList(ResponseMessage responseMessage) {
        while (!this.inProgressList.isEmpty()) {
            IotHubOutboundPacket packet = this.inProgressList.remove();
            this.addOutboundPacketToCallbackList(packet, responseMessage);
        }
    }

    private void addOutboundPacketToCallbackList(IotHubOutboundPacket packet, ResponseMessage responseMessage) {
        IotHubResponseCallback responseCallback;
        IotHubEventCallback eventCallback = packet.getCallback();
        if (eventCallback != null) {
            IotHubCallbackPacket callbackPacket = new IotHubCallbackPacket(responseMessage.getStatus(), eventCallback, packet.getContext());
            this.callbackList.add(callbackPacket);
        }
        if ((responseCallback = packet.getResponseCallback()) != null) {
            IotHubCallbackPacket callbackPacket = new IotHubCallbackPacket(responseMessage, responseCallback, packet.getContext());
            this.callbackList.add(callbackPacket);
        }
    }

    protected static enum HttpsTransportState {
        OPEN,
        CLOSED;

    }
}

