/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.Mqtt;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttConnection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;

public class MqttDeviceTwin
extends Mqtt {
    private String subscribeTopic = "$iothub/twin/res/#";
    private final Map<String, DeviceOperations> requestMap = new HashMap<String, DeviceOperations>();
    private boolean isStarted = false;
    private final CustomLogger logger = new CustomLogger(this.getClass());
    private final String BACKSLASH = "/";
    private final String AND = "&";
    private final String QUESTION = "?";
    private final String POUND = "#";
    private final String TWIN = "$iothub/twin";
    private final String GET = "$iothub/twin/GET";
    private final String RES = "$iothub/twin/res";
    private final String PATCH = "$iothub/twin/PATCH";
    private final String PROPERTIES = "properties";
    private final String DESIRED = "desired";
    private final String REPORTED = "reported";
    private final String REQ_ID = "?$rid=";
    private final String VERSION = "$version=";
    private final int RES_TOKEN = 2;
    private final int STATUS_TOKEN = 3;
    private final int REQID_TOKEN = 4;
    private final int VERSION_TOKEN = 4;
    private final int PATCH_TOKEN = 2;
    private final int PROPERTIES_TOKEN = 3;
    private final int DESIRED_TOKEN = 4;
    private final int PATCH_VERSION_TOKEN = 5;

    public MqttDeviceTwin(MqttConnection mqttConnection) throws IOException {
        super(mqttConnection);
    }

    public void start() throws IOException {
        if (!this.isStarted) {
            this.subscribe(this.subscribeTopic);
            this.isStarted = true;
        }
    }

    public void stop() throws IOException {
        if (this.isStarted) {
            this.unsubscribe(this.subscribeTopic);
            this.isStarted = false;
        }
        if (!this.requestMap.isEmpty()) {
            this.logger.LogInfo("Pending %d responses from IotHub yet unsubscribed %s", this.requestMap.size(), this.logger.getMethodName());
        }
    }

    private String buildTopic(IotHubTransportMessage message) throws IOException {
        StringBuilder topic = new StringBuilder();
        switch (message.getDeviceOperationType()) {
            case DEVICE_OPERATION_TWIN_GET_REQUEST: {
                topic.append("$iothub/twin/GET");
                String reqid = message.getRequestId();
                if (reqid != null && reqid.length() > 0) {
                    topic.append("/");
                    topic.append("?$rid=");
                    topic.append(reqid);
                    break;
                }
                throw new IOException("Request Id is Mandatory");
            }
            case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST: {
                topic.append("$iothub/twin/PATCH");
                topic.append("/");
                topic.append("properties");
                topic.append("/");
                topic.append("reported");
                String reqid = message.getRequestId();
                if (reqid == null || reqid.length() <= 0) {
                    throw new IOException("Request Id is Mandatory");
                }
                topic.append("/");
                topic.append("?$rid=");
                topic.append(message.getRequestId());
                String version = message.getVersion();
                if (version == null) break;
                topic.append("&");
                topic.append("$version=");
                topic.append(version);
                break;
            }
            case DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                topic.append("$iothub/twin/PATCH");
                topic.append("/");
                topic.append("properties");
                topic.append("/");
                topic.append("desired");
                String version = message.getVersion();
                if (version == null) break;
                topic.append("/");
                topic.append("?");
                topic.append("$version=");
                topic.append(version);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Device Twin Operation is not supported - " + (Object)((Object)message.getDeviceOperationType()));
            }
        }
        return topic.toString();
    }

    public void send(IotHubTransportMessage message) throws IOException {
        if (message == null || message.getBytes() == null) {
            throw new IOException("Message cannot be null");
        }
        if (!this.isStarted) {
            throw new IOException("Start device twin before using it");
        }
        if (message.getMessageType() != MessageType.DEVICE_TWIN) {
            return;
        }
        String publishTopic = this.buildTopic(message);
        this.requestMap.put(message.getRequestId(), message.getDeviceOperationType());
        if (message.getDeviceOperationType() == DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST) {
            String subscribeTopic = "$iothub/twin/PATCH/properties/desired/#";
            this.subscribe(subscribeTopic);
        } else {
            this.publish(publishTopic, message.getBytes());
        }
    }

    private String getStatus(String token) throws IOException {
        if (token == null || !token.matches("\\d{3}")) {
            throw new IOException("Status could not be parsed");
        }
        String status = token;
        return status;
    }

    private String getRequestId(String token) {
        String reqId = null;
        if (token.contains("?$rid=")) {
            int startIndex = token.indexOf("?$rid=") + "?$rid=".length();
            int endIndex = token.length();
            if (token.contains("$version=")) {
                endIndex = token.indexOf("$version=") - 1;
            }
            reqId = token.substring(startIndex, endIndex);
        }
        return reqId;
    }

    private String getVersion(String token) {
        String version = null;
        if (token.contains("$version=")) {
            int startIndex = token.indexOf("$version=") + "$version=".length();
            int endIndex = token.length();
            version = token.substring(startIndex, endIndex);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Message receive() throws IOException {
        Object object = this.mqttLock;
        synchronized (object) {
            String topic;
            IotHubTransportMessage messsage = null;
            Pair<String, byte[]> messagePair = this.peekMessage();
            if (messagePair != null && (topic = (String)messagePair.getKey()) != null && topic.length() > 0 && topic.length() > "$iothub/twin".length() && topic.startsWith("$iothub/twin")) {
                byte[] data = (byte[])messagePair.getValue();
                this.allReceivedMessages.poll();
                if (topic.length() > "$iothub/twin/res".length() && topic.startsWith("$iothub/twin/res")) {
                    String[] topicTokens = topic.split(Pattern.quote("/"));
                    if (data != null && data.length > 0) {
                        messsage = new IotHubTransportMessage(data, MessageType.DEVICE_TWIN);
                        messsage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
                    } else {
                        messsage = new IotHubTransportMessage(new byte[0], MessageType.DEVICE_TWIN);
                        messsage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
                    }
                    if (topicTokens.length <= 3) {
                        throw new IOException("Message received without status");
                    }
                    messsage.setStatus(this.getStatus(topicTokens[3]));
                    if (topicTokens.length > 4) {
                        String requestId = this.getRequestId(topicTokens[4]);
                        messsage.setRequestId(requestId);
                        if (!this.requestMap.containsKey(requestId)) throw new UnsupportedOperationException();
                        switch (this.requestMap.remove(requestId)) {
                            case DEVICE_OPERATION_TWIN_GET_REQUEST: {
                                messsage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_GET_RESPONSE);
                                break;
                            }
                            case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST: {
                                messsage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_RESPONSE);
                                break;
                            }
                            default: {
                                messsage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
                                break;
                            }
                        }
                    }
                    if (topicTokens.length > 4) {
                        messsage.setVersion(this.getVersion(topicTokens[4]));
                    }
                } else {
                    if (topic.length() <= "$iothub/twin/PATCH".length() || !topic.startsWith("$iothub/twin/PATCH")) throw new UnsupportedOperationException();
                    if (!topic.startsWith("$iothub/twin/PATCH/properties/desired")) throw new UnsupportedOperationException();
                    if (data == null) {
                        throw new UnsupportedOperationException();
                    }
                    messsage = new IotHubTransportMessage(data, MessageType.DEVICE_TWIN);
                    messsage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
                    String[] topicTokens = topic.split(Pattern.quote("/"));
                    if (topicTokens.length > 5) {
                        messsage.setVersion(this.getVersion(topicTokens[5]));
                    }
                    this.logger.LogInfo("Message received on DT " + (Object)((Object)messsage.getDeviceOperationType()), new Object[0]);
                }
            }
            return messsage;
        }
    }
}

