/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.State;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttConnection;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttDeviceMethod;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttDeviceTwin;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttMessaging;
import java.io.IOException;
import java.net.URLEncoder;
import javax.net.ssl.SSLContext;

public class MqttIotHubConnection {
    private final Object MQTT_CONNECTION_LOCK = new Object();
    private final DeviceClientConfig config;
    private State state = State.CLOSED;
    private String iotHubUserName;
    private String iotHubUserPassword;
    private MqttConnection mqttConnection;
    private static final String WS_SSL_PREFIX = "wss://";
    private static final String WS_SSL_PORT_SUFFIX = ":443";
    private static final String WEBSOCKET_RAW_PATH = "/$iothub/websocket";
    private static final String WEBSOCKET_QUERY = "?iothub-no-client-cert=true";
    private static final String SSL_PREFIX = "ssl://";
    private static final String SSL_PORT_SUFFIX = ":8883";
    private static final String TWIN_API_VERSION = "api-version=2016-11-14";
    private MqttMessaging deviceMessaging;
    private MqttDeviceTwin deviceTwin;
    private MqttDeviceMethod deviceMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttIotHubConnection(DeviceClientConfig config) throws IllegalArgumentException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (config == null) {
                throw new IllegalArgumentException("The DeviceClientConfig cannot be null.");
            }
            if (config.getIotHubHostname() == null || config.getIotHubHostname().length() == 0) {
                throw new IllegalArgumentException("hostName cannot be null or empty.");
            }
            if (config.getDeviceId() == null || config.getDeviceId().length() == 0) {
                throw new IllegalArgumentException("deviceID cannot be null or empty.");
            }
            if (config.getIotHubName() == null || config.getIotHubName().length() == 0) {
                throw new IllegalArgumentException("hubName cannot be null or empty.");
            }
            if (config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN && (config.getIotHubConnectionString().getSharedAccessKey() == null || config.getIotHubConnectionString().getSharedAccessKey().isEmpty()) && (config.getSasTokenAuthentication().getCurrentSasToken() == null || config.getSasTokenAuthentication().getCurrentSasToken().isEmpty())) {
                throw new IllegalArgumentException("Must have a deviceKey, a shared access token, or x509 certificate saved.");
            }
            this.config = config;
            this.deviceMessaging = null;
            this.deviceMethod = null;
            this.deviceTwin = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (this.state == State.OPEN) {
                return;
            }
            try {
                SSLContext sslContext = null;
                if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
                    this.iotHubUserPassword = this.config.getSasTokenAuthentication().getRenewedSasToken();
                    sslContext = this.config.getSasTokenAuthentication().getSSLContext();
                } else if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
                    if (this.config.isUseWebsocket()) {
                        throw new UnsupportedOperationException("X509 authentication is not supported over MQTT_WS");
                    }
                    this.iotHubUserPassword = null;
                    sslContext = this.config.getX509Authentication().getSSLContext();
                }
                String clientIdentifier = "DeviceClientType=" + URLEncoder.encode("com.microsoft.azure.sdk.iot.iot-device-client/1.5.37", "UTF-8");
                this.iotHubUserName = this.config.getIotHubHostname() + "/" + this.config.getDeviceId() + "/" + TWIN_API_VERSION + "&" + clientIdentifier;
                if (this.config.isUseWebsocket()) {
                    String wsServerUri = WS_SSL_PREFIX + this.config.getIotHubHostname() + WEBSOCKET_RAW_PATH + WEBSOCKET_QUERY;
                    this.mqttConnection = new MqttConnection(wsServerUri, this.config.getDeviceId(), this.iotHubUserName, this.iotHubUserPassword, sslContext);
                } else {
                    String serverUri = SSL_PREFIX + this.config.getIotHubHostname() + SSL_PORT_SUFFIX;
                    this.mqttConnection = new MqttConnection(serverUri, this.config.getDeviceId(), this.iotHubUserName, this.iotHubUserPassword, sslContext);
                }
                this.deviceMessaging = new MqttMessaging(this.mqttConnection, this.config.getDeviceId());
                this.mqttConnection.setMqttCallback(this.deviceMessaging);
                this.deviceMethod = new MqttDeviceMethod(this.mqttConnection);
                this.deviceTwin = new MqttDeviceTwin(this.mqttConnection);
                this.deviceMessaging.setDeviceClientConfig(this.config);
                this.deviceMessaging.start();
                this.state = State.OPEN;
            }
            catch (Exception e) {
                this.state = State.CLOSED;
                if (this.deviceMethod != null) {
                    this.deviceMethod.stop();
                }
                if (this.deviceTwin != null) {
                    this.deviceTwin.stop();
                }
                if (this.deviceMessaging != null) {
                    this.deviceMessaging.stop();
                }
                throw new IOException(e.getMessage(), e.getCause());
            }
        }
    }

    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        try {
            this.deviceMethod.stop();
            this.deviceMethod = null;
            this.deviceTwin.stop();
            this.deviceTwin = null;
            this.deviceMessaging.stop();
            this.deviceMessaging = null;
            this.state = State.CLOSED;
        }
        catch (Exception e) {
            this.state = State.CLOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IotHubStatusCode sendEvent(Message message) throws IllegalStateException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (message == null || message.getBytes() == null || message.getMessageType() != MessageType.DEVICE_TWIN && message.getMessageType() != MessageType.DEVICE_METHODS && message.getBytes().length == 0) {
                return IotHubStatusCode.BAD_FORMAT;
            }
            if (this.state == State.CLOSED) {
                throw new IllegalStateException("Cannot send event using a closed MQTT connection");
            }
            IotHubStatusCode result = IotHubStatusCode.OK_EMPTY;
            try {
                if (message.getMessageType() == MessageType.DEVICE_METHODS) {
                    this.deviceMethod.start();
                    this.deviceMethod.send((IotHubTransportMessage)message);
                } else if (message.getMessageType() == MessageType.DEVICE_TWIN) {
                    this.deviceTwin.start();
                    this.deviceTwin.send((IotHubTransportMessage)message);
                } else {
                    this.deviceMessaging.send(message);
                }
            }
            catch (Exception e) {
                result = IotHubStatusCode.ERROR;
            }
            return result;
        }
    }

    public Message receiveMessage() throws IllegalStateException, IOException {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("The MQTT connection is currently closed. Call open() before attempting to receive a message.");
        }
        Message message = null;
        message = this.deviceMethod.receive();
        if (message == null) {
            message = this.deviceTwin.receive();
        }
        if (message == null) {
            message = this.deviceMessaging.receive();
        }
        return message;
    }
}

