/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.Mqtt;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttConnection;
import java.io.IOException;

public class MqttMessaging
extends Mqtt {
    private String subscribeTopic;
    private String publishTopic;
    private String parseTopic;

    public MqttMessaging(MqttConnection mqttConnection, String deviceId) throws IOException {
        super(mqttConnection);
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("Device id cannot be null or empty");
        }
        this.publishTopic = "devices/" + deviceId + "/messages/events/";
        this.subscribeTopic = "devices/" + deviceId + "/messages/devicebound/#";
        this.parseTopic = "devices/" + deviceId + "/messages/devicebound/";
    }

    public void start() throws IOException {
        this.connect();
        this.subscribe(this.subscribeTopic);
    }

    public void stop() throws IOException {
        this.disconnect();
    }

    public void send(Message message) throws IOException {
        String messagePublishTopic;
        if (message == null || message.getBytes() == null) {
            throw new IOException("Message cannot be null");
        }
        MessageProperty[] messageProperties = message.getProperties();
        if (messageProperties.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.publishTopic);
            boolean separatorNeeded = false;
            if (message.getMessageId() != null) {
                stringBuilder.append("$.mid");
                stringBuilder.append('=');
                stringBuilder.append(message.getMessageId());
                separatorNeeded = true;
            }
            if (message.getCorrelationId() != null) {
                if (separatorNeeded) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("$.cid");
                stringBuilder.append('=');
                stringBuilder.append(message.getCorrelationId());
                separatorNeeded = true;
            }
            if (message.getUserId() != null) {
                if (separatorNeeded) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("$.uid");
                stringBuilder.append('=');
                stringBuilder.append(message.getUserId());
                separatorNeeded = true;
            }
            if (message.getTo() != null) {
                if (separatorNeeded) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("$.to");
                stringBuilder.append('=');
                stringBuilder.append(message.getTo());
                separatorNeeded = true;
            }
            for (MessageProperty property : message.getProperties()) {
                if (separatorNeeded) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(property.getName());
                stringBuilder.append('=');
                stringBuilder.append(property.getValue());
                separatorNeeded = true;
            }
            messagePublishTopic = stringBuilder.toString();
        } else {
            messagePublishTopic = this.publishTopic;
        }
        this.publish(messagePublishTopic, message.getBytes());
    }
}

