/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectSimple;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.PersistenceLayer;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;

public class CdmArgumentDefinition
extends CdmObjectSimple {
    private CdmParameterDefinition resolvedParameter;
    private String explanation;
    private String name;
    private Object value;
    private Object unResolvedValue;
    private String declaredPath;

    public CdmArgumentDefinition(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setObjectType(CdmObjectType.ArgumentDef);
        this.name = name;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String value) {
        this.explanation = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    void setUnResolvedValue(Object unResolvedValue) {
        this.unResolvedValue = unResolvedValue;
    }

    Object getUnResolvedValue() {
        return this.unResolvedValue;
    }

    @Deprecated
    public CdmParameterDefinition getResolvedParameter() {
        return this.resolvedParameter;
    }

    @Deprecated
    public void setResolvedParameter(CdmParameterDefinition resolvedParameter) {
        this.resolvedParameter = resolvedParameter;
    }

    @Deprecated
    public CdmParameterDefinition getParameterDef() {
        return this.resolvedParameter;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return PersistenceLayer.toData(this, resOpt, options, "CdmFolder", CdmArgumentDefinition.class);
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        CdmObject value;
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges && StringUtils.isNullOrTrimEmpty(path = this.declaredPath)) {
            this.declaredPath = path = pathFrom;
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getValue() != null && this.getValue() instanceof CdmObject && (value = (CdmObject)this.getValue()).visit(path + "/value/", preChildren, postChildren)) {
            return true;
        }
        if (postChildren != null && postChildren.invoke(this, path)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmArgumentDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmArgumentDefinition(this.getCtx(), this.name);
        } else {
            copy = (CdmArgumentDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
        }
        if (this.getValue() != null) {
            if (this.getValue() instanceof CdmObject) {
                copy.setValue(((CdmObject)this.getValue()).copy(resOpt));
            } else if (this.getValue() instanceof String) {
                copy.setValue(this.getValue());
            } else {
                Logger.error(CdmArgumentDefinition.class.getSimpleName(), this.getCtx(), "Failed to copy CdmArgumentDefinition.getValue(), not recognized type");
                throw new RuntimeException("Failed to copy CdmArgumentDefinition.getValue(), not recognized type");
            }
        }
        copy.setResolvedParameter(this.resolvedParameter);
        copy.setExplanation(this.getExplanation());
        return copy;
    }

    @Override
    public boolean validate() {
        if (this.getValue() == null) {
            Logger.error(CdmArgumentDefinition.class.getSimpleName(), this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), new ArrayList<String>(Arrays.asList("value"))));
            return false;
        }
        return true;
    }
}

