/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class CdmDataPartitionDefinition
extends CdmObjectDefinitionBase
implements CdmFileStatus {
    private Map<String, List<String>> arguments;
    private String specializedSchema;
    private OffsetDateTime lastFileStatusCheckTime;
    private OffsetDateTime lastFileModifiedTime;
    private OffsetDateTime lastChildModifiedTime;
    private String name;
    private OffsetDateTime refreshTime;
    private TraitToPropertyMap t2pm;
    private String location;
    private boolean inferred;

    CdmDataPartitionDefinition(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setName(name);
        this.setObjectType(CdmObjectType.DataPartitionDef);
        this.setArguments(new LinkedHashMap<String, List<String>>());
        this.setInferred(false);
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmDataPartitionDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmDataPartitionDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmDataPartitionDefinition(this.getCtx(), this.getName());
        } else {
            copy = (CdmDataPartitionDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
        }
        copy.setDescription(this.getDescription());
        copy.setLocation(this.getLocation());
        copy.setLastFileStatusCheckTime(this.getLastFileStatusCheckTime());
        copy.setLastFileModifiedTime(this.getLastFileModifiedTime());
        copy.setInferred(this.isInferred());
        copy.setArguments(this.getArguments());
        copy.setSpecializedSchema(this.getSpecializedSchema());
        this.copyDef(resOpt, copy);
        return copy;
    }

    private TraitToPropertyMap getTraitToPropertyMap() {
        if (this.t2pm == null) {
            this.t2pm = new TraitToPropertyMap(this);
        }
        return this.t2pm;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().blockDeclaredPathChanges && (path = this.getDeclaredPath()) == null) {
            String thisName = this.getName() == null ? "UNNAMED" : this.getName();
            path = pathFrom + thisName;
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        if (postChildren != null && postChildren.invoke(this, path)) {
            return false;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String value) {
        this.location = value;
    }

    public boolean isInferred() {
        return this.inferred;
    }

    public void setInferred(boolean value) {
        this.inferred = value;
    }

    public Map<String, List<String>> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<String, List<String>> value) {
        this.arguments = value;
    }

    public String getSpecializedSchema() {
        return this.specializedSchema;
    }

    public void setSpecializedSchema(String value) {
        this.specializedSchema = value;
    }

    public String getDescription() {
        return (String)this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.DESCRIPTION);
    }

    public void setDescription(String value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.DESCRIPTION, value);
    }

    public OffsetDateTime getRefreshTime() {
        return this.refreshTime;
    }

    public void setRefreshTime(OffsetDateTime value) {
        this.refreshTime = value;
    }

    @Override
    public OffsetDateTime getLastFileStatusCheckTime() {
        return this.lastFileStatusCheckTime;
    }

    @Override
    public void setLastFileStatusCheckTime(OffsetDateTime value) {
        this.lastFileStatusCheckTime = value;
    }

    @Override
    public OffsetDateTime getLastChildFileModifiedTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLastChildFileModifiedTime(OffsetDateTime time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OffsetDateTime getLastFileModifiedTime() {
        return this.lastFileModifiedTime;
    }

    @Override
    public void setLastFileModifiedTime(OffsetDateTime value) {
        this.lastFileModifiedTime = value;
    }

    @Override
    public CompletableFuture<Void> fileStatusCheckAsync() {
        String nameSpace = this.getInDocument().getNamespace();
        String fullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getLocation(), this.getInDocument());
        OffsetDateTime modifiedTime = this.getCtx().getCorpus().computeLastModifiedTimeFromPartitionPathAsync(fullPath).join();
        this.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
        this.setLastFileModifiedTime(TimeUtils.maxTime(modifiedTime, this.getLastFileModifiedTime()));
        return this.reportMostRecentTimeAsync(this.getLastFileModifiedTime());
    }

    @Override
    public CompletableFuture<Void> reportMostRecentTimeAsync(OffsetDateTime childTime) {
        if (this.getOwner() instanceof CdmFileStatus && childTime != null) {
            return ((CdmFileStatus)this.getOwner()).reportMostRecentTimeAsync(childTime);
        }
        return CompletableFuture.completedFuture(null);
    }
}

