/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import java.util.List;
import java.util.Objects;

public class CdmTraitCollection
extends CdmCollection<CdmTraitReference> {
    public CdmTraitCollection(CdmCorpusContext ctx, CdmObject owner) {
        super(ctx, owner, CdmObjectType.TraitRef);
    }

    @Override
    public void add(int index, CdmTraitReference cdmTraitReference) {
        this.clearCache();
        super.add(index, cdmTraitReference);
    }

    @Override
    public CdmTraitReference add(String name) {
        return this.add(name, false);
    }

    @Override
    public CdmTraitReference add(String name, boolean simpleRef) {
        this.clearCache();
        return (CdmTraitReference)super.add(name, simpleRef);
    }

    @Override
    public CdmTraitReference add(CdmTraitReference cdmTraitReference) {
        this.clearCache();
        return super.add(cdmTraitReference);
    }

    @Override
    public CdmTraitReference add(CdmTraitDefinition traitDefinition) {
        return this.add(traitDefinition, false);
    }

    public CdmTraitReference add(CdmTraitDefinition traitDefinition, boolean simpleRef) {
        this.clearCache();
        CdmTraitReference traitReference = new CdmTraitReference(this.getCtx(), traitDefinition, simpleRef, false);
        super.add(traitReference);
        return traitReference;
    }

    @Override
    public boolean remove(CdmTraitDefinition traitDefToRemove) {
        return this.remove(traitDefToRemove, false);
    }

    public boolean remove(CdmTraitDefinition traitDefToRemove, boolean onlyFromProperty) {
        String traitName = traitDefToRemove.getTraitName();
        return this.remove(traitName, onlyFromProperty);
    }

    @Override
    public void removeAt(int index) {
        this.clearCache();
        super.removeAt(index);
    }

    @Override
    public boolean remove(String traitName) {
        return this.remove(traitName, false);
    }

    public boolean remove(String traitName, boolean onlyFromProperty) {
        this.makeDocumentDirty();
        CdmTraitReference foundTraitNotFromProperty = null;
        this.clearCache();
        for (CdmTraitReference trait : this.getAllItems()) {
            if (!this.corresponds(trait, traitName)) continue;
            if (trait.isFromProperty()) {
                this.propagateInDocument(trait, null);
                return this.getAllItems().remove(trait);
            }
            foundTraitNotFromProperty = trait;
        }
        if (!onlyFromProperty && foundTraitNotFromProperty != null) {
            this.propagateInDocument(foundTraitNotFromProperty, null);
            return this.getAllItems().remove(foundTraitNotFromProperty);
        }
        return false;
    }

    @Override
    public boolean remove(CdmTraitReference traitToRemove) {
        return this.remove(traitToRemove, false);
    }

    public boolean remove(CdmTraitReference traitToRemove, boolean onlyFromProperty) {
        String traitName = traitToRemove.fetchObjectDefinitionName();
        return this.remove(traitName, onlyFromProperty);
    }

    @Override
    public void clear() {
        this.clearCache();
        super.clear();
    }

    public int indexOf(CdmTraitDefinition traitDefinition) {
        return this.indexOf(traitDefinition, false);
    }

    public int indexOf(CdmTraitDefinition traitDefinition, boolean onlyFromProperty) {
        String traitName = traitDefinition.getTraitName();
        return this.indexOf(traitName, onlyFromProperty);
    }

    public int indexOf(String traitName) {
        return this.indexOf(traitName, false);
    }

    public int indexOf(String traitName, boolean onlyFromProperty) {
        int indexOfTraitNotFromProperty = -1;
        for (int index = 0; index < this.getAllItems().size(); ++index) {
            if (!this.corresponds((CdmTraitReference)this.getAllItems().get(index), traitName)) continue;
            if (((CdmTraitReference)this.getAllItems().get(index)).isFromProperty()) {
                return index;
            }
            indexOfTraitNotFromProperty = index;
        }
        if (!onlyFromProperty) {
            return indexOfTraitNotFromProperty;
        }
        return -1;
    }

    public int indexOf(CdmTraitReference trait, boolean onlyFromProperty) {
        String traitName = trait.fetchObjectDefinitionName();
        return this.indexOf(traitName, onlyFromProperty);
    }

    @Override
    public void addAll(List<CdmTraitDefinition> traitList) {
        this.addAll(traitList, false);
    }

    public void addAll(List<CdmTraitDefinition> traitList, boolean simpleRef) {
        traitList.forEach(this::add);
    }

    private boolean corresponds(CdmTraitReference traitReference, String traitName) {
        return Objects.equals(traitReference.fetchObjectDefinitionName(), traitName);
    }

    private void clearCache() {
        if (this.getOwner() instanceof CdmObjectBase) {
            CdmObjectBase owner = (CdmObjectBase)this.getOwner();
            owner.clearTraitCache();
        }
    }
}

