/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.CdmFolderType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DocumentPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ManifestPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.common.PersistenceType;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ModelJsonType;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapter;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StorageUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class PersistenceLayer {
    final CdmCorpusDefinition corpus;
    final CdmCorpusContext ctx;
    public static final String cdmFolder = "CdmFolder";
    public static final String modelJson = "ModelJson";
    public static final String odi = "Odi";
    private static final Map<String, PersistenceType> persistenceTypeMap = new LinkedHashMap<String, PersistenceType>();
    private ConcurrentHashMap<String, Class> registeredPersistenceFormats;
    private ConcurrentHashMap<Class, Boolean> isRegisteredPersistenceAsync;

    public PersistenceLayer(CdmCorpusDefinition corpus) {
        this.corpus = corpus;
        this.ctx = this.corpus.getCtx();
        this.registeredPersistenceFormats = new ConcurrentHashMap();
        this.isRegisteredPersistenceAsync = new ConcurrentHashMap();
        this.registerFormat(ManifestPersistence.class.getCanonicalName());
        this.registerFormat(com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ManifestPersistence.class.getCanonicalName());
        this.registerFormat(DocumentPersistence.class.getCanonicalName());
        this.registerFormat("com.microsoft.commondatamodel.objectmodel.persistence.odi.ManifestPersistence");
    }

    public static <T extends CdmObject, U> CdmObject fromData(CdmCorpusContext ctx, U obj, String persistenceTypeName, Class<T> classInterface) {
        Class persistenceClass = PersistenceLayer.findPersistenceClass(persistenceTypeName, classInterface);
        try {
            Method method = persistenceClass.getMethod("fromData", CdmCorpusContext.class, obj.getClass());
            return (CdmObject)method.invoke(null, ctx, obj);
        }
        catch (NoSuchMethodException e) {
            String persistenceClassName = classInterface.getName();
            throw new RuntimeException("Persistence class " + persistenceClassName + " in type " + persistenceTypeName + " does not implement ToData.", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            String persistenceClassName = classInterface.getName();
            throw new RuntimeException("Persistence class " + persistenceClassName + " in type " + persistenceTypeName + " fail to call toData.", e);
        }
    }

    public static <T extends CdmObject> Object toData(T instance, ResolveOptions resOpt, CopyOptions options, String persistenceTypeName, Class<T> classInterface) {
        Class persistenceClass = PersistenceLayer.findPersistenceClass(persistenceTypeName, classInterface);
        try {
            Method method = persistenceClass.getMethod("toData", classInterface, ResolveOptions.class, CopyOptions.class);
            return method.invoke(null, instance, resOpt, options);
        }
        catch (NoSuchMethodException e) {
            String persistenceClassName = classInterface.getName();
            throw new RuntimeException("Persistence class " + persistenceClassName + " in type " + persistenceTypeName + " does not implement toData.", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            String persistenceClassName = classInterface.getName();
            throw new RuntimeException("Persistence class " + persistenceClassName + " in type " + persistenceTypeName + " fail to call toData.", e);
        }
    }

    public static <T extends CdmObject> Class findPersistenceClass(String persistenceTypeName, Class<T> classInterface) {
        if (persistenceTypeMap.containsKey(persistenceTypeName)) {
            Class persistenceClass = persistenceTypeMap.get(persistenceTypeName).getRegisteredClasses().getPersistenceClass(classInterface);
            if (persistenceClass == null) {
                throw new RuntimeException("Persistence class for " + classInterface.getName() + " is not implemented in type " + persistenceTypeName + ".");
            }
            return persistenceClass;
        }
        throw new RuntimeException("Persistence type " + persistenceTypeName + " not implemented.");
    }

    @Deprecated
    public CompletableFuture<CdmDocumentDefinition> loadDocumentFromPathAsync(CdmFolderDefinition folder, String docName, CdmDocumentDefinition docContainer) {
        return this.loadDocumentFromPathAsync(folder, docName, docContainer, null);
    }

    @Deprecated
    public CompletableFuture<CdmDocumentDefinition> loadDocumentFromPathAsync(CdmFolderDefinition folder, String docName, CdmDocumentDefinition docContainer, ResolveOptions resOpt) {
        return CompletableFuture.supplyAsync(() -> {
            CdmDocumentDefinition docContent;
            String jsonData = null;
            OffsetDateTime fsModifiedTime = null;
            String docPath = folder.getFolderPath() + docName;
            StorageAdapter adapter = this.corpus.getStorage().fetchAdapter(folder.getNamespace());
            try {
                if (!adapter.canRead()) {
                    throw new Exception("Storage Adapter is not enabled to read.");
                }
                Logger.debug(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("request file: {0}", docPath), "loadDocumentFromPathAsync");
                jsonData = adapter.readAsync(docPath).join();
                Logger.debug(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("received file: {0}", docPath), "loadDocumentFromPathAsync");
            }
            catch (Exception e) {
                Logger.debug(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("fail file: {0}", docPath), "loadDocumentFromPathAsync");
                String message = Logger.format("Could not read '{0}' from the '{1}' namespace. Reason '{2}'", docPath, folder.getNamespace(), e.getLocalizedMessage());
                if (resOpt != null && resOpt.getShallowValidation()) {
                    Logger.warning(PersistenceLayer.class.getSimpleName(), this.ctx, message, "loadDocumentFromPathAsync");
                } else {
                    Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, message, "loadDocumentFromPathAsync");
                }
                return null;
            }
            try {
                fsModifiedTime = adapter.computeLastModifiedTimeAsync(docPath).join();
            }
            catch (Exception e) {
                Logger.warning(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Failed to compute file last modified time. Reason '{0}'", e.getLocalizedMessage()), "loadDocumentFromPathAsync");
            }
            if (StringUtils.isEmpty((CharSequence)docName)) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, "Document name cannot be null or empty.", "loadDocumentFromPathAsync");
                return null;
            }
            if (StringUtils.endsWithIgnoreCase((CharSequence)docName, (CharSequence)"odi.json") && !StringUtils.equalsIgnoreCase((CharSequence)docName, (CharSequence)"odi.json")) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Failed to load '{0}', as it's not an acceptable file name. It must be {1}.", docName, "odi.json"), "loadDocumentFromPathAsync");
                return null;
            }
            if (StringUtils.endsWithIgnoreCase((CharSequence)docName, (CharSequence)"model.json") && !StringUtils.equalsIgnoreCase((CharSequence)docName, (CharSequence)"model.json")) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Failed to load '{0}', as it's not an acceptable file name. It must be {1}.", docName, "model.json"), "loadDocumentFromPathAsync");
                return null;
            }
            Class persistenceClass = this.fetchRegisteredPersistenceFormat(docName);
            if (persistenceClass != null) {
                try {
                    Method method = persistenceClass.getMethod("fromData", CdmCorpusContext.class, String.class, String.class, CdmFolderDefinition.class);
                    if (!this.isRegisteredPersistenceAsync.containsKey(persistenceClass)) {
                        this.isRegisteredPersistenceAsync.put(persistenceClass, (boolean)((Boolean)persistenceClass.getField("isPersistenceAsync").get(null)));
                    }
                    if (this.isRegisteredPersistenceAsync.get(persistenceClass).booleanValue()) {
                        CompletableFuture task = (CompletableFuture)method.invoke(null, this.ctx, docName, jsonData, folder);
                        docContent = (CdmDocumentDefinition)task.join();
                    }
                    docContent = (CdmDocumentDefinition)method.invoke(null, this.ctx, docName, jsonData, folder);
                }
                catch (Exception e) {
                    Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Could not convert '{0}'. Reason '{1}'.", docName, e.getLocalizedMessage()), "loadDocumentFromPathAsync");
                    return null;
                }
            } else {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Could not find a persistence class to handle the file '{0}'.", docName), "loadDocumentFromPathAsync");
                return null;
            }
            if (docContent != null) {
                if (docContainer != null) {
                    docContent = (CdmDocumentDefinition)docContent.copy(new ResolveOptions(docContainer, this.ctx.getCorpus().getDefaultResolutionDirectives()), docContainer);
                }
                folder.getDocuments().add(docContent, docName);
                docContent.setFileSystemModifiedTime(fsModifiedTime);
                docContent.setDirty(false);
            }
            return docContent;
        });
    }

    @Deprecated
    public CompletableFuture<Boolean> saveDocumentAsAsync(CdmDocumentDefinition doc, String newName) {
        return this.saveDocumentAsAsync(doc, newName, false);
    }

    @Deprecated
    public CompletableFuture<Boolean> saveDocumentAsAsync(CdmDocumentDefinition doc, String newName, boolean saveReferenced) {
        return this.saveDocumentAsAsync(doc, newName, saveReferenced, null);
    }

    @Deprecated
    public CompletableFuture<Boolean> saveDocumentAsAsync(CdmDocumentDefinition doc, String newName, boolean saveReferenced, CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            Object persistedDoc;
            String persistenceType;
            StorageAdapter adapter;
            String ns = doc.getNamespace();
            if (StringUtils.isEmpty((CharSequence)ns)) {
                ns = this.corpus.getStorage().getDefaultNamespace();
            }
            if ((adapter = this.corpus.getStorage().fetchAdapter(ns)) == null) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Couldn't find a storage adapter registered for the namespace '{0}'", ns), "saveDocumentAsAsync");
                return false;
            }
            if (!adapter.canWrite()) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("The storage adapter '{0}' claims it is unable to write files.", ns), "saveDocumentAsAsync");
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)newName)) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, "Document name cannot be null or empty.", "saveDocumentAsAsync");
                return false;
            }
            String string = StringUtils.endsWithIgnoreCase((CharSequence)newName, (CharSequence)"model.json") ? modelJson : (persistenceType = StringUtils.endsWithIgnoreCase((CharSequence)newName, (CharSequence)"odi.json") ? odi : cdmFolder);
            if (persistenceType == odi && !StringUtils.equalsIgnoreCase((CharSequence)newName, (CharSequence)"odi.json")) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Failed to persist '{0}', as it's not an acceptable filename.  It must be {1}.", newName, "odi.json"), "saveDocumentAsAsync");
                return false;
            }
            if (persistenceType == modelJson && !StringUtils.equalsIgnoreCase((CharSequence)newName, (CharSequence)"model.json")) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Failed to persist '{0}', as it's not an acceptable filename.  It must be {1}.", newName, "model.json"), "saveDocumentAsAsync");
                return false;
            }
            ResolveOptions resOpt = new ResolveOptions(doc);
            Class persistenceClass = this.fetchRegisteredPersistenceFormat(newName);
            if (persistenceClass != null) {
                try {
                    Method method = StringUtils.endsWithIgnoreCase((CharSequence)newName, (CharSequence)"odi.json") || StringUtils.endsWithIgnoreCase((CharSequence)newName, (CharSequence)"model.json") || StringUtils.endsWithIgnoreCase((CharSequence)newName, (CharSequence)".manifest.cdm.json") || StringUtils.endsWithIgnoreCase((CharSequence)newName, (CharSequence)".folio.cdm.json") ? persistenceClass.getMethod("toData", CdmManifestDefinition.class, ResolveOptions.class, CopyOptions.class) : persistenceClass.getMethod("toData", CdmDocumentDefinition.class, ResolveOptions.class, CopyOptions.class);
                    if (!this.isRegisteredPersistenceAsync.containsKey(persistenceClass)) {
                        this.isRegisteredPersistenceAsync.put(persistenceClass, (boolean)((Boolean)persistenceClass.getField("isPersistenceAsync").get(null)));
                    }
                    if (this.isRegisteredPersistenceAsync.get(persistenceClass).booleanValue()) {
                        CompletableFuture task = (CompletableFuture)method.invoke(null, doc, resOpt, options);
                        persistedDoc = task.join();
                    }
                    persistedDoc = method.invoke(null, doc, resOpt, options);
                }
                catch (Exception e) {
                    Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Could not persist file '{0}'. Reason '{1}'.", newName, e.getLocalizedMessage()), "saveDocumentAsAsync");
                    return false;
                }
            } else {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Could not find a persistence class to handle the file '{0}'.", newName), "saveDocumentAsAsync");
                return false;
            }
            if (persistedDoc == null) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Failed to persist '{0}'", newName), "saveDocumentAsAsync");
                return false;
            }
            if (persistenceType.equals(odi)) {
                this.saveOdiDocumentsAsync(persistedDoc, adapter, newName).join();
                return true;
            }
            String newPath = doc.getFolderPath() + newName;
            newPath = this.corpus.getStorage().createAbsoluteCorpusPath(newPath, doc);
            if (newPath.startsWith(ns + ":")) {
                newPath = newPath.substring(ns.length() + 1);
            }
            try {
                adapter.writeAsync(newPath, JMapper.WRITER.writeValueAsString(persistedDoc)).join();
                doc.setFileSystemModifiedTime(adapter.computeLastModifiedTimeAsync(newPath).join());
                if (options.isTopLevelDocument()) {
                    this.corpus.getStorage().saveAdapterConfigAsync("/config.json", adapter).join();
                    options.setTopLevelDocument(false);
                }
            }
            catch (Exception e) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Failed to write to the file '{0}' for reason {1}.", newName, e.getLocalizedMessage()), "saveDocumentAsAsync");
                return false;
            }
            if (saveReferenced && persistenceType.equals(cdmFolder) && !doc.saveLinkedDocumentsAsync(options).join().booleanValue()) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Failed to save linked documents for file '{0}'", newName), "saveDocumentAsAsync");
                return false;
            }
            return true;
        });
    }

    CompletableFuture<Void> saveOdiDocumentsAsync(Object doc, StorageAdapter adapter, String newName) {
        return CompletableFuture.runAsync(() -> {
            if (doc == null) {
                throw new IllegalArgumentException("Document is null");
            }
            String oldDocumentPath = null;
            try {
                Class<?> odiDocumentClass = Class.forName("com.microsoft.commondatamodel.objectmodel.persistence.odi.types.Document");
                oldDocumentPath = (String)odiDocumentClass.getMethod("getDocumentPath", new Class[0]).invoke(doc, new Object[0]);
                String newDocumentPath = oldDocumentPath.substring(0, oldDocumentPath.length() - "odi.json".length()) + newName;
                ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(newDocumentPath);
                if (pathTuple == null) {
                    Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, "The object path cannot be null or empty.", "saveOdiDocumentsAsync");
                    return;
                }
                adapter.writeAsync((String)pathTuple.getRight(), JMapper.MAP.writeValueAsString(doc)).join();
                List linkedDocuments = (List)odiDocumentClass.getMethod("getLinkedDocuments", new Class[0]).invoke(doc, new Object[0]);
                if (linkedDocuments != null) {
                    linkedDocuments.forEach(linkedDoc -> this.saveOdiDocumentsAsync(linkedDoc, adapter, newName).join());
                }
            }
            catch (Exception e) {
                Logger.error(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Failed to write to the file '{0}' for reason {1}", oldDocumentPath, e.getMessage()), "saveOdiDocumentsAsync");
            }
        });
    }

    public void registerFormat(String persistenceClassName) {
        this.registerFormat(persistenceClassName, null);
    }

    public void registerFormat(String persistenceClassName, String assemblyName) {
        try {
            String[] formats;
            Class<?> persistenceClass = Class.forName(persistenceClassName);
            for (String format : formats = (String[])persistenceClass.getField("formats").get(null)) {
                this.registeredPersistenceFormats.put(format, persistenceClass);
            }
        }
        catch (Exception e) {
            Logger.info(PersistenceLayer.class.getSimpleName(), this.ctx, Logger.format("Unable to register persistence class {0}. Reason: {1}.", persistenceClassName, e.getLocalizedMessage()), "registerFormat");
        }
    }

    private Class fetchRegisteredPersistenceFormat(String docName) {
        TreeSet<String> sortedKeys = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                if (a.length() > b.length()) {
                    return -1;
                }
                return 1;
            }
        });
        sortedKeys.addAll(this.registeredPersistenceFormats.keySet());
        for (String key : sortedKeys) {
            Class registeredPersistenceFormat = this.registeredPersistenceFormats.get(key);
            if (registeredPersistenceFormat == null || !StringUtils.endsWithIgnoreCase((CharSequence)docName, (CharSequence)key)) continue;
            return registeredPersistenceFormat;
        }
        return null;
    }

    static {
        persistenceTypeMap.put(cdmFolder, new CdmFolderType());
        persistenceTypeMap.put(modelJson, new ModelJsonType());
    }
}

