/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.AttributeGroupPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ConstantEntityPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataTypePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DocumentPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.E2ERelationshipPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.EntityPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ImportPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.LocalEntityDeclarationPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ManifestDeclarationPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.PurposePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ReferencedEntityDeclarationPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.TraitPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DataType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DocumentContent;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.E2ERelationship;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.Import;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.LocalEntityDeclaration;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.ManifestContent;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.ManifestDeclaration;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Collectors;

public class ManifestPersistence {
    public static final boolean isPersistenceAsync = false;
    public static final String[] formats = new String[]{".manifest.cdm.json", ".folio.cdm.json"};

    public static CdmManifestDefinition fromObject(CdmCorpusContext ctx, String name, String nameSpace, String path, ManifestContent dataObj) {
        String manifestName = ManifestPersistence.extractManifestName(dataObj, name);
        CdmManifestDefinition manifest = (CdmManifestDefinition)ctx.getCorpus().makeObject(CdmObjectType.ManifestDef, manifestName);
        manifest.setName(name);
        manifest.setFolderPath(path);
        manifest.setNamespace(nameSpace);
        manifest.setExplanation(dataObj.getExplanation());
        if (!Strings.isNullOrEmpty((String)dataObj.getSchema())) {
            manifest.setSchema(dataObj.getSchema());
        }
        if (!Strings.isNullOrEmpty((String)dataObj.getJsonSchemaSemanticVersion())) {
            manifest.setJsonSchemaSemanticVersion(dataObj.getJsonSchemaSemanticVersion());
        }
        if (!Strings.isNullOrEmpty((String)dataObj.getManifestName())) {
            manifest.setManifestName(dataObj.getManifestName());
        }
        if (dataObj.getExhibitsTraits() != null) {
            Utils.addListToCdmCollection(manifest.getExhibitsTraits(), Utils.createTraitReferenceList(ctx, dataObj.getExhibitsTraits()));
        }
        if (dataObj.getImports() != null) {
            for (Import import_ : dataObj.getImports()) {
                manifest.getImports().add(Objects.requireNonNull(ImportPersistence.fromData(ctx, import_)));
            }
        }
        if (dataObj.getDefinitions() != null) {
            for (JsonNode jsonNode : dataObj.getDefinitions()) {
                if (jsonNode.has("dataTypeName")) {
                    manifest.getDefinitions().add(DataTypePersistence.fromData(ctx, (DataType)JMapper.MAP.convertValue((Object)jsonNode, DataType.class)));
                    continue;
                }
                if (jsonNode.has("purposeName")) {
                    manifest.getDefinitions().add(PurposePersistence.fromData(ctx, jsonNode));
                    continue;
                }
                if (jsonNode.has("attributeGroupName")) {
                    manifest.getDefinitions().add(AttributeGroupPersistence.fromData(ctx, jsonNode));
                    continue;
                }
                if (jsonNode.has("traitName")) {
                    manifest.getDefinitions().add(TraitPersistence.fromData(ctx, jsonNode));
                    continue;
                }
                if (jsonNode.has("entityShape")) {
                    manifest.getDefinitions().add(ConstantEntityPersistence.fromData(ctx, jsonNode));
                    continue;
                }
                if (!jsonNode.has("entityName")) continue;
                manifest.getDefinitions().add(EntityPersistence.fromData(ctx, jsonNode));
            }
        }
        if (dataObj.getLastFileStatusCheckTime() != null) {
            manifest.setLastFileStatusCheckTime(dataObj.getLastFileStatusCheckTime());
        }
        if (dataObj.getLastFileModifiedTime() != null) {
            manifest.setLastFileModifiedTime(dataObj.getLastFileModifiedTime());
        }
        if (dataObj.getLastChildFileModifiedTime() != null) {
            manifest.setLastChildFileModifiedTime(dataObj.getLastChildFileModifiedTime());
        }
        if (dataObj.getEntities() != null) {
            String fullPath = !Strings.isNullOrEmpty((String)nameSpace) ? nameSpace + ":" + path : path;
            for (JsonNode entityNode : dataObj.getEntities()) {
                CdmEntityDeclarationDefinition entity = null;
                try {
                    if (entityNode.has("type")) {
                        String type = entityNode.get("type").asText();
                        if ("LocalEntity".equals(type)) {
                            entity = LocalEntityDeclarationPersistence.fromData(ctx, fullPath, (LocalEntityDeclaration)JMapper.MAP.treeToValue((TreeNode)entityNode, LocalEntityDeclaration.class));
                        } else if ("ReferencedEntity".equals(type)) {
                            entity = ReferencedEntityDeclarationPersistence.fromData(ctx, fullPath, entityNode);
                        } else {
                            Logger.error(ManifestPersistence.class.getSimpleName(), ctx, "Couldn't find the type for entity declaration", "fromObject");
                        }
                    } else {
                        entity = entityNode.has("entitySchema") ? LocalEntityDeclarationPersistence.fromData(ctx, fullPath, (LocalEntityDeclaration)JMapper.MAP.treeToValue((TreeNode)entityNode, LocalEntityDeclaration.class)) : ReferencedEntityDeclarationPersistence.fromData(ctx, fullPath, entityNode);
                    }
                    manifest.getEntities().add(entity);
                }
                catch (IOException ex) {
                    Logger.error(ManifestPersistence.class.getSimpleName(), ctx, Logger.format("Failed to deserialize entity declaration. Reason: '{0}'", ex.getLocalizedMessage()), "fromObject");
                }
            }
        }
        if (dataObj.getRelationships() != null) {
            for (E2ERelationship e2ERelationship : dataObj.getRelationships()) {
                manifest.getRelationships().add(E2ERelationshipPersistence.fromData(ctx, e2ERelationship));
            }
        }
        if (dataObj.getSubManifests() == null) {
            return manifest;
        }
        for (ManifestDeclaration manifestDeclaration : dataObj.getSubManifests()) {
            manifest.getSubManifests().add(ManifestDeclarationPersistence.fromData(ctx, manifestDeclaration));
        }
        return manifest;
    }

    public static CdmManifestDefinition fromData(CdmCorpusContext ctx, String docName, String jsonData, CdmFolderDefinition folder) {
        try {
            ManifestContent dataObj = (ManifestContent)JMapper.MAP.readValue(jsonData, ManifestContent.class);
            return ManifestPersistence.fromObject(ctx, docName, folder.getNamespace(), folder.getFolderPath(), dataObj);
        }
        catch (Exception e) {
            Logger.error(ManifestPersistence.class.getSimpleName(), ctx, Logger.format("Could not convert '{0}'. Reason '{1}'.", docName, e.getLocalizedMessage()), "fromData");
            return null;
        }
    }

    public static ManifestContent toData(CdmManifestDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        DocumentContent documentContent = DocumentPersistence.toData(instance, resOpt, options);
        ManifestContent manifestContent = new ManifestContent();
        manifestContent.setManifestName(instance.getManifestName());
        manifestContent.setJsonSchemaSemanticVersion(documentContent.getJsonSchemaSemanticVersion());
        manifestContent.setSchema(documentContent.getSchema());
        manifestContent.setImports(documentContent.getImports());
        manifestContent.setLastFileStatusCheckTime(instance.getLastFileStatusCheckTime());
        manifestContent.setLastFileModifiedTime(instance.getLastFileModifiedTime());
        manifestContent.setLastChildFileModifiedTime(instance.getLastChildFileModifiedTime());
        manifestContent.setEntities(Utils.listCopyDataAsArrayNode(instance.getEntities().getAllItems(), resOpt, options));
        manifestContent.setSubManifests(Utils.listCopyDataAsCdmObject(instance.getSubManifests(), resOpt, options));
        manifestContent.setExplanation(instance.getExplanation());
        manifestContent.setExhibitsTraits(Utils.listCopyDataAsArrayNode(instance.getExhibitsTraits(), resOpt, options));
        if (instance.getRelationships() != null && instance.getRelationships().getCount() > 0) {
            manifestContent.setRelationships(instance.getRelationships().getAllItems().stream().map(E2ERelationshipPersistence::toData).collect(Collectors.toList()));
        }
        return manifestContent;
    }

    private static String extractManifestName(ManifestContent dataObj, String name) {
        String manifestName = dataObj.getManifestName();
        if (!Strings.isNullOrEmpty((String)manifestName)) {
            return manifestName;
        }
        return name.contains(".manifest.cdm.json") ? name.replace(".manifest.cdm.json", "") : name.replace(".folio.cdm.json", "");
    }
}

