/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.resolvedmodel;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeResolutionGuidance;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.AttributeResolutionApplierCapabilities;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionApplier;
import com.microsoft.commondatamodel.objectmodel.utilities.PrimitiveAppliers;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class AttributeResolutionContext {
    private List<AttributeResolutionApplier> actionsModify;
    private List<AttributeResolutionApplier> actionsGroupAdd;
    private List<AttributeResolutionApplier> actionsRoundAdd;
    private List<AttributeResolutionApplier> actionsAttributeAdd;
    private List<AttributeResolutionApplier> actionsRemove;
    private ResolvedTraitSet traitsToApply;
    private AttributeResolutionApplierCapabilities applierCaps;
    private CdmAttributeResolutionGuidance resGuide;
    private ResolveOptions resOpt;

    public AttributeResolutionContext(ResolveOptions resOpt, CdmAttributeResolutionGuidance resGuide, ResolvedTraitSet traits) {
        this.traitsToApply = traits;
        this.resGuide = resGuide;
        this.resOpt = resOpt;
        this.actionsModify = new ArrayList<AttributeResolutionApplier>();
        this.actionsGroupAdd = new ArrayList<AttributeResolutionApplier>();
        this.actionsRoundAdd = new ArrayList<AttributeResolutionApplier>();
        this.actionsAttributeAdd = new ArrayList<AttributeResolutionApplier>();
        this.actionsRemove = new ArrayList<AttributeResolutionApplier>();
        this.applierCaps = null;
        this.resOpt = resOpt.copy();
        if (resGuide != null) {
            if (this.applierCaps == null) {
                this.applierCaps = new AttributeResolutionApplierCapabilities();
                this.applierCaps.canAlterDirectives = false;
                this.applierCaps.canAlterDirectives = false;
                this.applierCaps.canCreateContext = false;
                this.applierCaps.canRemove = false;
                this.applierCaps.canAttributeModify = false;
                this.applierCaps.canGroupAdd = false;
                this.applierCaps.canRoundAdd = false;
                this.applierCaps.canAttributeAdd = false;
            }
            if (resGuide.getRemoveAttribute() != null) {
                this.addApplier(PrimitiveAppliers.isRemoved);
            }
            if (resGuide.getImposedDirectives() != null) {
                this.addApplier(PrimitiveAppliers.doesImposeDirectives);
            }
            if (resGuide.getRemovedDirectives() != null) {
                this.addApplier(PrimitiveAppliers.doesRemoveDirectives);
            }
            if (resGuide.getAddSupportingAttribute() != null) {
                this.addApplier(PrimitiveAppliers.doesAddSupportingAttribute);
            }
            if (resGuide.getRenameFormat() != null) {
                this.addApplier(PrimitiveAppliers.doesDisambiguateNames);
            }
            if (resGuide.getCardinality() != null && resGuide.getCardinality().equals("many")) {
                this.addApplier(PrimitiveAppliers.doesExplainArray);
            }
            if (resGuide.getEntityByReference() != null) {
                this.addApplier(PrimitiveAppliers.doesReferenceEntityVia);
            }
            if (resGuide.getSelectsSubAttribute() != null && resGuide.getSelectsSubAttribute().getSelects().equals("one")) {
                this.addApplier(PrimitiveAppliers.doesSelectAttributes);
            }
            ApplierPriorityComparator comparator = new ApplierPriorityComparator();
            this.actionsModify.sort(comparator);
            this.actionsGroupAdd.sort(comparator);
            this.actionsRoundAdd.sort(comparator);
            this.actionsAttributeAdd.sort(comparator);
        }
    }

    private boolean addApplier(AttributeResolutionApplier apl) {
        if (this.applierCaps == null) {
            this.applierCaps = new AttributeResolutionApplierCapabilities();
        }
        if (apl.willAttributeModify != null && apl.doAttributeModify != null) {
            this.actionsModify.add(apl);
            this.applierCaps.canAttributeModify = true;
        }
        if (apl.willAttributeAdd != null && apl.doAttributeAdd != null) {
            this.actionsAttributeAdd.add(apl);
            this.applierCaps.canAttributeAdd = true;
        }
        if (apl.willGroupAdd != null && apl.doGroupAdd != null) {
            this.actionsGroupAdd.add(apl);
            this.applierCaps.canGroupAdd = true;
        }
        if (apl.willRoundAdd != null && apl.doRoundAdd != null) {
            this.actionsRoundAdd.add(apl);
            this.applierCaps.canRoundAdd = true;
        }
        if (apl.willAlterDirectives != null && apl.doAlterDirectives != null) {
            this.applierCaps.canAlterDirectives = true;
            apl.doAlterDirectives.accept(this.resOpt, this.resGuide);
        }
        if (apl.willCreateContext != null && apl.doCreateContext != null) {
            this.applierCaps.canCreateContext = true;
        }
        if (apl.willRemove != null) {
            this.actionsRemove.add(apl);
            this.applierCaps.canRemove = true;
        }
        return true;
    }

    public List<AttributeResolutionApplier> getActionsModify() {
        return this.actionsModify;
    }

    public void setActionsModify(List<AttributeResolutionApplier> actionsModify) {
        this.actionsModify = actionsModify;
    }

    public List<AttributeResolutionApplier> getActionsGroupAdd() {
        return this.actionsGroupAdd;
    }

    public void setActionsGroupAdd(List<AttributeResolutionApplier> actionsGroupAdd) {
        this.actionsGroupAdd = actionsGroupAdd;
    }

    public List<AttributeResolutionApplier> getActionsRoundAdd() {
        return this.actionsRoundAdd;
    }

    public void setActionsRoundAdd(List<AttributeResolutionApplier> actionsRoundAdd) {
        this.actionsRoundAdd = actionsRoundAdd;
    }

    public List<AttributeResolutionApplier> getActionsAttributeAdd() {
        return this.actionsAttributeAdd;
    }

    public void setActionsAttributeAdd(List<AttributeResolutionApplier> actionsAttributeAdd) {
        this.actionsAttributeAdd = actionsAttributeAdd;
    }

    public List<AttributeResolutionApplier> getActionsRemove() {
        return this.actionsRemove;
    }

    public void setActionsRemove(List<AttributeResolutionApplier> actionsRemove) {
        this.actionsRemove = actionsRemove;
    }

    ResolvedTraitSet getTraitsToApply() {
        return this.traitsToApply;
    }

    public AttributeResolutionApplierCapabilities getApplierCaps() {
        return this.applierCaps;
    }

    public void setApplierCaps(AttributeResolutionApplierCapabilities applierCaps) {
        this.applierCaps = applierCaps;
    }

    public CdmAttributeResolutionGuidance getResGuide() {
        return this.resGuide;
    }

    public void setResGuide(CdmAttributeResolutionGuidance resGuide) {
        this.resGuide = resGuide;
    }

    public ResolveOptions getResOpt() {
        return this.resOpt;
    }

    public void setResOpt(ResolveOptions resOpt) {
        this.resOpt = resOpt;
    }

    public class ApplierPriorityComparator
    implements Comparator<AttributeResolutionApplier> {
        @Override
        public int compare(AttributeResolutionApplier l, AttributeResolutionApplier r) {
            return l.priority - r.priority;
        }
    }
}

