/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAdapter
extends StorageAdapterBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceAdapter.class);
    private static final String ROOT = "Microsoft.CommonDataModel.ObjectModel.Resources";

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public CompletableFuture<String> readAsync(String corpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            String string;
            InputStream resourcePath = ResourceAdapter.class.getResourceAsStream(corpusPath);
            BufferedReader br = new BufferedReader(new InputStreamReader(resourcePath));
            try {
                String line;
                StringBuilder result = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
                string = result.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new StorageAdapterException("There was an issue while reading file at " + corpusPath, exception);
                }
            }
            br.close();
            return string;
        });
    }

    @Override
    public String createAdapterPath(String corpusPath) throws StorageAdapterException {
        if (Strings.isNullOrEmpty((String)corpusPath)) {
            return null;
        }
        return ROOT + corpusPath;
    }

    @Override
    public String createCorpusPath(String adapterPath) {
        if (Strings.isNullOrEmpty((String)adapterPath) || !adapterPath.startsWith(ROOT)) {
            return null;
        }
        return adapterPath.substring(ROOT.length());
    }
}

