/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities;

import java.util.ArrayList;
import java.util.stream.Collectors;

public class Errors {
    public static String validateErrorString(String corpusPath, ArrayList<String> missingFields, boolean onlyOneRequired) {
        String missingFieldString = String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList()));
        if (onlyOneRequired) {
            return String.format("Integrity check failed. Reason: The object '%s' is missing the following fields. At least one of the following must be provided: %s", corpusPath, missingFieldString);
        }
        return String.format("Integrity check failed. Reason: The object '%s' is missing the following required fields: %s", corpusPath, missingFieldString);
    }

    public static String validateErrorString(String corpusPath, ArrayList<String> missingFields) {
        return Errors.validateErrorString(corpusPath, missingFields, false);
    }
}

