/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.enums.ImportsLoadStrategy;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionDirectiveSet;
import com.microsoft.commondatamodel.objectmodel.utilities.SymbolSet;
import java.util.Arrays;
import java.util.HashSet;

public class ResolveOptions {
    private CdmDocumentDefinition wrtDoc;
    private AttributeResolutionDirectiveSet directives;
    private boolean shallowValidation;
    private ImportsLoadStrategy importsLoadStrategy = ImportsLoadStrategy.LazyLoad;
    private Boolean strictValidation = true;
    private Integer resolvedAttributeLimit = 4000;
    private int maxOrdinalForArrayExpansion = 20;
    private Integer relationshipDepth;
    private boolean saveResolutionsOnCopy;
    private SymbolSet symbolRefSet;
    private CdmDocumentDefinition localizeReferencesFor;
    private CdmDocumentDefinition indexingDoc;
    private String fromMoniker;

    public ResolveOptions() {
    }

    public ResolveOptions(CdmDocumentDefinition cdmDocument) {
        this.setWrtDoc(cdmDocument);
        this.setDirectives(new AttributeResolutionDirectiveSet(new HashSet<String>(Arrays.asList("referenceOnly", "normalized"))));
        this.symbolRefSet = new SymbolSet();
    }

    public ResolveOptions(CdmDocumentDefinition cdmDocument, AttributeResolutionDirectiveSet directives) {
        this.setWrtDoc(cdmDocument);
        this.setDirectives(directives != null ? directives.copy() : new AttributeResolutionDirectiveSet(new HashSet<String>(Arrays.asList("referenceOnly", "normalized"))));
        this.symbolRefSet = new SymbolSet();
    }

    public ResolveOptions(CdmObject cdmObject) {
        this.setWrtDoc(ResolveOptions.fetchDocument(cdmObject));
        this.setDirectives(new AttributeResolutionDirectiveSet(new HashSet<String>(Arrays.asList("referenceOnly", "normalized"))));
        this.symbolRefSet = new SymbolSet();
    }

    public ResolveOptions(CdmObject cdmObject, AttributeResolutionDirectiveSet directives) {
        this.setWrtDoc(ResolveOptions.fetchDocument(cdmObject));
        this.setDirectives(directives != null ? directives.copy() : new AttributeResolutionDirectiveSet(new HashSet<String>(Arrays.asList("referenceOnly", "normalized"))));
        this.symbolRefSet = new SymbolSet();
    }

    @Deprecated
    public void setSymbolRefSet(SymbolSet symbolRefSet) {
        this.symbolRefSet = symbolRefSet;
    }

    public boolean getShallowValidation() {
        return this.shallowValidation;
    }

    public void setShallowValidation(boolean shallowValidation) {
        this.shallowValidation = shallowValidation;
    }

    public ImportsLoadStrategy getImportsLoadStrategy() {
        return this.importsLoadStrategy;
    }

    public void setImportsLoadStrategy(ImportsLoadStrategy importsLoadStrategy) {
        this.importsLoadStrategy = importsLoadStrategy;
    }

    @Deprecated
    public Boolean getStrictValidation() {
        if (this.importsLoadStrategy == ImportsLoadStrategy.LazyLoad) {
            return null;
        }
        return this.importsLoadStrategy == ImportsLoadStrategy.Load;
    }

    @Deprecated
    public void setStrictValidation(Boolean strictValidation) {
        this.importsLoadStrategy = strictValidation == null ? ImportsLoadStrategy.LazyLoad : (strictValidation != false ? ImportsLoadStrategy.Load : ImportsLoadStrategy.DoNotLoad);
    }

    @Deprecated
    public void setSaveResolutionsOnCopy(boolean saveResolutionsOnCopy) {
        this.saveResolutionsOnCopy = saveResolutionsOnCopy;
    }

    public void setDirectives(AttributeResolutionDirectiveSet directives) {
        this.directives = directives;
    }

    public CdmDocumentDefinition getWrtDoc() {
        return this.wrtDoc;
    }

    public void setWrtDoc(CdmDocumentDefinition wrtDoc) {
        this.wrtDoc = wrtDoc;
    }

    public Integer getResolvedAttributeLimit() {
        return this.resolvedAttributeLimit;
    }

    public void setResolvedAttributeLimit(Integer resolvedAttributeLimit) {
        this.resolvedAttributeLimit = resolvedAttributeLimit;
    }

    public int getMaxOrdinalForArrayExpansion() {
        return this.maxOrdinalForArrayExpansion;
    }

    public void setMaxOrdinalForArrayExpansion(int maxOrdinalForArrayExpansion) {
        this.maxOrdinalForArrayExpansion = maxOrdinalForArrayExpansion;
    }

    @Deprecated
    public CdmDocumentDefinition getIndexingDoc() {
        return this.indexingDoc;
    }

    @Deprecated
    public void setRelationshipDepth(Integer relationshipDepth) {
        this.relationshipDepth = relationshipDepth;
    }

    @Deprecated
    public boolean isSaveResolutionsOnCopy() {
        return this.saveResolutionsOnCopy;
    }

    @Deprecated
    public SymbolSet getSymbolRefSet() {
        return this.symbolRefSet;
    }

    public AttributeResolutionDirectiveSet getDirectives() {
        return this.directives;
    }

    @Deprecated
    public void setIndexingDoc(CdmDocumentDefinition indexingDoc) {
        this.indexingDoc = indexingDoc;
    }

    @Deprecated
    public Integer getRelationshipDepth() {
        return this.relationshipDepth;
    }

    @Deprecated
    public CdmDocumentDefinition getLocalizeReferencesFor() {
        return this.localizeReferencesFor;
    }

    @Deprecated
    public void setLocalizeReferencesFor(CdmDocumentDefinition localizeReferencesFor) {
        this.localizeReferencesFor = localizeReferencesFor;
    }

    public ResolveOptions copy() {
        ResolveOptions resOptCopy = new ResolveOptions();
        resOptCopy.wrtDoc = this.wrtDoc;
        resOptCopy.relationshipDepth = this.relationshipDepth;
        if (this.directives != null) {
            resOptCopy.directives = this.directives.copy();
        }
        resOptCopy.localizeReferencesFor = this.localizeReferencesFor;
        resOptCopy.indexingDoc = this.indexingDoc;
        return resOptCopy;
    }

    @Deprecated
    public String getFromMoniker() {
        return this.fromMoniker;
    }

    @Deprecated
    public void setFromMoniker(String fromMoniker) {
        this.fromMoniker = fromMoniker;
    }

    private static CdmDocumentDefinition fetchDocument(CdmObject obj) {
        if (obj == null || obj.getOwner() == null) {
            return null;
        }
        return obj.getOwner().getInDocument();
    }

    @Deprecated
    public boolean checkAttributeCount(int amount) {
        return this.getResolvedAttributeLimit() == null || amount <= this.getResolvedAttributeLimit();
    }
}

