/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities.network;

import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpRequest;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpRequestException;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpResponse;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmNetworkException;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmNumberOfRetriesExceededException;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmTimedOutException;
import com.microsoft.commondatamodel.objectmodel.utilities.network.TimeLimitedNetworkBlockExecutor;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;

public class CdmHttpClient {
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private HttpClient client;
    private String apiEndpoint;

    public CdmHttpClient() {
        this(null, null);
    }

    public CdmHttpClient(String apiEndpoint) {
        this(apiEndpoint, null);
    }

    public CdmHttpClient(String apiEndpoint, HttpClient httpClientHandler) {
        if (apiEndpoint != null) {
            this.apiEndpoint = apiEndpoint;
        }
        this.client = httpClientHandler != null ? httpClientHandler : HttpClientBuilder.create().build();
    }

    @Deprecated
    public CompletableFuture<CdmHttpResponse> sendAsync(CdmHttpRequest cdmHttpRequest, Callback callback) {
        CompletableFuture<CdmHttpResponse> response = new CompletableFuture<CdmHttpResponse>();
        CompletableFuture.runAsync(() -> {
            for (Map.Entry<String, String> item : this.headers.entrySet()) {
                cdmHttpRequest.getHeaders().put(item.getKey(), item.getValue());
            }
            try {
                TimeLimitedNetworkBlockExecutor.runWithTimeout(() -> {
                    try {
                        CdmHttpResponse cdmHttpResponse = this.sendAsyncHelper(cdmHttpRequest, callback);
                        if (cdmHttpRequest != null) {
                            response.complete(cdmHttpResponse);
                        }
                    }
                    catch (CdmNetworkException e) {
                        response.completeExceptionally(e);
                    }
                }, cdmHttpRequest.getMaximumTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                response.completeExceptionally(new RuntimeException(exception));
            }
        });
        return response;
    }

    private CdmHttpResponse sendAsyncHelper(CdmHttpRequest cdmHttpRequest, Callback callback) {
        URI fullUri = null;
        try {
            fullUri = this.apiEndpoint != null ? new URI(CdmHttpClient.combineUrls(this.apiEndpoint, cdmHttpRequest.getRequestedUrl())) : new URI(cdmHttpRequest.getRequestedUrl());
        }
        catch (URISyntaxException e) {
            throw new CdmHttpRequestException(e.getMessage());
        }
        HttpRequestBase httpRequest = this.getHttpClientInstance(fullUri, cdmHttpRequest.getMethod());
        for (Map.Entry<String, String> item : cdmHttpRequest.getHeaders().entrySet()) {
            httpRequest.setHeader(item.getKey(), item.getValue());
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)cdmHttpRequest.getTimeout().toMillis()).build();
        httpRequest.setConfig(requestConfig);
        if (cdmHttpRequest.getContent() != null) {
            StringEntity stringEntity = new StringEntity(cdmHttpRequest.getContent(), StandardCharsets.UTF_8);
            stringEntity.setContentType(cdmHttpRequest.getContentType());
            if (httpRequest instanceof HttpPost) {
                ((HttpPost)httpRequest).setEntity((HttpEntity)stringEntity);
            } else if (httpRequest instanceof HttpPut) {
                ((HttpPut)httpRequest).setEntity((HttpEntity)stringEntity);
            } else if (httpRequest instanceof HttpPatch) {
                ((HttpPatch)httpRequest).setEntity((HttpEntity)stringEntity);
            }
        }
        for (int retryNumber = 0; retryNumber <= cdmHttpRequest.getNumberOfRetries(); ++retryNumber) {
            CdmHttpResponse cdmHttpResponse;
            boolean hasFailed;
            block23: {
                hasFailed = false;
                cdmHttpResponse = null;
                try {
                    HttpResponse response = this.client.execute((HttpUriRequest)httpRequest);
                    if (response != null) {
                        cdmHttpResponse = new CdmHttpResponse(response.getStatusLine().getStatusCode());
                        HttpEntity responseEntity = response.getEntity();
                        if (responseEntity != null && responseEntity.getContent() != null) {
                            cdmHttpResponse.setContent(IOUtils.toString((InputStream)responseEntity.getContent(), (Charset)StandardCharsets.UTF_8));
                        }
                        cdmHttpResponse.setReason(response.getStatusLine().getReasonPhrase());
                        cdmHttpResponse.setSuccessful(response.getStatusLine().getStatusCode() / 100 == 2);
                        if (response.getAllHeaders() != null) {
                            for (Header header : response.getAllHeaders()) {
                                cdmHttpResponse.getResponseHeaders().put(header.getName(), header.getValue());
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    hasFailed = true;
                    if (callback != null && retryNumber != cdmHttpRequest.getNumberOfRetries()) break block23;
                    if (retryNumber != 0) {
                        throw new CdmNumberOfRetriesExceededException();
                    }
                    throw exception instanceof ConnectTimeoutException ? new CdmTimedOutException(exception.getMessage()) : new RuntimeException(exception);
                }
            }
            if (callback != null && retryNumber != cdmHttpRequest.getNumberOfRetries()) {
                Duration waitTime = callback.apply(cdmHttpResponse, hasFailed, retryNumber + 1);
                if (waitTime == null) {
                    httpRequest.releaseConnection();
                    return cdmHttpResponse;
                }
                try {
                    Thread.sleep(waitTime.toMillis());
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            httpRequest.releaseConnection();
            if (cdmHttpResponse != null) {
                return cdmHttpResponse;
            }
            if (retryNumber == 0) {
                return null;
            }
            throw new CdmNumberOfRetriesExceededException();
        }
        throw new CdmNumberOfRetriesExceededException();
    }

    private HttpRequestBase getHttpClientInstance(URI uri, final String method) {
        switch (method) {
            case "PUT": {
                return new HttpPut(uri);
            }
            case "POST": {
                return new HttpPost(uri);
            }
            case "PATCH": {
                return new HttpPatch(uri);
            }
        }
        HttpRequestBase request = new HttpRequestBase(){

            public String getMethod() {
                return method;
            }
        };
        request.setURI(uri);
        return request;
    }

    private static String combineUrls(String baseUrl, String suffix) {
        baseUrl = baseUrl.replaceAll("/+$", "");
        suffix = suffix.replace("^/+", "");
        return baseUrl + "/" + suffix;
    }

    @FunctionalInterface
    public static interface Callback {
        public Duration apply(CdmHttpResponse var1, boolean var2, int var3);
    }
}

