/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class CdmAttributeContext
extends CdmObjectDefinitionBase {
    private CdmAttributeContextType type;
    private CdmCollection<CdmObject> contents;
    private String name;
    private Integer lowestOrder;
    private CdmObjectReference parent;
    private CdmObjectReference definition;
    private String declaredPath;
    private String atCorpusPath;

    public CdmAttributeContext(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setObjectType(CdmObjectType.AttributeContextDef);
        this.name = name;
        this.setAtCorpusPath(name);
        this.contents = new CdmCollection(this.getCtx(), this.getOwner(), this.getObjectType());
    }

    public final CdmAttributeContextType getType() {
        return this.type;
    }

    public final void setType(CdmAttributeContextType value) {
        this.type = value;
    }

    @Deprecated
    public static CdmAttributeContext createChildUnder(ResolveOptions resOpt, AttributeContextParameters acp) {
        if (acp == null) {
            return null;
        }
        if (acp.getType() == CdmAttributeContextType.PassThrough) {
            return acp.getUnder();
        }
        ResolveOptions resOptCopy = resOpt.copy();
        resOptCopy.setSaveResolutionsOnCopy(true);
        CdmObjectReference definition = null;
        ResolvedTraitSet rtsApplied = null;
        if (acp.getRegarding() != null) {
            definition = acp.getRegarding().createSimpleReference(resOptCopy);
            definition.setInDocument(acp.getUnder().getInDocument());
            if (acp.isIncludeTraits()) {
                rtsApplied = acp.getRegarding().fetchResolvedTraits(resOptCopy);
            }
        }
        CdmAttributeContext underChild = (CdmAttributeContext)acp.getUnder().getCtx().getCorpus().makeObject(CdmObjectType.AttributeContextDef, acp.getName());
        underChild.setCtx(acp.getUnder().getCtx());
        underChild.setInDocument(acp.getUnder().getInDocument());
        underChild.setType(acp.getType());
        underChild.setDefinition(definition);
        if (rtsApplied != null && rtsApplied.getSet() != null) {
            rtsApplied.getSet().forEach(rt -> {
                CdmTraitReference traitRef = CdmObjectBase.resolvedTraitToTraitRef(resOptCopy, rt);
                underChild.getExhibitsTraits().add(traitRef);
            });
        }
        underChild.setParent(resOptCopy, acp.getUnder());
        return underChild;
    }

    public CdmObject copyNode() {
        return this.copyNode(new ResolveOptions(this));
    }

    CdmObject copyNode(ResolveOptions resOpt) {
        CdmAttributeContext copy = new CdmAttributeContext(this.getCtx(), this.getName());
        copy.setType(this.type);
        copy.setInDocument(resOpt.getWrtDoc());
        if (this.getDefinition() != null) {
            copy.setDefinition((CdmObjectReference)this.getDefinition().copy(resOpt));
        }
        copy.setContents(new CdmCollection<CdmObject>(this.getCtx(), copy, CdmObjectType.AttributeRef));
        this.copyDef(resOpt, copy);
        return copy;
    }

    CdmAttributeContext copyAttributeContextTree(ResolveOptions resOpt, CdmAttributeContext newNode, ResolvedAttributeSet ras) {
        return this.copyAttributeContextTree(resOpt, newNode, ras, null);
    }

    CdmAttributeContext copyAttributeContextTree(ResolveOptions resOpt, CdmAttributeContext newNode, ResolvedAttributeSet ras, LinkedHashSet<CdmAttributeContext> attCtxSet) {
        return this.copyAttributeContextTree(resOpt, newNode, ras, attCtxSet, null);
    }

    CdmAttributeContext copyAttributeContextTree(ResolveOptions resOpt, CdmAttributeContext newNode, ResolvedAttributeSet ras, LinkedHashSet<CdmAttributeContext> attCtxSet, String moniker) {
        ResolvedAttribute ra = ras.getAttCtx2ra().get(this);
        if (ra != null) {
            ras.cacheAttributeContext(newNode, ra);
        }
        if (attCtxSet != null) {
            attCtxSet.add(newNode);
        }
        if (!StringUtils.isNullOrTrimEmpty(moniker) && newNode.getDefinition() != null && newNode.getDefinition().getNamedReference() != null) {
            newNode.getDefinition().setNamedReference(moniker + "/" + newNode.getDefinition().getNamedReference());
        }
        for (CdmObject child : this.contents) {
            if (!(child instanceof CdmAttributeContext)) continue;
            CdmAttributeContext childAsAttributeContext = (CdmAttributeContext)child;
            CdmAttributeContext newChild = (CdmAttributeContext)childAsAttributeContext.copyNode(resOpt);
            if (newNode != null) {
                newChild.setParent(resOpt, newNode);
            }
            ResolvedAttributeSet currentRas = ras;
            if (ra != null && ra.getTarget() instanceof ResolvedAttributeSet) {
                currentRas = (ResolvedAttributeSet)ra.getTarget();
            }
            childAsAttributeContext.copyAttributeContextTree(resOpt, newChild, currentRas, attCtxSet, moniker);
        }
        return newNode;
    }

    public final CdmObjectReference getParent() {
        return this.parent;
    }

    public final void setParent(CdmObjectReference value) {
        this.parent = value;
    }

    public final CdmObjectReference getDefinition() {
        return this.definition;
    }

    public final void setDefinition(CdmObjectReference value) {
        this.definition = value;
    }

    public final CdmCollection<CdmObject> getContents() {
        return this.contents;
    }

    public void setContents(CdmCollection<CdmObject> value) {
        this.contents = value;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        this.name = value;
    }

    final Integer getLowestOrder() {
        return this.lowestOrder;
    }

    final void setLowestOrder(Integer value) {
        this.lowestOrder = value;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges && StringUtils.isNullOrTrimEmpty(path = this.declaredPath)) {
            this.declaredPath = path = pathFrom + this.getName();
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getParent() != null && this.getParent().visit(path + "/parent/", preChildren, postChildren)) {
            return true;
        }
        if (this.getDefinition() != null && this.getDefinition().visit(path + "/definition/", preChildren, postChildren)) {
            return true;
        }
        if (this.getContents() != null && CdmObjectBase.visitList(this.getContents(), path + "/", preChildren, postChildren)) {
            return true;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (StringUtils.isNullOrTrimEmpty(this.name)) {
            missingFields.add("name");
        }
        if (this.type == null) {
            missingFields.add("type");
        }
        if (missingFields.size() > 0) {
            Logger.error(CdmAttributeContext.class.getSimpleName(), this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), missingFields));
            return false;
        }
        return true;
    }

    @Override
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmAttributeContext.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmAttributeContext copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = (CdmAttributeContext)this.copyNode(resOpt);
        } else {
            copy = (CdmAttributeContext)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
            copy.getContents().clear();
        }
        if (this.getParent() != null) {
            copy.setParent((CdmObjectReference)this.getParent().copy(resOpt));
        }
        if (this.contents != null && this.contents.size() > 0) {
            for (CdmObject child : this.contents) {
                copy.getContents().add(child.copy(resOpt));
            }
        }
        return copy;
    }

    void setRelativePath(String rp) {
        this.declaredPath = rp;
    }

    private void setParent(ResolveOptions resOpt, CdmAttributeContext parent) {
        CdmObjectReferenceBase parentRef = (CdmObjectReferenceBase)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeContextRef, parent.getAtCorpusPath(), true);
        if (this.getName() != null) {
            if (parent.getAtCorpusPath().endsWith("/") || this.getName().startsWith("/")) {
                this.setAtCorpusPath(parent.getAtCorpusPath() + this.getName());
            } else {
                this.setAtCorpusPath(parent.getAtCorpusPath() + "/" + this.getName());
            }
        }
        parentRef.setExplicitReference(parent);
        parentRef.setInDocument(parent.getInDocument());
        CdmCollection<CdmObject> parentContents = parent.getContents();
        parentContents.add(this);
        this.setParent(parentRef);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
    }

    @Override
    public String getAtCorpusPath() {
        return this.atCorpusPath;
    }

    public void setAtCorpusPath(String atCorpusPath) {
        this.atCorpusPath = atCorpusPath;
    }
}

