/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContextReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeGroupDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeGroupReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeItem;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeResolutionGuidance;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmReferencesEntities;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmProjection;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmDataFormat;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.AttributeResolutionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntity;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntityReference;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntityReferenceSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionDirective;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionDirectiveSet;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class CdmEntityDefinition
extends CdmObjectDefinitionBase
implements CdmReferencesEntities {
    private String entityName;
    private CdmEntityReference extendsEntity;
    private CdmAttributeResolutionGuidance extendsEntityResolutionGuidance;
    private CdmCollection<CdmAttributeItem> attributes;
    private CdmAttributeContext attributeContext;
    private ResolveContext ctxDefault;
    private boolean resolvingEntityReferences = false;
    private TraitToPropertyMap t2pm;
    private ResolvedAttributeSetBuilder rasb;

    public CdmEntityDefinition(CdmCorpusContext ctx, String entityName) {
        this(ctx, entityName, null);
    }

    public CdmEntityDefinition(CdmCorpusContext ctx, String entityName, CdmEntityReference extendsEntity) {
        this(ctx, entityName, extendsEntity, false, false);
    }

    public CdmEntityDefinition(CdmCorpusContext ctx, String entityName, CdmEntityReference extendsEntity, boolean exhibitsTraits, boolean attributes) {
        super(ctx);
        this.setObjectType(CdmObjectType.EntityDef);
        this.setEntityName(entityName);
        if (extendsEntity != null) {
            this.setExtendsEntity(extendsEntity);
        }
        this.attributes = new CdmCollection(this.getCtx(), this, CdmObjectType.TypeAttributeDef);
        this.t2pm = new TraitToPropertyMap(this);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public CdmEntityReference getExtendsEntity() {
        return this.extendsEntity;
    }

    public void setExtendsEntity(CdmEntityReference extendsEntity) {
        this.extendsEntity = extendsEntity;
    }

    public CdmAttributeResolutionGuidance getExtendsEntityResolutionGuidance() {
        return this.extendsEntityResolutionGuidance;
    }

    public void setExtendsEntityResolutionGuidance(CdmAttributeResolutionGuidance extendsEntityResolutionGuidance) {
        this.extendsEntityResolutionGuidance = extendsEntityResolutionGuidance;
    }

    public CdmAttributeContext getAttributeContext() {
        return this.attributeContext;
    }

    public void setAttributeContext(CdmAttributeContext attributeContext) {
        this.attributeContext = attributeContext;
    }

    public CdmObjectReference getExtendsEntityRef() {
        return this.extendsEntity;
    }

    public void setExtendsEntityRef(CdmEntityReference extendsEntityRef) {
        this.extendsEntity = extendsEntityRef;
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        return this.isDerivedFromDef(resOpt, this.getExtendsEntityRef(), this.getName(), baseDef);
    }

    public List<String> getCdmSchemas() {
        return (List)this.t2pm.fetchPropertyValue(CdmPropertyName.CDM_SCHEMAS);
    }

    public void setCdmSchemas(List<String> value) {
        this.t2pm.updatePropertyValue(CdmPropertyName.CDM_SCHEMAS, value);
    }

    public String getDescription() {
        return (String)this.t2pm.fetchPropertyValue(CdmPropertyName.DESCRIPTION);
    }

    public void setDescription(String value) {
        this.t2pm.updatePropertyValue(CdmPropertyName.DESCRIPTION, value);
    }

    public String getDisplayName() {
        return (String)this.t2pm.fetchPropertyValue(CdmPropertyName.DISPLAY_NAME);
    }

    public void setDisplayName(String value) {
        this.t2pm.updatePropertyValue(CdmPropertyName.DISPLAY_NAME, value);
    }

    public CdmCollection<CdmAttributeItem> getAttributes() {
        return this.attributes;
    }

    public String getSourceName() {
        return (String)this.t2pm.fetchPropertyValue(CdmPropertyName.SOURCE_NAME);
    }

    public void setSourceName(String value) {
        this.t2pm.updatePropertyValue(CdmPropertyName.SOURCE_NAME, value);
    }

    public String getVersion() {
        return (String)this.t2pm.fetchPropertyValue(CdmPropertyName.VERSION);
    }

    public void setVersion(String value) {
        this.t2pm.updatePropertyValue(CdmPropertyName.VERSION, value);
    }

    int countInheritedAttributes(ResolveOptions resOpt) {
        this.fetchResolvedAttributes(resOpt);
        return this.rasb.getInheritedMark();
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        CdmEntityReference baseClass = this.extendsEntity;
        if (baseClass != null) {
            rtsb.mergeTraits(baseClass.fetchResolvedTraits(resOpt));
        }
        if (this.getAttributes() != null) {
            ResolvedTraitSet rtsElevated = new ResolvedTraitSet(resOpt);
            for (int i = 0; i < this.getAttributes().getCount(); ++i) {
                CdmAttributeItem att = this.attributes.getAllItems().get(i);
                ResolvedTraitSet rtsAtt = att.fetchResolvedTraits(resOpt);
                if (rtsAtt != null && rtsAtt.getHasElevated() != null && rtsAtt.getHasElevated().booleanValue()) {
                    rtsElevated = rtsElevated.mergeSet(rtsAtt, true);
                }
                rtsb.mergeTraits(rtsElevated);
            }
            this.constructResolvedTraitsDef(null, rtsb, resOpt);
        }
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        this.rasb = new ResolvedAttributeSetBuilder();
        this.rasb.getResolvedAttributeSet().setAttributeContext(under);
        if (this.getExtendsEntity() != null) {
            CdmEntityReference extRef = this.extendsEntity;
            CdmAttributeContext extendsRefUnder = null;
            AttributeContextParameters acpExtEnt = null;
            if (under != null) {
                AttributeContextParameters acpExt = new AttributeContextParameters();
                acpExt.setUnder(under);
                acpExt.setType(CdmAttributeContextType.EntityReferenceExtends);
                acpExt.setName("extends");
                acpExt.setRegarding(null);
                acpExt.setIncludeTraits(false);
                extendsRefUnder = this.rasb.getResolvedAttributeSet().createAttributeContext(resOpt, acpExt);
            }
            if (extRef.getExplicitReference() != null && extRef.fetchObjectDefinition(resOpt).getObjectType() == CdmObjectType.ProjectionDef) {
                Object extRefObjDef = extRef.fetchObjectDefinition(resOpt);
                if (extendsRefUnder != null) {
                    acpExtEnt = new AttributeContextParameters();
                    acpExtEnt.setUnder(extendsRefUnder);
                    acpExtEnt.setType(CdmAttributeContextType.Projection);
                    acpExtEnt.setName(extRefObjDef.getName());
                    acpExtEnt.setRegarding(extRef);
                    acpExtEnt.setIncludeTraits(false);
                }
                ProjectionDirective projDirective = new ProjectionDirective(resOpt, this, extRef);
                CdmProjection projDef = (CdmProjection)extRefObjDef;
                ProjectionContext projCtx = projDef.constructProjectionContext(projDirective, extendsRefUnder);
                this.rasb.setResolvedAttributeSet(projDef.extractResolvedAttributes(projCtx));
            } else {
                if (extendsRefUnder != null) {
                    acpExtEnt = new AttributeContextParameters();
                    acpExtEnt.setUnder(extendsRefUnder);
                    acpExtEnt.setType(CdmAttributeContextType.Entity);
                    acpExtEnt.setName(extRef.getNamedReference() != null ? extRef.getNamedReference() : extRef.getExplicitReference().getName());
                    acpExtEnt.setRegarding(extRef);
                    acpExtEnt.setIncludeTraits(false);
                }
                String oldMoniker = resOpt.getFromMoniker();
                this.rasb.mergeAttributes(this.getExtendsEntityRef().fetchResolvedAttributes(resOpt, acpExtEnt));
                if (!resOpt.checkAttributeCount(this.rasb.getResolvedAttributeSet().getResolvedAttributeCount())) {
                    Logger.error(CdmEntityDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Maximum number of resolved attributes reached for the entity: {0}.", this.entityName));
                    return null;
                }
                if (this.getExtendsEntityResolutionGuidance() != null) {
                    ResolvedTraitSet rtsBase = this.fetchResolvedTraits(resOpt);
                    CdmAttributeResolutionGuidance resGuide = (CdmAttributeResolutionGuidance)this.getExtendsEntityResolutionGuidance().copy(resOpt);
                    resGuide.updateAttributeDefaults(resGuide.fetchObjectDefinitionName());
                    AttributeResolutionContext arc = new AttributeResolutionContext(resOpt, resGuide, rtsBase);
                    this.rasb.generateApplierAttributes(arc, false);
                }
                resOpt.setFromMoniker(oldMoniker);
            }
        }
        this.rasb.markInherited();
        this.rasb.getResolvedAttributeSet().setAttributeContext(under);
        if (this.getAttributes() != null) {
            int furthestChildDepth = 0;
            int l = this.getAttributes().getCount();
            for (int i = 0; i < l; ++i) {
                CdmAttributeItem att = this.attributes.getAllItems().get(i);
                AttributeContextParameters acpAtt = null;
                if (under != null) {
                    acpAtt = new AttributeContextParameters();
                    acpAtt.setUnder(under);
                    acpAtt.setType(CdmAttributeContextType.AttributeDefinition);
                    acpAtt.setName(att.fetchObjectDefinitionName());
                    acpAtt.setRegarding(att);
                    acpAtt.setIncludeTraits(false);
                }
                if (resOpt.inCircularReference && att instanceof CdmEntityAttributeDefinition) continue;
                ResolvedAttributeSet attRas = att.fetchResolvedAttributes(resOpt, acpAtt);
                if (att instanceof CdmEntityAttributeDefinition) {
                    furthestChildDepth = attRas.getDepthTraveled() > furthestChildDepth ? attRas.getDepthTraveled() : furthestChildDepth;
                }
                this.rasb.mergeAttributes(attRas);
                if (resOpt.checkAttributeCount(this.rasb.getResolvedAttributeSet().getResolvedAttributeCount())) continue;
                Logger.error(CdmEntityDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Maximum number of resolved attributes reached for the entity: {0}.", this.entityName));
                return null;
            }
            this.rasb.getResolvedAttributeSet().setDepthTraveled(furthestChildDepth);
        }
        this.rasb.markOrder();
        this.rasb.getResolvedAttributeSet().setAttributeContext(under);
        this.rasb.removeRequestedAtts();
        return this.rasb;
    }

    public CompletableFuture<CdmEntityDefinition> createResolvedEntityAsync(String newEntName) {
        return this.createResolvedEntityAsync(newEntName, null);
    }

    public CompletableFuture<CdmEntityDefinition> createResolvedEntityAsync(String newEntName, ResolveOptions resOpt) {
        return this.createResolvedEntityAsync(newEntName, resOpt, null, null);
    }

    public CompletableFuture<CdmEntityDefinition> createResolvedEntityAsync(String newEntName, ResolveOptions resOpt, CdmFolderDefinition folder) {
        return this.createResolvedEntityAsync(newEntName, resOpt, folder, null);
    }

    public CompletableFuture<CdmEntityDefinition> createResolvedEntityAsync(String newEntName, ResolveOptions resOpt, CdmFolderDefinition folderDef, String newDocName) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (resOpt.getWrtDoc() == null) {
            Logger.error(CdmEntityDefinition.class.getSimpleName(), this.getCtx(), "No WRT document was supplied.", "createResolvedEntityAsync");
            return CompletableFuture.completedFuture(null);
        }
        if (Strings.isNullOrEmpty((String)newEntName)) {
            Logger.error(CdmEntityDefinition.class.getSimpleName(), this.getCtx(), "No Entity Name provided.", "createResolvedEntityAsync");
            return CompletableFuture.completedFuture(null);
        }
        if (folderDef == null) {
            folderDef = this.getInDocument().getFolder();
        }
        ResolveOptions finalResOpt = resOpt;
        CdmFolderDefinition folder = folderDef != null ? folderDef : this.getInDocument().getFolder();
        return CompletableFuture.supplyAsync(() -> {
            String fileName = Strings.isNullOrEmpty((String)newDocName) ? String.format("%s.cdm.json", newEntName) : newDocName;
            String origDoc = this.getInDocument().getAtCorpusPath();
            String targetAtCorpusPath = String.format("%s%s", this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(folder.getAtCorpusPath(), folder), fileName);
            if (StringUtils.equalsWithIgnoreCase(targetAtCorpusPath, origDoc)) {
                Logger.error(CdmEntityDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Attempting to replace source entity's document '{0}'", targetAtCorpusPath), "createResolvedEntityAsync");
                return null;
            }
            if (!finalResOpt.getWrtDoc().indexIfNeededAsync(finalResOpt, true).join().booleanValue()) {
                Logger.error(CdmEntityDefinition.class.getSimpleName(), this.getCtx(), "Couldn't index source document.", "createResolvedEntityAsync");
                return null;
            }
            boolean wasResolving = this.getCtx().getCorpus().isCurrentlyResolving;
            this.getCtx().getCorpus().isCurrentlyResolving = true;
            ResolveContext ctx = (ResolveContext)this.getCtx();
            CdmAttributeContext attCtxEnt = (CdmAttributeContext)ctx.getCorpus().makeObject(CdmObjectType.AttributeContextDef, newEntName, true);
            attCtxEnt.setCtx(ctx);
            attCtxEnt.setInDocument(this.getInDocument());
            AttributeContextParameters acp = new AttributeContextParameters();
            acp.setUnder(attCtxEnt);
            acp.setType(CdmAttributeContextType.AttributeGroup);
            acp.setName("attributeContext");
            CdmAttributeContext attCtxAC = CdmAttributeContext.createChildUnder(finalResOpt, acp);
            AttributeContextParameters acpEnt = new AttributeContextParameters();
            acpEnt.setUnder(attCtxAC);
            acpEnt.setType(CdmAttributeContextType.Entity);
            acpEnt.setName(newEntName);
            acpEnt.setRegarding((CdmObject)ctx.getCorpus().makeObject(CdmObjectType.EntityRef, this.getName(), true));
            ResolveOptions resOptCopy = finalResOpt.copy();
            resOptCopy.setSaveResolutionsOnCopy(true);
            ResolvedAttributeSet ras = this.fetchResolvedAttributes(resOptCopy, acpEnt);
            if (ras == null) {
                this.resolvingAttributes = false;
                return null;
            }
            LinkedHashSet<CdmAttributeContext> allAttCtx = new LinkedHashSet<CdmAttributeContext>();
            CdmAttributeContext newNode = (CdmAttributeContext)attCtxEnt.copyNode(finalResOpt);
            attCtxEnt = attCtxEnt.copyAttributeContextTree(finalResOpt, newNode, ras, allAttCtx, "resolvedFrom");
            CdmAttributeContext attCtx = (CdmAttributeContext)((CdmAttributeContext)attCtxEnt.getContents().get(0)).getContents().get(0);
            this.getCtx().getCorpus().isCurrentlyResolving = wasResolving;
            folder.getDocuments().remove(fileName);
            CdmDocumentDefinition docRes = folder.getDocuments().add(fileName);
            origDoc = this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(origDoc, docRes);
            docRes.getImports().add(origDoc, "resolvedFrom");
            CdmEntityDefinition entResolved = docRes.getDefinitions().add(newEntName);
            entResolved.setAttributeContext(attCtx);
            attCtx.visit(newEntName + "/attributeContext/", (obj, path) -> {
                obj.setInDocument(docRes);
                return false;
            }, null);
            ResolvedTraitSet rtsEnt = this.fetchResolvedTraits(finalResOpt);
            for (ResolvedTrait rt : rtsEnt.getSet()) {
                CdmTraitReference traitRef = CdmObjectBase.resolvedTraitToTraitRef(resOptCopy, rt);
                entResolved.getExhibitsTraits().add(traitRef);
            }
            LinkedHashMap<String, Integer> attPath2Order = new LinkedHashMap<String, Integer>();
            this.pointContextAtResolvedAtts(ras, newEntName + "/hasAttributes/", allAttCtx, attPath2Order);
            this.cleanSubGroup(attCtx, false);
            this.orderContents(attCtx, attPath2Order);
            LinkedHashMap<CdmAttributeContext, LinkedHashSet<String>> ctx2traitNames = new LinkedHashMap<CdmAttributeContext, LinkedHashSet<String>>();
            this.collectContextTraits(attCtx, new LinkedHashSet<String>(), ctx2traitNames);
            LinkedHashMap<ResolvedAttribute, String> resAtt2RefPath = new LinkedHashMap<ResolvedAttribute, String>();
            this.addAttributes(ras, entResolved, newEntName + "/hasAttributes/", allAttCtx, ctx2traitNames, resOptCopy, resAtt2RefPath);
            if (entResolved.getExhibitsTraits() != null) {
                for (CdmTraitReference et : entResolved.getExhibitsTraits()) {
                    this.replaceTraitAttRef(et, newEntName, false);
                }
            }
            this.fixContextTraits(attCtx, newEntName);
            CdmCollection<CdmAttributeItem> entAttributes = entResolved.getAttributes();
            if (entAttributes != null) {
                entAttributes.forEach(entAtt -> {
                    CdmTraitCollection attTraits = entAtt.getAppliedTraits();
                    if (attTraits != null) {
                        attTraits.forEach(tr -> this.replaceTraitAttRef((CdmTraitReference)tr, newEntName, false));
                    }
                });
            }
            attCtx.setParent(null);
            ResolveOptions resOptNew = finalResOpt.copy();
            resOptNew.setLocalizeReferencesFor(docRes);
            resOptNew.setWrtDoc(docRes);
            docRes.refreshAsync(resOptNew).join();
            entResolved = (CdmEntityDefinition)docRes.fetchObjectFromDocumentPath(newEntName, resOptNew);
            this.getCtx().getCorpus().resEntMap.put(this.getAtCorpusPath(), entResolved.getAtCorpusPath());
            return entResolved;
        });
    }

    private void pointContextAtResolvedAtts(ResolvedAttributeSet rasSub, String path, Set<CdmAttributeContext> allAttCtx, Map<String, Integer> attPath2Order) {
        rasSub.getSet().forEach(ra -> {
            Set<CdmAttributeContext> raCtxSet = rasSub.getRa2attCtxSet().get(ra);
            ArrayList<CdmAttributeContext> raCtxInEnt = new ArrayList<CdmAttributeContext>();
            if (raCtxSet != null && allAttCtx.size() < raCtxSet.size()) {
                for (CdmAttributeContext currAttCtx2 : allAttCtx) {
                    if (!raCtxSet.contains(currAttCtx2)) continue;
                    raCtxInEnt.add(currAttCtx2);
                }
            } else {
                raCtxSet.forEach(currAttCtx -> {
                    if (allAttCtx.contains(currAttCtx)) {
                        raCtxInEnt.add((CdmAttributeContext)currAttCtx);
                    }
                });
            }
            for (CdmAttributeContext raCtx : raCtxInEnt) {
                if (raCtx == null) continue;
                String attRefPath = path + ra.getResolvedName();
                if (ra.getTarget() != null && ra.getTarget() instanceof CdmAttribute) {
                    if (attPath2Order.containsKey(attRefPath)) continue;
                    CdmObjectReference attRef = (CdmObjectReference)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeRef, attRefPath, true);
                    attPath2Order.put(attRef.getNamedReference(), ra.getInsertOrder());
                    raCtx.getContents().add(attRef);
                    continue;
                }
                attRefPath = attRefPath + "/members/";
                this.pointContextAtResolvedAtts((ResolvedAttributeSet)ra.getTarget(), attRefPath, allAttCtx, attPath2Order);
            }
        });
    }

    private boolean cleanSubGroup(CdmObject subItem, boolean underGenerated) {
        if (subItem.getObjectType() == CdmObjectType.AttributeRef) {
            return true;
        }
        if (subItem instanceof CdmAttributeContext) {
            CdmAttributeContext ac = (CdmAttributeContext)subItem;
            if (ac.getType() == CdmAttributeContextType.GeneratedSet) {
                underGenerated = true;
            }
            if (ac.getContents() == null || ac.getContents().size() == 0) {
                return false;
            }
            ArrayList<CdmAttributeContext> toRemove = new ArrayList<CdmAttributeContext>();
            for (CdmObject subSub : ac.getContents()) {
                if (this.cleanSubGroup(subSub, underGenerated)) continue;
                boolean potentialTarget = underGenerated;
                if (!potentialTarget) {
                    boolean bl = potentialTarget = ((CdmAttributeContext)subSub).getType() == CdmAttributeContextType.GeneratedSet;
                }
                if (!potentialTarget) continue;
                toRemove.add((CdmAttributeContext)subSub);
            }
            for (CdmAttributeContext toDie : toRemove) {
                ac.getContents().remove(toDie);
            }
            return ac.getContents().size() != 0;
        }
        return false;
    }

    private Integer orderContents(CdmAttributeContext under, Map<String, Integer> attPath2Order) {
        if (under.getLowestOrder() == null) {
            under.setLowestOrder(-1);
            if (under.getContents().size() == 1) {
                under.setLowestOrder(this.getOrderNum(under.getContents().get(0), attPath2Order));
            } else {
                under.getContents().sort((l, r) -> {
                    Integer rNum;
                    Integer lNum = this.getOrderNum((CdmObject)l, attPath2Order);
                    if (lNum == null) {
                        lNum = -1;
                    }
                    if ((rNum = this.getOrderNum((CdmObject)r, attPath2Order)) == null) {
                        rNum = -1;
                    }
                    if (lNum != -1 && (under.getLowestOrder() == -1 || lNum < under.getLowestOrder())) {
                        under.setLowestOrder(lNum);
                    }
                    if (rNum != -1 && (under.getLowestOrder() == -1 || rNum < under.getLowestOrder())) {
                        under.setLowestOrder(rNum);
                    }
                    return lNum - rNum;
                });
            }
        }
        return under.getLowestOrder();
    }

    private Integer getOrderNum(CdmObject item, Map<String, Integer> attPath2Order) {
        if (item.getObjectType() == CdmObjectType.AttributeContextDef) {
            return this.orderContents((CdmAttributeContext)item, attPath2Order);
        }
        if (item.getObjectType() == CdmObjectType.AttributeRef) {
            String attName = ((CdmAttributeReference)item).getNamedReference();
            int o = attPath2Order.get(attName);
            return o;
        }
        return -1;
    }

    private void collectContextTraits(CdmAttributeContext subAttCtx, LinkedHashSet<String> inheritedTraitNames, Map<CdmAttributeContext, LinkedHashSet<String>> ctx2traitNames) {
        LinkedHashSet<String> traitNamesHere = new LinkedHashSet<String>(inheritedTraitNames);
        CdmTraitCollection traitsHere = subAttCtx.getExhibitsTraits();
        if (traitsHere != null) {
            traitsHere.forEach(tat -> traitNamesHere.add(tat.getNamedReference()));
        }
        ctx2traitNames.put(subAttCtx, traitNamesHere);
        for (CdmObject cr : subAttCtx.getContents().getAllItems()) {
            if (cr.getObjectType() != CdmObjectType.AttributeContextDef) continue;
            this.collectContextTraits((CdmAttributeContext)cr, traitNamesHere, ctx2traitNames);
        }
    }

    private void addAttributes(ResolvedAttributeSet rasSub, Object container, String path, Set<CdmAttributeContext> allAttCtx, Map<CdmAttributeContext, LinkedHashSet<String>> ctx2traitNames, ResolveOptions resOptCopy, Map<ResolvedAttribute, String> resAtt2RefPath) {
        rasSub.getSet().forEach(ra -> {
            Object target;
            String attPath = path + ra.getResolvedName();
            Set<CdmAttributeContext> raCtxSet = rasSub.getRa2attCtxSet().get(ra);
            CdmAttributeContext raCtx = null;
            if (allAttCtx.size() < raCtxSet.size()) {
                for (CdmAttributeContext currAttCtx : allAttCtx) {
                    if (!raCtxSet.contains(currAttCtx)) continue;
                    raCtx = currAttCtx;
                    break;
                }
            } else {
                for (CdmAttributeContext currAttCtx : raCtxSet) {
                    if (!allAttCtx.contains(currAttCtx)) continue;
                    raCtx = currAttCtx;
                    break;
                }
            }
            if ((target = ra.getTarget()) instanceof ResolvedAttributeSet) {
                CdmAttributeGroupDefinition attGrp = (CdmAttributeGroupDefinition)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeGroupDef, ra.getResolvedName(), false);
                attGrp.setAttributeContext((CdmAttributeContextReference)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeContextRef, raCtx.getAtCorpusPath(), true));
                LinkedHashSet avoidSet = (LinkedHashSet)ctx2traitNames.get(raCtx);
                ResolvedTraitSet rtsAtt = ra.fetchResolvedTraits();
                rtsAtt.getSet().forEach(rt -> {
                    if (!(rt.getTrait().getUgly() != null && (rt.getTrait().getUgly() == null || rt.getTrait().getUgly().booleanValue()) || avoidSet != null && avoidSet.contains(rt.getTraitName()))) {
                        CdmTraitReference traitRef = CdmObjectBase.resolvedTraitToTraitRef(resOptCopy, rt);
                        attGrp.getExhibitsTraits().add(traitRef);
                    }
                });
                CdmAttributeGroupReference attGrpRef = (CdmAttributeGroupReference)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeGroupRef, null, false);
                attGrpRef.setExplicitReference(attGrp);
                if (container instanceof CdmEntityDefinition) {
                    ((CdmEntityDefinition)container).addAttributeDef(attGrpRef);
                } else if (container instanceof CdmAttributeGroupDefinition) {
                    ((CdmAttributeGroupDefinition)container).addAttributeDef(attGrpRef);
                }
                this.addAttributes((ResolvedAttributeSet)ra.getTarget(), attGrp, attPath + "/members/", allAttCtx, ctx2traitNames, resOptCopy, resAtt2RefPath);
            } else {
                CdmTypeAttributeDefinition att = (CdmTypeAttributeDefinition)this.getCtx().getCorpus().makeObject(CdmObjectType.TypeAttributeDef, ra.getResolvedName(), false);
                att.setAttributeContext((CdmAttributeContextReference)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeContextRef, raCtx != null ? raCtx.getAtCorpusPath() : null, true));
                LinkedHashSet avoidSet = (LinkedHashSet)ctx2traitNames.get(raCtx);
                ResolvedTraitSet rtsAtt = ra.fetchResolvedTraits();
                rtsAtt.getSet().forEach(rt -> {
                    if (!(rt.getTrait().getUgly() != null && rt.getTrait().getUgly().booleanValue() || avoidSet != null && avoidSet.contains(rt.getTraitName()))) {
                        CdmTraitReference traitRef = CdmObjectBase.resolvedTraitToTraitRef(resOptCopy, rt);
                        att.getAppliedTraits().add(traitRef);
                    }
                });
                CdmDataFormat impliedDataFormat = att.fetchDataFormat();
                if (impliedDataFormat != CdmDataFormat.Unknown) {
                    att.updateDataFormat(impliedDataFormat);
                }
                if (container instanceof CdmEntityDefinition) {
                    ((CdmEntityDefinition)container).addAttributeDef(att);
                } else if (container instanceof CdmAttributeGroupDefinition) {
                    ((CdmAttributeGroupDefinition)container).addAttributeDef(att);
                }
                resAtt2RefPath.put((ResolvedAttribute)ra, attPath);
            }
        });
    }

    private void replaceTraitAttRef(CdmTraitReference tr, String entityHint, boolean isAttributeContext) {
        if (tr.getArguments() != null) {
            for (CdmArgumentDefinition argumentDef : tr.getArguments().getAllItems()) {
                CdmAttributeReference attRef;
                CdmArgumentDefinition arg = argumentDef;
                Object v = arg.getUnResolvedValue() != null ? arg.getUnResolvedValue() : arg.getValue();
                if (!(v instanceof CdmObject) || ((CdmObject)v).getObjectType() != CdmObjectType.AttributeRef || Strings.isNullOrEmpty((String)(attRef = (CdmAttributeReference)v).getNamedReference()) || attRef.getNamedReference().indexOf(47) != -1) continue;
                if (arg.getUnResolvedValue() == null) {
                    arg.setUnResolvedValue(arg.getValue());
                }
                CdmAttributeReference newAttRef = (CdmAttributeReference)this.getCtx().getCorpus().makeRef(CdmObjectType.AttributeRef, entityHint + "/(resolvedAttributes)/" + attRef.getNamedReference(), true);
                newAttRef.setInDocument(arg.getInDocument());
                arg.setValue(newAttRef);
            }
        }
    }

    private void fixContextTraits(CdmAttributeContext subAttCtx, String entityHint) {
        CdmTraitCollection traitsHere = subAttCtx.getExhibitsTraits();
        if (traitsHere != null) {
            traitsHere.forEach(tr -> this.replaceTraitAttRef((CdmTraitReference)tr, entityHint, true));
        }
        subAttCtx.getContents().getAllItems().forEach(cr -> {
            if (cr.getObjectType() == CdmObjectType.AttributeContextDef) {
                CdmAttributeContext subSubAttCtx = (CdmAttributeContext)cr;
                String subEntityHint = entityHint;
                if (subSubAttCtx.getType() == CdmAttributeContextType.Entity) {
                    subEntityHint = subSubAttCtx.getDefinition().getNamedReference();
                }
                this.fixContextTraits(subSubAttCtx, subEntityHint);
            }
        });
    }

    ResolvedAttributeSet getAttributesWithTraits(ResolveOptions resOpt, Object queryFor) {
        try {
            ResolvedAttributeSet resolvedAttributeSet = this.fetchResolvedAttributes(resOpt);
            if (resolvedAttributeSet != null) {
                return resolvedAttributeSet.fetchAttributesWithTraits(resOpt, queryFor);
            }
        }
        catch (IOException ex) {
            Logger.error(CdmEntityDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Error occurred while trying to get attributes with traits. Reason: {0}", ex.getLocalizedMessage()));
        }
        return null;
    }

    public String getPrimaryKey() {
        return (String)this.t2pm.fetchPropertyValue(CdmPropertyName.PRIMARY_KEY);
    }

    @Deprecated
    public Object getProperty(CdmPropertyName propertyName) {
        return this.t2pm.fetchPropertyValue(propertyName, true);
    }

    TraitToPropertyMap getTraitToPropertyMap() {
        return this.t2pm;
    }

    private CompletableFuture<List<?>> queryOnTraitsAsync(Object querySpec) {
        return null;
    }

    @Deprecated
    public ResolvedEntity getResolvedEntity(ResolveOptions resOpt) {
        return new ResolvedEntity(this, resOpt);
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges && Strings.isNullOrEmpty((String)(path = this.getDeclaredPath()))) {
            path = pathFrom + this.getEntityName();
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getExtendsEntity() != null && this.getExtendsEntity().visit(path + "/extendsEntity/", preChildren, postChildren)) {
            return true;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        if (this.getAttributeContext() != null && this.getAttributeContext().visit(path + "/attributeContext/", preChildren, postChildren)) {
            return true;
        }
        if (this.getAttributes() != null && this.attributes.visitList(path + "/hasAttributes/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.entityName)) {
            Logger.error(CdmEntityDefinition.class.getSimpleName(), this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), new ArrayList<String>(Arrays.asList("entityName"))));
            return false;
        }
        return true;
    }

    @Override
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmEntityDefinition.class);
    }

    @Override
    @Deprecated
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmEntityDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmEntityDefinition(this.getCtx(), this.getEntityName(), null);
        } else {
            copy = (CdmEntityDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setEntityName(this.getEntityName());
            copy.getAttributes().clear();
        }
        copy.setExtendsEntity(copy.getExtendsEntity() != null ? (CdmEntityReference)this.getExtendsEntity().copy(resOpt) : null);
        copy.setAttributeContext(copy.getAttributeContext() != null ? (CdmAttributeContext)this.getAttributeContext().copy(resOpt) : null);
        for (CdmAttributeItem hasAttribute : this.getAttributes()) {
            copy.getAttributes().add(hasAttribute);
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Override
    public ResolvedEntityReferenceSet fetchResolvedEntityReferences(ResolveOptions resOpt) {
        boolean wasPreviouslyResolving = this.getCtx().getCorpus().isCurrentlyResolving;
        this.getCtx().getCorpus().isCurrentlyResolving = true;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        LinkedHashSet<String> LinkedHashSet2 = new LinkedHashSet<String>();
        LinkedHashSet2.add("normalized");
        LinkedHashSet2.add("referenceOnly");
        resOpt = resOpt.copy();
        resOpt.setDirectives(new AttributeResolutionDirectiveSet(LinkedHashSet2));
        ResolveContext ctx = (ResolveContext)this.getCtx();
        ResolvedEntityReferenceSet entRefSetCache = (ResolvedEntityReferenceSet)ctx.fetchCache(this, "entRefSet", resOpt);
        if (entRefSetCache == null) {
            entRefSetCache = new ResolvedEntityReferenceSet(resOpt);
            if (!this.resolvingEntityReferences) {
                CdmEntityDefinition extDef;
                this.resolvingEntityReferences = true;
                CdmEntityReference extRef = this.extendsEntity;
                if (extRef != null && (extDef = (CdmEntityDefinition)extRef.fetchObjectDefinition(resOpt)) != null) {
                    ResolvedEntityReferenceSet inherited;
                    if (extDef == this) {
                        extDef = (CdmEntityDefinition)extRef.fetchObjectDefinition(resOpt);
                    }
                    if ((inherited = extDef.fetchResolvedEntityReferences(resOpt)) != null) {
                        for (ResolvedEntityReference res : inherited.getSet()) {
                            ResolvedEntityReference resolvedEntityReference = res.copy();
                            resolvedEntityReference.getReferencing().setEntity(this);
                            entRefSetCache.getSet().add(resolvedEntityReference);
                        }
                    }
                }
                if (this.getAttributes() != null) {
                    for (int i = 0; i < this.getAttributes().getCount(); ++i) {
                        ResolvedEntityReferenceSet sub = this.getAttributes().getAllItems().get(i).fetchResolvedEntityReferences(resOpt);
                        if (sub == null) continue;
                        for (ResolvedEntityReference res : sub.getSet()) {
                            res.getReferencing().setEntity(this);
                        }
                        entRefSetCache.add(sub);
                    }
                }
                ctx.updateCache(this, "entRefSet", entRefSetCache, resOpt);
                this.resolvingEntityReferences = false;
            }
        }
        this.getCtx().getCorpus().isCurrentlyResolving = wasPreviouslyResolving;
        return entRefSetCache;
    }

    CdmAttributeItem addAttributeDef(CdmAttributeItem attributeDef) {
        this.getAttributes().add(attributeDef);
        return attributeDef;
    }
}

