/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.Argument;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;

public class ArgumentPersistence {
    public static CdmArgumentDefinition fromData(CdmCorpusContext ctx, JsonNode obj) {
        CdmArgumentDefinition argument = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef);
        if (obj.get("value") != null) {
            argument.setValue(Utils.createConstant(ctx, obj.get("value")));
            if (obj.get("name") != null) {
                argument.setName(obj.get("name").asText());
            }
            if (obj.get("explanation") != null) {
                argument.setExplanation(obj.get("explanation").asText());
            }
        } else {
            argument.setValue(Utils.createConstant(ctx, obj));
        }
        return argument;
    }

    public static Object toData(CdmArgumentDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        Object val = null;
        if (instance.getValue() != null) {
            val = instance.getValue() instanceof String || instance.getValue() instanceof JsonNode ? instance.getValue() : (instance.getValue() instanceof CdmObject ? ((CdmObject)instance.getValue()).copyData(resOpt, options) : instance.getValue());
        }
        if (Strings.isNullOrEmpty((String)instance.getName())) {
            return val;
        }
        Argument result = new Argument();
        result.setExplanation(instance.getExplanation());
        result.setName(instance.getName());
        result.setValue(JMapper.MAP.valueToTree(val));
        return result;
    }
}

