/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.AttributeContextReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.AttributeGroupReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.AttributeReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.EntityReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.AttributeContext;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.io.IOException;
import java.util.ArrayList;

public class AttributeContextPersistence {
    public static CdmAttributeContext fromData(CdmCorpusContext ctx, AttributeContext obj) {
        if (obj == null) {
            return null;
        }
        CdmAttributeContext attributeContext = (CdmAttributeContext)ctx.getCorpus().makeObject(CdmObjectType.AttributeContextDef, obj.getName(), false);
        attributeContext.setType(AttributeContextPersistence.mapTypeNameToEnum(obj.getType()));
        if (obj.getParent() != null) {
            attributeContext.setParent(AttributeContextReferencePersistence.fromData(ctx, obj.getParent()));
        }
        if (!Strings.isNullOrEmpty((String)obj.getExplanation())) {
            attributeContext.setExplanation(obj.getExplanation());
        }
        if (obj.getDefinition() != null) {
            switch (attributeContext.getType()) {
                case Entity: 
                case EntityReferenceExtends: {
                    attributeContext.setDefinition(EntityReferencePersistence.fromData(ctx, JMapper.MAP.valueToTree((Object)obj.getDefinition())));
                    break;
                }
                case AttributeGroup: {
                    attributeContext.setDefinition(AttributeGroupReferencePersistence.fromData(ctx, JMapper.MAP.valueToTree((Object)obj.getDefinition())));
                    break;
                }
                case AddedAttributeSupporting: 
                case AddedAttributeIdentity: 
                case AddedAttributeExpansionTotal: 
                case AddedAttributeSelectedType: 
                case AttributeDefinition: {
                    attributeContext.setDefinition(AttributeReferencePersistence.fromData(ctx, JMapper.MAP.valueToTree((Object)obj.getDefinition())));
                }
            }
        }
        Utils.addListToCdmCollection(attributeContext.getExhibitsTraits(), Utils.createTraitReferenceList(ctx, obj.getAppliedTraits()));
        if (obj.getContents() != null) {
            for (JsonNode node : obj.getContents()) {
                if (node.isValueNode()) {
                    attributeContext.getContents().add(AttributeReferencePersistence.fromData(ctx, node));
                    continue;
                }
                try {
                    attributeContext.getContents().add(AttributeContextPersistence.fromData(ctx, (AttributeContext)JMapper.MAP.treeToValue((TreeNode)node, AttributeContext.class)));
                }
                catch (IOException ex) {
                    Logger.error(AttributeContextPersistence.class.getSimpleName(), ctx, Logger.format("There was an error while trying to convert from JSON to CdmAttributeContext. Reason: '{0}'", ex.getLocalizedMessage()), "fromData");
                }
            }
        }
        return attributeContext;
    }

    public static AttributeContext toData(CdmAttributeContext instance, ResolveOptions resOpt, CopyOptions options) {
        AttributeContext result = new AttributeContext();
        result.setExplanation(instance.getExplanation());
        result.setName(instance.getName());
        result.setType(AttributeContextPersistence.mapEnumToTypeName(instance.getType()));
        result.setParent(instance.getParent() != null ? instance.getParent().copyData(resOpt, options).toString() : null);
        CdmObjectReference definition = instance.getDefinition();
        if (definition != null) {
            Object resolvedDefinition = definition.copyData(resOpt, options);
            if (resolvedDefinition != null) {
                result.setDefinition(resolvedDefinition.toString());
            }
        } else {
            result.setDefinition(null);
        }
        if (instance.getExhibitsTraits() != null) {
            ArrayList traits = new ArrayList();
            instance.getExhibitsTraits().forEach(trait -> {
                if (!trait.isFromProperty()) {
                    traits.add(trait);
                }
            });
            result.setAppliedTraits(Utils.listCopyDataAsArrayNode(traits, resOpt, options));
        }
        if (instance.getContents() != null) {
            result.setContents(Utils.listCopyDataAsArrayNode(instance.getContents(), resOpt, options));
        }
        return result;
    }

    private static CdmAttributeContextType mapTypeNameToEnum(String typeName) {
        switch (typeName) {
            case "entity": {
                return CdmAttributeContextType.Entity;
            }
            case "entityReferenceExtends": {
                return CdmAttributeContextType.EntityReferenceExtends;
            }
            case "attributeGroup": {
                return CdmAttributeContextType.AttributeGroup;
            }
            case "attributeDefinition": {
                return CdmAttributeContextType.AttributeDefinition;
            }
            case "addedAttributeSupporting": {
                return CdmAttributeContextType.AddedAttributeSupporting;
            }
            case "addedAttributeIdentity": {
                return CdmAttributeContextType.AddedAttributeIdentity;
            }
            case "addedAttributeExpansionTotal": {
                return CdmAttributeContextType.AddedAttributeExpansionTotal;
            }
            case "addedAttributeSelectedType": {
                return CdmAttributeContextType.AddedAttributeSelectedType;
            }
            case "generatedRound": {
                return CdmAttributeContextType.GeneratedRound;
            }
            case "generatedSet": {
                return CdmAttributeContextType.GeneratedSet;
            }
            case "projection": {
                return CdmAttributeContextType.Projection;
            }
            case "source": {
                return CdmAttributeContextType.Source;
            }
            case "operations": {
                return CdmAttributeContextType.Operations;
            }
            case "operationAddCountAttribute": {
                return CdmAttributeContextType.OperationAddCountAttribute;
            }
            case "operationAddSupportingAttribute": {
                return CdmAttributeContextType.OperationAddSupportingAttribute;
            }
            case "operationAddTypeAttribute": {
                return CdmAttributeContextType.OperationAddTypeAttribute;
            }
            case "operationExcludeAttributes": {
                return CdmAttributeContextType.OperationExcludeAttributes;
            }
            case "operationArrayExpansion": {
                return CdmAttributeContextType.OperationArrayExpansion;
            }
            case "operationCombineAttributes": {
                return CdmAttributeContextType.OperationCombineAttributes;
            }
            case "operationRenameAttributes": {
                return CdmAttributeContextType.OperationRenameAttributes;
            }
            case "operationReplaceAsForeignKey": {
                return CdmAttributeContextType.OperationReplaceAsForeignKey;
            }
            case "operationIncludeAttributes": {
                return CdmAttributeContextType.OperationIncludeAttributes;
            }
            case "operationAddAttributeGroup": {
                return CdmAttributeContextType.OperationAddAttributeGroup;
            }
        }
        return null;
    }

    private static String mapEnumToTypeName(CdmAttributeContextType enumVal) {
        switch (enumVal) {
            case Entity: {
                return "entity";
            }
            case EntityReferenceExtends: {
                return "entityReferenceExtends";
            }
            case AttributeGroup: {
                return "attributeGroup";
            }
            case AttributeDefinition: {
                return "attributeDefinition";
            }
            case AddedAttributeSupporting: {
                return "addedAttributeSupporting";
            }
            case AddedAttributeIdentity: {
                return "addedAttributeIdentity";
            }
            case AddedAttributeExpansionTotal: {
                return "addedAttributeExpansionTotal";
            }
            case AddedAttributeSelectedType: {
                return "addedAttributeSelectedType";
            }
            case GeneratedRound: {
                return "generatedRound";
            }
            case GeneratedSet: {
                return "generatedSet";
            }
            case Projection: {
                return "projection";
            }
            case Source: {
                return "source";
            }
            case Operations: {
                return "operations";
            }
            case OperationAddCountAttribute: {
                return "operationAddCountAttribute";
            }
            case OperationAddSupportingAttribute: {
                return "operationAddSupportingAttribute";
            }
            case OperationAddTypeAttribute: {
                return "operationAddTypeAttribute";
            }
            case OperationExcludeAttributes: {
                return "operationExcludeAttributes";
            }
            case OperationArrayExpansion: {
                return "operationArrayExpansion";
            }
            case OperationCombineAttributes: {
                return "operationCombineAttributes";
            }
            case OperationRenameAttributes: {
                return "operationRenameAttributes";
            }
            case OperationReplaceAsForeignKey: {
                return "operationReplaceAsForeignKey";
            }
            case OperationIncludeAttributes: {
                return "operationIncludeAttributes";
            }
            case OperationAddAttributeGroup: {
                return "operationAddAttributeGroup";
            }
        }
        return "unknown";
    }
}

