/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationArrayExpansion;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.OperationTypeConvertor;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationArrayExpansion;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;

public class OperationArrayExpansionPersistence {
    public static CdmOperationArrayExpansion fromData(CdmCorpusContext ctx, JsonNode obj) {
        if (obj == null) {
            return null;
        }
        CdmOperationArrayExpansion arrayExpansionOp = (CdmOperationArrayExpansion)ctx.getCorpus().makeObject(CdmObjectType.OperationArrayExpansionDef);
        if (obj.get("$type") != null && !StringUtils.equalsWithIgnoreCase(obj.get("$type").asText(), OperationTypeConvertor.operationTypeToString(CdmOperationType.ArrayExpansion))) {
            Logger.error(OperationArrayExpansionPersistence.class.getSimpleName(), ctx, Logger.format("$type {0} is invalid for this operation.", obj.get("$type").asText()));
        } else {
            arrayExpansionOp.setType(CdmOperationType.ArrayExpansion);
        }
        if (obj.get("explanation") != null) {
            arrayExpansionOp.setExplanation(obj.get("explanation").asText());
        }
        arrayExpansionOp.setStartOrdinal(obj.get("startOrdinal") == null ? null : Integer.valueOf(obj.get("startOrdinal").asInt()));
        arrayExpansionOp.setEndOrdinal(obj.get("endOrdinal") == null ? null : Integer.valueOf(obj.get("endOrdinal").asInt()));
        return arrayExpansionOp;
    }

    public static OperationArrayExpansion toData(CdmOperationArrayExpansion instance, ResolveOptions resOpt, CopyOptions options) {
        if (instance == null) {
            return null;
        }
        OperationArrayExpansion obj = new OperationArrayExpansion();
        obj.setType(OperationTypeConvertor.operationTypeToString(CdmOperationType.ArrayExpansion));
        obj.setExplanation(instance.getExplanation());
        obj.setStartOrdinal(instance.getStartOrdinal());
        obj.setEndOrdinal(instance.getEndOrdinal());
        return obj;
    }
}

