/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public abstract class StorageAdapterBase
implements StorageAdapter {
    private String locationHint = "";
    private HashSet<CacheContext> activeCacheContexts = new HashSet();

    @Override
    public String getLocationHint() {
        return this.locationHint;
    }

    @Override
    public void setLocationHint(String locationHint) {
        this.locationHint = locationHint;
    }

    @Override
    public boolean canRead() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public CompletableFuture<String> readAsync(String corpusPath) {
        throw new UnsupportedOperationException("This adapter does not support the readAsync method.");
    }

    @Override
    public CompletableFuture<Void> writeAsync(String corpusPath, String data) {
        throw new UnsupportedOperationException("This adapter does not support the writeAsync method.");
    }

    @Override
    public String createAdapterPath(String corpusPath) throws StorageAdapterException {
        return corpusPath;
    }

    @Override
    public String createCorpusPath(String adapterPath) {
        return adapterPath;
    }

    @Override
    public CompletableFuture<OffsetDateTime> computeLastModifiedTimeAsync(String corpusPath) throws StorageAdapterException {
        return CompletableFuture.completedFuture(OffsetDateTime.now());
    }

    @Override
    public CompletableFuture<List<String>> fetchAllFilesAsync(String folderCorpusPath) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String fetchConfig() {
        return "{}";
    }

    @Override
    public void updateConfig(String config) throws IOException {
    }

    @Override
    public void clearCache() {
    }

    protected boolean getIsCacheEnabled() {
        return !this.activeCacheContexts.isEmpty();
    }

    public CacheContext createFileQueryCacheContext() {
        return new CacheContext(this);
    }

    public class CacheContext {
        private StorageAdapterBase adapter;

        protected CacheContext(StorageAdapterBase adapter) {
            this.adapter = adapter;
            this.adapter.activeCacheContexts.add(this);
        }

        public void dispose() {
            this.adapter.activeCacheContexts.remove(this);
            if (!this.adapter.getIsCacheEnabled()) {
                this.adapter.clearCache();
            }
        }
    }
}

