/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities.logger;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.enums.CdmStatusLevel;
import java.text.MessageFormat;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public class Logger {
    private static final org.slf4j.Logger defaultLogger = LoggerFactory.getLogger(Logger.class);

    public static void debug(String tag, CdmCorpusContext ctx, String message) {
        Logger.debug(tag, ctx, message, null);
    }

    public static void debug(String tag, CdmCorpusContext ctx, String message, String path) {
        Consumer<String> statusEvent = msg -> defaultLogger.debug(msg);
        Logger.log(CdmStatusLevel.Progress, ctx, tag, message, path, statusEvent);
    }

    public static void info(String tag, CdmCorpusContext ctx, String message) {
        Logger.info(tag, ctx, message, null);
    }

    public static void info(String tag, CdmCorpusContext ctx, String message, String path) {
        Consumer<String> statusEvent = msg -> defaultLogger.info(msg);
        Logger.log(CdmStatusLevel.Info, ctx, tag, message, path, statusEvent);
    }

    public static void warning(String tag, CdmCorpusContext ctx, String message) {
        Logger.warning(tag, ctx, message, null);
    }

    public static void warning(String tag, CdmCorpusContext ctx, String message, String path) {
        Consumer<String> statusEvent = msg -> defaultLogger.warn(msg);
        Logger.log(CdmStatusLevel.Warning, ctx, tag, message, path, statusEvent);
    }

    public static void error(String tag, CdmCorpusContext ctx, String message) {
        Logger.error(tag, ctx, message, null);
    }

    public static void error(String tag, CdmCorpusContext ctx, String message, String path) {
        Consumer<String> statusEvent = msg -> defaultLogger.error(msg);
        Logger.log(CdmStatusLevel.Error, ctx, tag, message, path, statusEvent);
    }

    private static String formatMessage(String tag, String message, String path) {
        return path != null ? MessageFormat.format("{0} | {1} | {2}", tag, message, path) : MessageFormat.format("{0} | {1}", tag, message);
    }

    private static void log(CdmStatusLevel level, CdmCorpusContext ctx, String tag, String message, String path, Consumer<String> defaultStatusEvent) {
        if (level.compareTo(ctx.getReportAtLevel()) >= 0) {
            String formattedMessage = Logger.formatMessage(tag, message, path);
            if (ctx != null && ctx.getStatusEvent() != null) {
                ctx.getStatusEvent().apply(level, formattedMessage);
            } else {
                defaultStatusEvent.accept(message);
            }
        }
    }

    @Deprecated
    public static String format(String str, Object ... arguments) {
        if (str == null) {
            return null;
        }
        return MessageFormat.format(str.replace("'", "''"), arguments);
    }
}

