/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;

public class CdmE2ERelationship
extends CdmObjectDefinitionBase {
    private String name;
    private String fromEntity;
    private String fromEntityAttribute;
    private String toEntity;
    private String toEntityAttribute;

    public CdmE2ERelationship(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.name = name;
        this.fromEntity = null;
        this.fromEntityAttribute = null;
        this.toEntity = null;
        this.toEntityAttribute = null;
        this.setObjectType(CdmObjectType.E2ERelationshipDef);
    }

    @Override
    public boolean visit(String pathRoot, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges) {
            if (Strings.isNullOrEmpty((String)this.getDeclaredPath())) {
                this.setDeclaredPath(pathRoot + this.getName());
            }
            path = this.getDeclaredPath();
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getFromEntity() {
        return this.fromEntity;
    }

    public void setFromEntity(String value) {
        this.fromEntity = value;
    }

    public String getFromEntityAttribute() {
        return this.fromEntityAttribute;
    }

    public void setFromEntityAttribute(String value) {
        this.fromEntityAttribute = value;
    }

    public String getToEntity() {
        return this.toEntity;
    }

    public void setToEntity(String value) {
        this.toEntity = value;
    }

    public String getToEntityAttribute() {
        return this.toEntityAttribute;
    }

    public void setToEntityAttribute(String value) {
        this.toEntityAttribute = value;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (StringUtils.isNullOrTrimEmpty(this.fromEntity)) {
            missingFields.add("fromEntity");
        }
        if (StringUtils.isNullOrTrimEmpty(this.fromEntityAttribute)) {
            missingFields.add("fromEntityAttribute");
        }
        if (StringUtils.isNullOrTrimEmpty(this.toEntity)) {
            missingFields.add("toEntity");
        }
        if (StringUtils.isNullOrTrimEmpty(this.toEntityAttribute)) {
            missingFields.add("toEntityAttribute");
        }
        if (missingFields.size() > 0) {
            Logger.error(CdmE2ERelationship.class.getSimpleName(), this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), missingFields));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmE2ERelationship.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmE2ERelationship copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmE2ERelationship(this.getCtx(), this.getName());
        } else {
            copy = (CdmE2ERelationship)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
        }
        copy.setFromEntity(this.getFromEntity());
        copy.setFromEntityAttribute(this.getFromEntityAttribute());
        copy.setToEntity(this.getToEntity());
        copy.setToEntityAttribute(this.getToEntityAttribute());
        this.copyDef(resOpt, copy);
        return copy;
    }
}

