/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmE2ERelationship;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmReferencedEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmRelationshipDiscoveryStyle;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionDirectiveSet;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;

public class CdmManifestDefinition
extends CdmDocumentDefinition
implements CdmObjectDefinition,
CdmFileStatus {
    private String manifestName;
    private CdmCollection<CdmManifestDeclarationDefinition> subManifests;
    private CdmEntityCollection entities;
    private CdmCollection<CdmE2ERelationship> relationships;
    private String explanation;
    private CdmTraitCollection exhibitsTraits;
    private OffsetDateTime lastFileStatusCheckTime;
    private OffsetDateTime lastFileModifiedTime;
    private OffsetDateTime lastChildFileModifiedTime;

    public CdmManifestDefinition(CdmCorpusContext ctx, String name) {
        super(ctx, name + ".manifest.cdm.json");
        this.setObjectType(CdmObjectType.ManifestDef);
        this.manifestName = name;
        this.entities = new CdmEntityCollection(this.getCtx(), this);
        this.exhibitsTraits = new CdmTraitCollection(this.getCtx(), this);
    }

    public String getManifestName() {
        return this.manifestName;
    }

    public void setManifestName(String manifestName) {
        if (manifestName.endsWith(".folio.cdm.json")) {
            this.manifestName = manifestName.replace(".folio.cdm.json", ".manifest.cdm.json");
        }
        this.manifestName = manifestName;
    }

    @Override
    public OffsetDateTime getLastFileStatusCheckTime() {
        return this.lastFileStatusCheckTime;
    }

    @Override
    public void setLastFileStatusCheckTime(OffsetDateTime lastFileStatusCheckTime) {
        this.lastFileStatusCheckTime = lastFileStatusCheckTime;
    }

    @Override
    public OffsetDateTime getLastFileModifiedTime() {
        return this.lastFileModifiedTime;
    }

    @Override
    public void setLastFileModifiedTime(OffsetDateTime lastFileModifiedTime) {
        this.lastFileModifiedTime = lastFileModifiedTime;
    }

    @Override
    public OffsetDateTime getLastChildFileModifiedTime() {
        return this.lastChildFileModifiedTime;
    }

    @Override
    public void setLastChildFileModifiedTime(OffsetDateTime lastChildFileModifiedTime) {
        this.lastChildFileModifiedTime = lastChildFileModifiedTime;
    }

    @Override
    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public CdmEntityCollection getEntities() {
        return this.entities;
    }

    @Override
    public CdmObjectType getObjectType() {
        return CdmObjectType.ManifestDef;
    }

    public CdmCollection<CdmManifestDeclarationDefinition> getSubManifests() {
        if (this.subManifests == null) {
            this.subManifests = new CdmCollection(this.getCtx(), this, CdmObjectType.ManifestDeclarationDef);
        }
        return this.subManifests;
    }

    public CdmCollection<CdmE2ERelationship> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new CdmCollection(this.getCtx(), this, CdmObjectType.E2ERelationshipDef);
        }
        return this.relationships;
    }

    @Override
    public CdmTraitCollection getExhibitsTraits() {
        return this.exhibitsTraits;
    }

    public void setExhibitsTraits(CdmTraitCollection exhibitsTraits) {
        this.exhibitsTraits = exhibitsTraits;
    }

    @Override
    @Deprecated
    public CompletableFuture<Boolean> saveLinkedDocumentsAsync(CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.getImports() != null) {
                for (CdmImport imp : this.getImports()) {
                    if (this.saveDirtyLinkAsync(imp.getCorpusPath(), options).join().booleanValue()) continue;
                    Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Failed saving imported document '{0}'", imp.getCorpusPath()), "saveLinkedDocumentsAsync");
                    return false;
                }
            }
            if (this.getEntities() != null) {
                for (CdmEntityDeclarationDefinition def : this.getEntities()) {
                    if (def.getObjectType() != CdmObjectType.LocalEntityDeclarationDef) continue;
                    if (!this.saveDirtyLinkAsync(def.getEntityPath(), options).join().booleanValue()) {
                        Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Failed saving local entity schema document '{0}'", def.getEntityPath()), "saveLinkedDocumentsAsync");
                        return false;
                    }
                    if (def.getDataPartitions() != null) {
                        for (CdmDataPartitionDefinition cdmDataPartitionDefinition : def.getDataPartitions()) {
                            if (cdmDataPartitionDefinition.getSpecializedSchema() == null || this.saveDirtyLinkAsync(cdmDataPartitionDefinition.getSpecializedSchema(), options).join().booleanValue()) continue;
                            Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Failed saving partition schema document '{0}'", cdmDataPartitionDefinition.getSpecializedSchema()), "saveLinkedDocumentsAsync");
                            return false;
                        }
                    }
                    if (def.getDataPartitionPatterns() == null) continue;
                    for (CdmDataPartitionPatternDefinition cdmDataPartitionPatternDefinition : def.getDataPartitionPatterns()) {
                        if (cdmDataPartitionPatternDefinition.getSpecializedSchema() == null || this.saveDirtyLinkAsync(cdmDataPartitionPatternDefinition.getSpecializedSchema(), options).join().booleanValue()) continue;
                        Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("failed saving partition schema document '{0}'", cdmDataPartitionPatternDefinition.getSpecializedSchema()), "saveLinkedDocumentsAsync");
                        return false;
                    }
                }
            }
            if (this.getSubManifests() != null) {
                for (CdmManifestDeclarationDefinition sub : this.getSubManifests()) {
                    if (this.saveDirtyLinkAsync(sub.getDefinition(), options).join().booleanValue()) continue;
                    Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Failed saving sub-manifest document '{0}'.", sub.getDefinition()), "saveLinkedDocumentsAsync");
                    return false;
                }
            }
            return true;
        });
    }

    private CompletableFuture<Boolean> saveDirtyLinkAsync(String relative, CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            CdmObject objAt = (CdmObject)this.getCtx().getCorpus().fetchObjectAsync(relative, this).join();
            if (objAt == null) {
                Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Invalid corpus path '{0}'", relative), "saveDirtyLinkAsync");
                return false;
            }
            CdmDocumentDefinition docImp = objAt.getInDocument();
            if (docImp != null && docImp.isDirty() && !docImp.saveAsAsync(docImp.getName(), true, options).join().booleanValue()) {
                Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Failed saving document '{0}'", docImp.getName()), "saveDirtyLinkAsync");
                return false;
            }
            return true;
        });
    }

    public CompletableFuture<Void> populateManifestRelationshipsAsync() {
        return this.populateManifestRelationshipsAsync(CdmRelationshipDiscoveryStyle.All);
    }

    public CompletableFuture<Void> populateManifestRelationshipsAsync(CdmRelationshipDiscoveryStyle option) {
        return CompletableFuture.runAsync(() -> {
            this.getRelationships().clear();
            ConcurrentHashMap.KeySetView relCache = ConcurrentHashMap.newKeySet();
            for (CdmEntityDeclarationDefinition entDec : this.getEntities()) {
                ArrayList<CdmE2ERelationship> incomingRels;
                String entPath = this.createEntityPathFromDeclarationAsync(entDec, this).join();
                CdmEntityDefinition currEntity = (CdmEntityDefinition)this.getCtx().getCorpus().fetchObjectAsync(entPath).join();
                if (currEntity == null) continue;
                ArrayList<CdmE2ERelationship> outgoingRels = this.getCtx().getCorpus().fetchOutgoingRelationships(currEntity);
                if (outgoingRels != null) {
                    for (CdmE2ERelationship outgoingRel : outgoingRels) {
                        String cacheKey = this.rel2CacheKey(outgoingRel);
                        if (relCache.contains(cacheKey) || !this.isRelAllowed(outgoingRel, option)) continue;
                        this.getRelationships().add(this.localizeRelToManifest(outgoingRel));
                        relCache.add(cacheKey);
                    }
                }
                if ((incomingRels = this.getCtx().getCorpus().fetchIncomingRelationships(currEntity)) == null) continue;
                for (CdmE2ERelationship inRel : incomingRels) {
                    CdmEntityDefinition currentInBase = (CdmEntityDefinition)this.getCtx().getCorpus().fetchObjectAsync(inRel.getToEntity(), this).join();
                    if (currentInBase == null) continue;
                    CdmCollection<CdmEntityDefinition> toInheritanceGraph = new CdmCollection<CdmEntityDefinition>(this.getCtx(), this, this.getObjectType());
                    while (currentInBase != null) {
                        ResolveOptions resOpt = new ResolveOptions();
                        resOpt.setWrtDoc(currentInBase.getInDocument());
                        if ((currentInBase = currentInBase.getExtendsEntity() != null ? (CdmEntityDefinition)currentInBase.getExtendsEntity().fetchObjectDefinition(resOpt) : null) == null) continue;
                        toInheritanceGraph.add(currentInBase);
                    }
                    String cacheKey = this.rel2CacheKey(inRel);
                    if (!relCache.contains(cacheKey) && this.isRelAllowed(inRel, option)) {
                        this.getRelationships().add(this.localizeRelToManifest(inRel));
                        relCache.add(cacheKey);
                    }
                    for (CdmEntityDefinition baseEntity : toInheritanceGraph) {
                        ArrayList<CdmE2ERelationship> incomingRelsForBase = this.getCtx().getCorpus().fetchIncomingRelationships(baseEntity);
                        if (incomingRelsForBase == null) continue;
                        for (CdmE2ERelationship inRelBase : incomingRelsForBase) {
                            CdmE2ERelationship newRel = new CdmE2ERelationship(this.getCtx(), "");
                            newRel.setFromEntity(inRelBase.getFromEntity());
                            newRel.setFromEntityAttribute(inRelBase.getFromEntityAttribute());
                            newRel.setToEntity(inRel.getToEntity());
                            newRel.setToEntityAttribute(inRel.getToEntityAttribute());
                            String baseRelCacheKey = this.rel2CacheKey(newRel);
                            if (relCache.contains(baseRelCacheKey) || !this.isRelAllowed(newRel, option)) continue;
                            this.getRelationships().add(this.localizeRelToManifest(newRel));
                            relCache.add(baseRelCacheKey);
                        }
                    }
                }
            }
            if (this.getSubManifests() != null) {
                for (CdmManifestDeclarationDefinition subManifestDef : this.getSubManifests()) {
                    String corpusPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(subManifestDef.getDefinition(), this);
                    CdmManifestDefinition subManifest = (CdmManifestDefinition)this.getCtx().getCorpus().fetchObjectAsync(corpusPath).join();
                    subManifest.populateManifestRelationshipsAsync(option).join();
                }
            }
        });
    }

    @Override
    public CompletableFuture<Void> fileStatusCheckAsync() {
        return CompletableFuture.runAsync(() -> {
            StorageAdapter storageAdapterInterface = this.getCtx().getCorpus().getStorage().fetchAdapter(this.getInDocument().getNamespace());
            StorageAdapterBase.CacheContext cacheContext = null;
            if (storageAdapterInterface instanceof StorageAdapterBase) {
                cacheContext = ((StorageAdapterBase)storageAdapterInterface).createFileQueryCacheContext();
            }
            try {
                OffsetDateTime modifiedTime = this.getCtx().getCorpus().computeLastModifiedTimeFromObjectAsync(this).join();
                this.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
                if (this.getLastFileModifiedTime() == null) {
                    this.setLastFileModifiedTime(this.getFileSystemModifiedTime());
                }
                if (!Objects.equals(modifiedTime, this.getFileSystemModifiedTime())) {
                    this.reloadAsync().join();
                    this.setLastFileModifiedTime(TimeUtils.maxTime(modifiedTime, this.getLastFileModifiedTime()));
                    this.setFileSystemModifiedTime(this.getLastFileModifiedTime());
                }
                for (CdmEntityDeclarationDefinition entity : this.getEntities()) {
                    entity.fileStatusCheckAsync().join();
                }
                for (CdmManifestDeclarationDefinition subManifest : this.getSubManifests()) {
                    subManifest.fileStatusCheckAsync().join();
                }
            }
            finally {
                if (cacheContext != null) {
                    cacheContext.dispose();
                }
            }
        });
    }

    @Override
    public CompletableFuture<Void> reportMostRecentTimeAsync(OffsetDateTime childTime) {
        if (childTime != null) {
            this.setLastChildFileModifiedTime(TimeUtils.maxTime(childTime, this.getLastChildFileModifiedTime()));
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<List<?>> queryOnTraitsAsync(Object querySpec) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        if (preChildren != null && preChildren.invoke(this, pathFrom)) {
            return false;
        }
        if (this.getDefinitions() != null && this.getDefinitions().visitList(pathFrom, preChildren, postChildren)) {
            return true;
        }
        if (this.getEntities() != null && this.entities.visitList(pathFrom, preChildren, postChildren)) {
            return true;
        }
        if (this.getRelationships() != null && this.getRelationships().visitList(pathFrom + "/relationships/", preChildren, postChildren)) {
            return true;
        }
        if (this.getSubManifests() != null && this.getSubManifests().visitList(pathFrom + "/subManifests/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, pathFrom);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmManifestDefinition tempHost = (CdmManifestDefinition)host;
        if (tempHost == null) {
            tempHost = new CdmManifestDefinition(this.getCtx(), this.getManifestName());
        }
        CdmManifestDefinition copy = (CdmManifestDefinition)super.copy(resOpt, tempHost);
        copy.setManifestName(this.getManifestName());
        copy.setExplanation(this.getExplanation());
        copy.setLastFileStatusCheckTime(this.getLastFileStatusCheckTime());
        copy.setLastFileModifiedTime(this.getLastFileModifiedTime());
        copy.setLastChildFileModifiedTime(this.getLastChildFileModifiedTime());
        copy.getEntities().clear();
        this.getEntities().forEach(copy.getEntities()::add);
        copy.getRelationships().clear();
        this.getRelationships().forEach(copy.getRelationships()::add);
        copy.getSubManifests().clear();
        this.getSubManifests().forEach(copy.getSubManifests()::add);
        copy.getExhibitsTraits().clear();
        this.getExhibitsTraits().forEach(copy.getExhibitsTraits()::add);
        return copy;
    }

    public CompletableFuture<CdmManifestDefinition> createResolvedManifestAsync(String newManifestName, String newEntityDocumentNameFormat) {
        return this.createResolvedManifestAsync(newManifestName, newEntityDocumentNameFormat, null);
    }

    public CompletableFuture<CdmManifestDefinition> createResolvedManifestAsync(String newManifestName, String newEntityDocumentNameFormat, AttributeResolutionDirectiveSet directives) {
        CdmFolderDefinition resolvedManifestFolder;
        if (null == this.getEntities()) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.getFolder() == null) {
            Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Cannot resolve the manifest '{0}' because it has not been added to a folder.", this.manifestName), "createResolvedManifestAsync");
            return CompletableFuture.completedFuture(null);
        }
        if (null == newEntityDocumentNameFormat) {
            newEntityDocumentNameFormat = "{f}resolved/{n}.cdm.json";
        } else if (newEntityDocumentNameFormat.isEmpty()) {
            newEntityDocumentNameFormat = "{n}.cdm.json";
        } else if (!newEntityDocumentNameFormat.contains("{n}")) {
            newEntityDocumentNameFormat = newEntityDocumentNameFormat + "/{n}.cdm.json";
        }
        String sourceManifestPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getAtCorpusPath(), this);
        String sourceManifestFolderPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getFolder().getAtCorpusPath(), this);
        int resolvedManifestPathSplit = newManifestName.lastIndexOf("/") + 1;
        if (resolvedManifestPathSplit > 0) {
            String resolvedManifestPath = newManifestName.substring(0, resolvedManifestPathSplit);
            String newFolderPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(resolvedManifestPath, this);
            resolvedManifestFolder = (CdmFolderDefinition)this.getCtx().getCorpus().fetchObjectAsync(newFolderPath).join();
            if (resolvedManifestFolder == null) {
                Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("New folder for manifest not found {0}", newFolderPath), "createResolvedManifestAsync");
                return CompletableFuture.completedFuture(null);
            }
            newManifestName = newManifestName.substring(resolvedManifestPathSplit);
        } else {
            resolvedManifestFolder = (CdmFolderDefinition)this.getOwner();
        }
        Logger.debug(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Resolving manifest '{0}'", sourceManifestPath), "createResolvedManifestAsync");
        if (newManifestName.toLowerCase().endsWith(".manifest.cdm.json")) {
            newManifestName = newManifestName.substring(0, newManifestName.length() - ".manifest.cdm.json".length());
        }
        CdmManifestDefinition resolvedManifest = new CdmManifestDefinition(this.getCtx(), newManifestName);
        resolvedManifest.setSchema(this.getSchema());
        resolvedManifest.setExplanation(this.explanation);
        for (CdmImport imp : this.getImports()) {
            resolvedManifest.getImports().add((CdmImport)imp.copy());
        }
        if (resolvedManifestFolder.getDocuments().add(resolvedManifest) == null) {
            return CompletableFuture.completedFuture(null);
        }
        String finalNewEntityDocumentNameFormat = newEntityDocumentNameFormat;
        return CompletableFuture.supplyAsync(() -> {
            for (CdmEntityDeclarationDefinition entity : this.getEntities()) {
                CdmEntityDefinition entDef = this.getEntityFromReferenceAsync(entity, this).join();
                if (null == entDef) {
                    Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), "Unable to get entity from reference", "createResolvedManifestAsync");
                    return null;
                }
                if (entDef.getInDocument().getFolder() == null) {
                    Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("The document containing the entity '{0}' is not in a folder", entDef.getEntityName()), "createResolvedManifestAsync");
                    return null;
                }
                String sourceEntityFullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(entDef.getInDocument().getFolder().getAtCorpusPath(), this);
                String f = "";
                if (sourceEntityFullPath.startsWith(sourceManifestFolderPath)) {
                    f = sourceEntityFullPath.substring(sourceManifestFolderPath.length());
                }
                String newDocumentFullPath = finalNewEntityDocumentNameFormat.replace("{n}", entDef.getEntityName());
                newDocumentFullPath = newDocumentFullPath.replace("{f}", f);
                newDocumentFullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(newDocumentFullPath, this);
                int newDocumentPathSplit = newDocumentFullPath.lastIndexOf("/") + 1;
                String newDocumentPath = newDocumentFullPath.substring(0, newDocumentPathSplit);
                String newDocumentName = newDocumentFullPath.substring(newDocumentPathSplit);
                CdmFolderDefinition folder = (CdmFolderDefinition)this.getCtx().getCorpus().fetchObjectAsync(newDocumentPath).join();
                if (null == folder) {
                    Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("New folder not found '{0}'", newDocumentPath), "createResolvedManifestAsync");
                    return null;
                }
                AttributeResolutionDirectiveSet withDirectives = directives != null ? directives : this.getCtx().getCorpus().getDefaultResolutionDirectives();
                ResolveOptions resOpt = new ResolveOptions(entDef.getInDocument(), withDirectives != null ? withDirectives.copy() : null);
                Logger.debug(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("    resolving entity {0} to document {1}", sourceEntityFullPath, newDocumentFullPath), "createResolvedManifestAsync");
                CdmEntityDefinition resolvedEntity = entDef.createResolvedEntityAsync(entDef.getEntityName(), resOpt, folder, newDocumentName).join();
                if (null == resolvedEntity) {
                    return null;
                }
                CdmEntityDeclarationDefinition result = (CdmEntityDeclarationDefinition)entity.copy(resOpt);
                if (result.getObjectType() == CdmObjectType.LocalEntityDeclarationDef) {
                    result.setEntityPath((String)ObjectUtils.firstNonNull((Object[])new String[]{this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(resolvedEntity.getAtCorpusPath(), resolvedManifest), result.getAtCorpusPath()}));
                }
                resolvedManifest.getEntities().add(result);
            }
            Logger.debug(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), "    calculating relationships", "createResolvedManifestAsync");
            this.getCtx().getCorpus().calculateEntityGraphAsync(resolvedManifest).join();
            resolvedManifest.populateManifestRelationshipsAsync(CdmRelationshipDiscoveryStyle.Exclusive).join();
            resolvedManifest.setDirty(true);
            return resolvedManifest;
        });
    }

    private CompletableFuture<CdmEntityDefinition> getEntityFromReferenceAsync(CdmEntityDeclarationDefinition entity, CdmManifestDefinition manifest) {
        return CompletableFuture.supplyAsync(() -> {
            String entityPath = this.createEntityPathFromDeclarationAsync(entity, manifest).join();
            CdmEntityDefinition result = (CdmEntityDefinition)this.getCtx().getCorpus().fetchObjectAsync(entityPath).join();
            if (null == result) {
                Logger.error(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Failed to resolve entity {0}", entityPath), "getEntityFromReferenceAsync");
            }
            return result;
        });
    }

    @Deprecated
    public CompletableFuture<String> createEntityPathFromDeclarationAsync(CdmEntityDeclarationDefinition entityDec) {
        return this.createEntityPathFromDeclarationAsync(entityDec, null);
    }

    CompletableFuture<String> createEntityPathFromDeclarationAsync(CdmEntityDeclarationDefinition entityDec, CdmObject obj) {
        while (entityDec instanceof CdmReferencedEntityDeclarationDefinition) {
            String currCorpusPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(entityDec.getEntityPath(), obj);
            entityDec = (CdmEntityDeclarationDefinition)this.getCtx().getCorpus().fetchObjectAsync(currCorpusPath).join();
            if (entityDec == null) {
                return null;
            }
            obj = entityDec.getInDocument();
        }
        return CompletableFuture.completedFuture(entityDec != null ? this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(entityDec.getEntityPath(), obj) : null);
    }

    boolean isRelAllowed(CdmE2ERelationship rel, CdmRelationshipDiscoveryStyle option) {
        if (option == CdmRelationshipDiscoveryStyle.None) {
            return false;
        }
        if (option == CdmRelationshipDiscoveryStyle.Exclusive) {
            String absoluteFromEntString = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(rel.getFromEntity(), this);
            boolean fromEntInManifest = this.getEntities().getAllItems().stream().anyMatch(x -> Objects.equals(this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(x.getEntityPath(), this), absoluteFromEntString));
            String absoluteToEntString = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(rel.getToEntity(), this);
            boolean toEntInManifest = this.getEntities().getAllItems().parallelStream().anyMatch(x -> Objects.equals(this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(x.getEntityPath(), this), absoluteToEntString));
            return fromEntInManifest && toEntInManifest;
        }
        return true;
    }

    CdmE2ERelationship localizeRelToManifest(CdmE2ERelationship rel) {
        CdmE2ERelationship relCopy = (CdmE2ERelationship)this.getCtx().getCorpus().makeObject(CdmObjectType.E2ERelationshipDef, rel.getName());
        relCopy.setToEntity(this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(rel.getToEntity(), this));
        relCopy.setFromEntity(this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(rel.getFromEntity(), this));
        relCopy.setToEntityAttribute(rel.getToEntityAttribute());
        relCopy.setFromEntityAttribute(rel.getFromEntityAttribute());
        return relCopy;
    }

    String rel2CacheKey(CdmE2ERelationship rel) {
        String nameAndPipe = "";
        if (!StringUtils.isNullOrTrimEmpty(rel.getName())) {
            nameAndPipe = rel.getName() + "|";
        }
        return nameAndPipe + rel.getToEntity() + "|" + rel.getToEntityAttribute() + "|" + rel.getFromEntity() + "|" + rel.getFromEntityAttribute();
    }
}

