/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmPurposeReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;

public class CdmPurposeDefinition
extends CdmObjectDefinitionBase {
    public String purposeName;
    public CdmPurposeReference extendsPurpose;

    public CdmPurposeDefinition(CdmCorpusContext ctx, String purposeName) {
        this(ctx, purposeName, null);
    }

    public CdmPurposeDefinition(CdmCorpusContext ctx, String purposeName, CdmPurposeReference extendsPurpose) {
        super(ctx);
        this.setObjectType(CdmObjectType.PurposeDef);
        this.setPurposeName(purposeName);
        if (extendsPurpose != null) {
            this.setExtendsPurpose(extendsPurpose);
        }
    }

    @Override
    public String getName() {
        return this.getPurposeName();
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        return this.isDerivedFromDef(resOpt, this.getExtendsPurpose(), this.getName(), baseDef);
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges && Strings.isNullOrEmpty((String)(path = this.getDeclaredPath()))) {
            path = pathFrom + this.getPurposeName();
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getExtendsPurpose() != null) {
            this.getExtendsPurpose().setOwner(this);
            if (this.getExtendsPurpose().visit(path + "/extendsPurpose/", preChildren, postChildren)) {
                return true;
            }
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    public CdmPurposeReference getExtendsPurpose() {
        return this.extendsPurpose;
    }

    public void setExtendsPurpose(CdmPurposeReference value) {
        this.extendsPurpose = value;
    }

    public String getPurposeName() {
        return this.purposeName;
    }

    public void setPurposeName(String value) {
        this.purposeName = value;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.purposeName)) {
            Logger.error(CdmPurposeDefinition.class.getSimpleName(), this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), new ArrayList<String>(Arrays.asList("purposeName"))));
            return false;
        }
        return true;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        this.constructResolvedTraitsDef(this.getExtendsPurpose(), rtsb, resOpt);
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmPurposeDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmPurposeDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmPurposeDefinition(this.getCtx(), this.getPurposeName(), null);
        } else {
            copy = (CdmPurposeDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setPurposeName(this.getPurposeName());
        }
        if (this.getExtendsPurpose() != null) {
            copy.setExtendsPurpose((CdmPurposeReference)this.getExtendsPurpose().copy(resOpt));
        }
        this.copyDef(resOpt, copy);
        return copy;
    }
}

