/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeContextTreeBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionResolutionCommonUtil;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CdmOperationExcludeAttributes
extends CdmOperationBase {
    private String TAG = CdmOperationExcludeAttributes.class.getSimpleName();
    private List<String> excludeAttributes;

    public CdmOperationExcludeAttributes(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.OperationExcludeAttributesDef);
        this.setType(CdmOperationType.ExcludeAttributes);
        this.excludeAttributes = new ArrayList<String>();
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmOperationExcludeAttributes copy = new CdmOperationExcludeAttributes(this.getCtx());
        copy.excludeAttributes = new ArrayList<String>(this.excludeAttributes);
        return copy;
    }

    public List<String> getExcludeAttributes() {
        return this.excludeAttributes;
    }

    public void setExcludeAttributes(List<String> excludeAttributes) {
        this.excludeAttributes = excludeAttributes;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmOperationExcludeAttributes.class);
    }

    @Override
    public String getName() {
        return "operationExcludeAttributes";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.OperationExcludeAttributesDef;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.excludeAttributes == null) {
            missingFields.add("excludeAttributes");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.TAG, this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), missingFields));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().getBlockDeclaredPathChanges() && StringUtils.isNullOrEmpty(path = this.getDeclaredPath())) {
            path = pathFrom + "operationExcludeAttributes";
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ProjectionAttributeStateSet appendProjectionAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet, CdmAttributeContext attrCtx) {
        AttributeContextParameters attrCtxOpExcludeAttrsParam = new AttributeContextParameters();
        attrCtxOpExcludeAttrsParam.setUnder(attrCtx);
        attrCtxOpExcludeAttrsParam.setType(CdmAttributeContextType.OperationExcludeAttributes);
        attrCtxOpExcludeAttrsParam.setName("operation/index" + this.getIndex() + "/operationExcludeAttributes");
        CdmAttributeContext attrCtxOpExcludeAttrs = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxOpExcludeAttrsParam);
        Map<String, String> topLevelExcludeAttributeNames = ProjectionResolutionCommonUtil.getTopList(projCtx, this.excludeAttributes);
        ProjectionAttributeContextTreeBuilder attrCtxTreeBuilder = new ProjectionAttributeContextTreeBuilder(attrCtxOpExcludeAttrs);
        for (ProjectionAttributeState currentPAS : projCtx.getCurrentAttributeStateSet().getStates()) {
            if (!topLevelExcludeAttributeNames.containsKey(currentPAS.getCurrentResolvedAttribute().getResolvedName())) {
                attrCtxTreeBuilder.createAndStoreAttributeContextParameters(null, currentPAS, currentPAS.getCurrentResolvedAttribute(), CdmAttributeContextType.AttributeDefinition, currentPAS.getCurrentResolvedAttribute().getAttCtx(), null);
                ProjectionAttributeState newPAS = currentPAS.copy();
                projOutputSet.add(newPAS);
                continue;
            }
            String excludeAttributeName = topLevelExcludeAttributeNames.get(currentPAS.getCurrentResolvedAttribute().getResolvedName());
            attrCtxTreeBuilder.createAndStoreAttributeContextParameters(excludeAttributeName, currentPAS, currentPAS.getCurrentResolvedAttribute(), CdmAttributeContextType.AttributeDefinition, currentPAS.getCurrentResolvedAttribute().getAttCtx(), null);
        }
        attrCtxTreeBuilder.constructAttributeContextTree(projCtx);
        return projOutputSet;
    }
}

