/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddAttributeGroup;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.OperationTypeConvertor;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAddAttributeGroup;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;

public class OperationAddAttributeGroupPersistence {
    public static CdmOperationAddAttributeGroup fromData(CdmCorpusContext ctx, JsonNode obj) {
        if (obj == null) {
            return null;
        }
        CdmOperationAddAttributeGroup addAttributeGroupOp = (CdmOperationAddAttributeGroup)ctx.getCorpus().makeObject(CdmObjectType.OperationAddAttributeGroupDef);
        if (obj.get("$type") != null && !StringUtils.equalsWithIgnoreCase(obj.get("$type").asText(), OperationTypeConvertor.operationTypeToString(CdmOperationType.AddAttributeGroup))) {
            Logger.error(OperationAddAttributeGroupPersistence.class.getSimpleName(), ctx, Logger.format("$type {0} is invalid for this operation.", obj.get("$type").asText()));
        } else {
            addAttributeGroupOp.setType(CdmOperationType.AddAttributeGroup);
        }
        if (obj.get("attributeGroupName") != null) {
            addAttributeGroupOp.setAttributeGroupName(obj.get("attributeGroupName").asText());
        }
        if (obj.get("explanation") != null) {
            addAttributeGroupOp.setExplanation(obj.get("explanation").asText());
        }
        return addAttributeGroupOp;
    }

    public static OperationAddAttributeGroup toData(CdmOperationAddAttributeGroup instance, ResolveOptions resOpt, CopyOptions options) {
        if (instance == null) {
            return null;
        }
        OperationAddAttributeGroup obj = new OperationAddAttributeGroup();
        obj.setType(OperationTypeConvertor.operationTypeToString(CdmOperationType.AddAttributeGroup));
        obj.setAttributeGroupName(instance.getAttributeGroupName());
        obj.setExplanation(instance.getExplanation());
        return obj;
    }
}

