/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.modeljson;

import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ImportPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.Import;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.EntityPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.LocalEntity;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DocumentPersistence {
    public static CompletableFuture<CdmDocumentDefinition> fromData(CdmCorpusContext ctx, LocalEntity obj, List<CdmTraitDefinition> extensionTraitDefList, List<CdmTraitDefinition> localExtensionTraitDefList) {
        return CompletableFuture.supplyAsync(() -> {
            String docName = obj.getName() + ".cdm.json";
            CdmDocumentDefinition document = (CdmDocumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.DocumentDef, docName);
            document.getImports().add("cdm:/foundations.cdm.json");
            CdmEntityDefinition entity = EntityPersistence.fromData(ctx, obj, extensionTraitDefList, localExtensionTraitDefList).join();
            if (entity == null) {
                Logger.error(DocumentPersistence.class.getSimpleName(), ctx, "There was an error while trying to convert a model.json entity to the CDM entity.");
                return null;
            }
            if (obj.getImports() != null) {
                for (Import anImport : obj.getImports()) {
                    if (Objects.equals("cdm:/foundations.cdm.json", anImport.getCorpusPath())) continue;
                    document.getImports().add(ImportPersistence.fromData(ctx, anImport));
                }
            }
            document.getDefinitions().add(entity);
            return document;
        });
    }

    public static CompletableFuture<LocalEntity> toData(Object documentObjectOrPath, CdmManifestDefinition manifest, CdmCorpusContext ctx, ResolveOptions resOpt, CopyOptions options) {
        if (documentObjectOrPath instanceof String) {
            return ctx.getCorpus().fetchObjectAsync((String)documentObjectOrPath, manifest).thenApply(cdmEntity -> {
                if (cdmEntity instanceof CdmEntityDefinition) {
                    LocalEntity entity = EntityPersistence.toData((CdmEntityDefinition)cdmEntity, ctx, resOpt, options).join();
                    CdmObject owner = cdmEntity.getOwner();
                    if (owner instanceof CdmDocumentDefinition) {
                        CdmDocumentDefinition documentDefinition = (CdmDocumentDefinition)owner;
                        if (documentDefinition.getImports().getCount() > 0) {
                            entity.setImports(new ArrayList<Import>());
                            documentDefinition.getImports().forEach(element -> {
                                Import cdmImport = ImportPersistence.toData(element, resOpt, options);
                                String absolutePath = ctx.getCorpus().getStorage().createAbsoluteCorpusPath(cdmImport.getCorpusPath(), documentDefinition);
                                if (!Strings.isNullOrEmpty((String)documentDefinition.getNamespace()) && absolutePath.startsWith(documentDefinition.getNamespace() + ":")) {
                                    absolutePath = absolutePath.substring(documentDefinition.getNamespace().length() + 1);
                                }
                                cdmImport.setCorpusPath(ctx.getCorpus().getStorage().createRelativeCorpusPath(absolutePath, manifest));
                                entity.getImports().add(cdmImport);
                            });
                        }
                    } else {
                        Logger.warning(DocumentPersistence.class.getSimpleName(), ctx, Logger.format("Entity '{0}' is not inside a document or its owner is not a document.", ((CdmEntityDefinition)cdmEntity).getName()));
                    }
                    return entity;
                }
                Logger.error(DocumentPersistence.class.getSimpleName(), ctx, "There was an error while trying to fetch cdm entity doc.");
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }
}

