/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmContainerDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.storage.AdlsAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.CdmStandardsAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.GithubAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.LocalAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.RemoteAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.ResourceAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.StorageUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class StorageManager {
    private final CdmCorpusDefinition corpus;
    private final Map<String, CdmFolderDefinition> namespaceFolder = new LinkedHashMap<String, CdmFolderDefinition>();
    private String defaultNamespace;
    private Map<String, StorageAdapter> namespaceAdapters = new LinkedHashMap<String, StorageAdapter>();
    private Set<String> systemDefinedNamespaces;

    public StorageManager(CdmCorpusDefinition corpus) {
        this.corpus = corpus;
        this.systemDefinedNamespaces = new HashSet<String>();
        this.mount("local", new LocalAdapter(System.getProperty("user.dir") + "\\objectmodel"));
        this.mount("cdm", new CdmStandardsAdapter());
        this.systemDefinedNamespaces.add("local");
        this.systemDefinedNamespaces.add("cdm");
    }

    public void mount(String nameSpace, StorageAdapter adapter) {
        if (StringUtils.isNullOrTrimEmpty(nameSpace)) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The namespace cannot be null or empty.", "mount");
            return;
        }
        if (adapter != null) {
            this.namespaceAdapters.put(nameSpace, adapter);
            CdmFolderDefinition fd = new CdmFolderDefinition(this.corpus.getCtx(), "");
            fd.setCorpus(this.corpus);
            fd.setNamespace(nameSpace);
            fd.setFolderPath("/");
            this.namespaceFolder.put(nameSpace, fd);
            this.systemDefinedNamespaces.remove(nameSpace);
        } else {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The adapter cannot be null.", "mount");
        }
    }

    public List<String> mountFromConfig(String adapterConfig) {
        return this.mountFromConfig(adapterConfig, false);
    }

    public List<String> mountFromConfig(String adapterConfig, boolean doesReturnErrorList) {
        JsonNode adapterConfigJson;
        if (Strings.isNullOrEmpty((String)adapterConfig)) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "Adapter config cannot be null or empty.", "mountFromConfig");
            return null;
        }
        try {
            adapterConfigJson = JMapper.MAP.readTree(adapterConfig);
        }
        catch (IOException e) {
            throw new StorageAdapterException("Failed to convert config jsonNode", e);
        }
        if (adapterConfigJson.has("appId")) {
            this.corpus.setAppId(adapterConfigJson.get("appId").asText());
        }
        if (adapterConfigJson.has("defaultNamespace")) {
            this.defaultNamespace = adapterConfigJson.get("defaultNamespace").asText();
        }
        ArrayList<String> unrecognizedAdapters = new ArrayList<String>();
        for (JsonNode item : adapterConfigJson.get("adapters")) {
            if (!item.has("namespace")) {
                Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The namespace is missing for one of the adapters in the JSON config.", "mountFromConfig");
                continue;
            }
            String nameSpace = item.get("namespace").asText();
            if (!item.has("config")) {
                Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("Missing JSON config for the namespace {0}.", nameSpace), "mountFromConfig");
                continue;
            }
            JsonNode configs = item.get("config");
            if (!item.has("type")) {
                Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("Missing type in the JSON config for the namespace {0}.", nameSpace), "mountFromConfig");
                continue;
            }
            try {
                String itemType = item.get("type").asText();
                StorageAdapterBase adapter = null;
                switch (itemType) {
                    case "cdm-standards": {
                        adapter = new CdmStandardsAdapter();
                        break;
                    }
                    case "local": {
                        adapter = new LocalAdapter();
                        break;
                    }
                    case "github": {
                        adapter = new GithubAdapter();
                        break;
                    }
                    case "remote": {
                        adapter = new RemoteAdapter();
                        break;
                    }
                    case "adls": {
                        adapter = new AdlsAdapter();
                        break;
                    }
                    default: {
                        unrecognizedAdapters.add(JMapper.WRITER.writeValueAsString((Object)item));
                    }
                }
                if (adapter == null) continue;
                adapter.updateConfig(JMapper.WRITER.writeValueAsString((Object)configs));
                this.mount(nameSpace, adapter);
            }
            catch (JsonProcessingException e) {
                throw new StorageAdapterException("Failed to process config as String", (Exception)((Object)e));
            }
            catch (MalformedURLException e) {
                throw new StorageAdapterException("Config contains malformed URL.", e);
            }
            catch (IOException e) {
                throw new StorageAdapterException("Failed to construct adapter. AdapterType: " + item.get("type").asText(), e);
            }
        }
        return doesReturnErrorList ? unrecognizedAdapters : null;
    }

    public boolean unmount(String nameSpace) {
        if (StringUtils.isNullOrTrimEmpty(nameSpace)) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The namespace cannot be null or empty.", "unmount");
            return false;
        }
        if (this.namespaceAdapters.containsKey(nameSpace)) {
            this.namespaceAdapters.remove(nameSpace);
            this.namespaceFolder.remove(nameSpace);
            this.systemDefinedNamespaces.remove(nameSpace);
            if (nameSpace.equals("cdm")) {
                this.mount(nameSpace, new ResourceAdapter());
            }
            return true;
        }
        Logger.warning(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "Cannot remove the adapter from non-existing namespace.", "unmount");
        return false;
    }

    @Deprecated
    public void setAdapter(String nameSpace, StorageAdapter adapter) {
        if (StringUtils.isNullOrTrimEmpty(nameSpace)) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The namespace cannot be null or empty.", "setAdapter");
            return;
        }
        if (adapter != null) {
            this.namespaceAdapters.put(nameSpace, adapter);
        } else {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The adapter cannot be null.", "setAdapter");
        }
    }

    public StorageAdapter fetchAdapter(String nameSpace) {
        if (StringUtils.isNullOrTrimEmpty(nameSpace)) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The namespace cannot be null or empty.", "fetchAdapter");
            return null;
        }
        if (this.namespaceFolder.containsKey(nameSpace)) {
            return this.namespaceAdapters.get(nameSpace);
        }
        Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("Adapter not found for the namespace '{0}'", nameSpace), "fetchAdapter");
        return null;
    }

    public CdmFolderDefinition fetchRootFolder(String nameSpace) {
        if (StringUtils.isNullOrTrimEmpty(nameSpace)) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The namespace cannot be null or empty.", "fetchRootFolder");
            return null;
        }
        if (this.namespaceFolder.containsKey(nameSpace)) {
            return this.namespaceFolder.get(nameSpace);
        }
        if (this.namespaceFolder.containsKey(this.defaultNamespace)) {
            return this.namespaceFolder.get(this.defaultNamespace);
        }
        Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("Adapter not found for the namespace '{0}'", nameSpace), "fetchRootFolder");
        return null;
    }

    public String adapterPathToCorpusPath(String adapterPath) {
        for (Map.Entry<String, StorageAdapter> kv : this.namespaceAdapters.entrySet()) {
            String corpusPath = kv.getValue().createCorpusPath(adapterPath);
            if (corpusPath == null) continue;
            return kv.getKey() + ":" + corpusPath;
        }
        Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("No registered storage adapter understood the path '{0}'", adapterPath), "adapterPathToCorpusPath");
        return null;
    }

    public String corpusPathToAdapterPath(String corpusPath) {
        String nameSpace;
        if (StringUtils.isNullOrTrimEmpty(corpusPath)) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The corpus path is null or empty.", "corpusPathToAdapterPath");
            return null;
        }
        ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(corpusPath);
        if (pathTuple == null) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The corpus path cannot be null or empty.", "corpusPathToAdapterPath");
            return null;
        }
        String string = nameSpace = !StringUtils.isNullOrTrimEmpty((String)pathTuple.getLeft()) ? (String)pathTuple.getLeft() : this.defaultNamespace;
        if (this.fetchAdapter(nameSpace) == null) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("The namespace '{0}' has not been registered", nameSpace), "corpusPathToAdapterPath");
            return "";
        }
        return this.fetchAdapter(nameSpace).createAdapterPath((String)pathTuple.getRight());
    }

    public String createAbsoluteCorpusPath(String objectPath) {
        return this.createAbsoluteCorpusPath(objectPath, null);
    }

    public String createAbsoluteCorpusPath(String objectPath, CdmObject obj) {
        String finalNamespace;
        if (StringUtils.isNullOrTrimEmpty(objectPath)) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The object path cannot null or empty.", "createAbsoluteCorpusPath");
            return null;
        }
        if (this.containsUnsupportedPathFormat(objectPath)) {
            return null;
        }
        ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(objectPath);
        if (pathTuple == null) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "The object path cannot be null or empty.", "createAbsoluteCorpusPath");
            return null;
        }
        String nameSpace = (String)pathTuple.getLeft();
        String newObjectPath = (String)pathTuple.getRight();
        String prefix = "";
        String namespaceFromObj = "";
        if (obj instanceof CdmContainerDefinition) {
            prefix = ((CdmContainerDefinition)obj).getFolderPath();
            namespaceFromObj = ((CdmContainerDefinition)obj).getNamespace();
        } else if (obj != null) {
            prefix = obj.getInDocument().getFolderPath();
            namespaceFromObj = obj.getInDocument().getNamespace();
        }
        if (prefix != null && this.containsUnsupportedPathFormat(prefix)) {
            return null;
        }
        if (!Strings.isNullOrEmpty((String)prefix) && prefix.charAt(prefix.length() - 1) != '/') {
            Logger.warning(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("Expected path prefix to end in /, but it didn't. Appended the /, prefix: '{0}'", prefix), "createAbsoluteCorpusPath");
            prefix = prefix + "/";
        }
        if (!Strings.isNullOrEmpty((String)newObjectPath) && !newObjectPath.startsWith("/")) {
            if (obj == null) {
                prefix = "/";
            }
            if (!Strings.isNullOrEmpty((String)nameSpace) && !Objects.equals(nameSpace, namespaceFromObj)) {
                Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("The namespace '{0}' found on the path does not match the namespace found on the object", nameSpace), "createAbsoluteCorpusPath");
                return null;
            }
            newObjectPath = prefix + newObjectPath;
            finalNamespace = Strings.isNullOrEmpty((String)namespaceFromObj) ? (StringUtils.isNullOrTrimEmpty(nameSpace) ? this.defaultNamespace : nameSpace) : namespaceFromObj;
        } else {
            finalNamespace = Strings.isNullOrEmpty((String)nameSpace) ? (StringUtils.isNullOrTrimEmpty(namespaceFromObj) ? this.defaultNamespace : namespaceFromObj) : nameSpace;
        }
        return (!StringUtils.isNullOrTrimEmpty(finalNamespace) ? finalNamespace + ":" : "") + newObjectPath;
    }

    public String fetchConfig() {
        ArrayNode adaptersArray = JsonNodeFactory.instance.arrayNode();
        for (Map.Entry<String, StorageAdapter> namespaceAdapterTuple : this.namespaceAdapters.entrySet()) {
            if (this.systemDefinedNamespaces.contains(namespaceAdapterTuple.getKey()) || namespaceAdapterTuple.getValue() instanceof ResourceAdapter) continue;
            String config = namespaceAdapterTuple.getValue().fetchConfig();
            if (Strings.isNullOrEmpty((String)config)) {
                Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), "JSON config constructed by adapter is null or empty.", "fetchConfig");
                continue;
            }
            try {
                ObjectNode jsonConfig = (ObjectNode)JMapper.MAP.readTree(config);
                jsonConfig.put("namespace", namespaceAdapterTuple.getKey());
                adaptersArray.add((JsonNode)jsonConfig);
            }
            catch (IOException e) {
                Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("Config cannot be cast to objectNode. Config: {0}, Error: {1}", config, e.getMessage()), "fetchConfig");
            }
        }
        ObjectNode resultConfig = JsonNodeFactory.instance.objectNode();
        if (this.corpus.getAppId() != null) {
            resultConfig.put("appId", this.corpus.getAppId());
        }
        resultConfig.put("defaultNamespace", this.defaultNamespace);
        resultConfig.set("adapters", (JsonNode)adaptersArray);
        try {
            return JMapper.WRITER.writeValueAsString((Object)resultConfig);
        }
        catch (JsonProcessingException e) {
            throw new StorageAdapterException("Cannot generate adapters config", (Exception)((Object)e));
        }
    }

    public CompletableFuture<Void> saveAdapterConfigAsync(String name, StorageAdapter adapter) {
        return adapter.writeAsync(name, this.fetchConfig());
    }

    public String createRelativeCorpusPath(String objectPath) {
        return this.createRelativeCorpusPath(objectPath, null);
    }

    public String createRelativeCorpusPath(String objectPath, CdmContainerDefinition relativeTo) {
        String namespaceString;
        String newPath = this.createAbsoluteCorpusPath(objectPath, relativeTo);
        String string = namespaceString = relativeTo != null ? relativeTo.getNamespace() + ":" : "";
        if (!StringUtils.isNullOrTrimEmpty(namespaceString) && !StringUtils.isNullOrTrimEmpty(newPath) && newPath.startsWith(namespaceString)) {
            newPath = newPath.substring(namespaceString.length());
            if (relativeTo != null && newPath.startsWith(relativeTo.getFolderPath())) {
                newPath = newPath.substring(relativeTo.getFolderPath().length());
            }
        }
        return newPath;
    }

    public Integer getMaxConcurrentReads() {
        return this.corpus.getDocumentLibrary().concurrentReadLock.getPermits();
    }

    public void setMaxConcurrentReads(Integer maxConcurrentReads) {
        this.corpus.getDocumentLibrary().concurrentReadLock.setPermits(maxConcurrentReads);
    }

    private boolean containsUnsupportedPathFormat(String path) {
        if (path.startsWith("./") || path.startsWith(".\\")) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("The path should not start with ./, path: '{0}'", path), path);
            return true;
        }
        if (path.contains("../") || path.contains("..\\")) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("The path should not contain ../, path: '{0}'", path), path);
            return true;
        }
        if (path.contains("/./") || path.contains("\\.\\")) {
            Logger.error(StorageManager.class.getSimpleName(), this.corpus.getCtx(), Logger.format("The path should not contain /./, path: '{0}'", path), path);
            return true;
        }
        return false;
    }

    public Map<String, StorageAdapter> getNamespaceAdapters() {
        return this.namespaceAdapters;
    }

    public void setNamespaceAdapters(Map<String, StorageAdapter> namespaceAdapters) {
        this.namespaceAdapters = namespaceAdapters;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }
}

