/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmLocalEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapter;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StorageUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CdmDataPartitionPatternDefinition
extends CdmObjectDefinitionBase
implements CdmFileStatus {
    private String name;
    private String rootLocation;
    private String globPattern;
    private String regularExpression;
    private List<String> parameters;
    private String specializedSchema;
    private OffsetDateTime lastFileStatusCheckTime;
    private OffsetDateTime lastFileModifiedTime;
    private OffsetDateTime lastChildFileModifiedTime;

    public CdmDataPartitionPatternDefinition(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setObjectType(CdmObjectType.DataPartitionPatternDef);
        this.setName(name);
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrEmpty(this.getRootLocation())) {
            Logger.error(CdmDataPartitionPatternDefinition.class.getSimpleName(), this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), new ArrayList<String>(Arrays.asList("rootLocation"))));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmDataPartitionPatternDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmDataPartitionPatternDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmDataPartitionPatternDefinition(this.getCtx(), this.getName());
        } else {
            copy = (CdmDataPartitionPatternDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
        }
        copy.setRootLocation(this.getRootLocation());
        copy.setGlobPattern(this.getGlobPattern());
        copy.setRegularExpression(this.getRegularExpression());
        copy.setParameters(this.getParameters());
        copy.setLastFileStatusCheckTime(this.getLastFileStatusCheckTime());
        copy.setLastFileModifiedTime(this.getLastFileModifiedTime());
        if (this.getSpecializedSchema() != null) {
            copy.setSpecializedSchema(this.getSpecializedSchema());
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().blockDeclaredPathChanges && (path = this.getDeclaredPath()) == null) {
            String thisName = this.getName();
            if (thisName == null) {
                thisName = "UNNAMED";
            }
            path = pathFrom + thisName;
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        if (postChildren != null && postChildren.invoke(this, path)) {
            return false;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getRootLocation() {
        return this.rootLocation;
    }

    public void setRootLocation(String value) {
        this.rootLocation = value;
    }

    public String getGlobPattern() {
        return this.globPattern;
    }

    public void setGlobPattern(String value) {
        this.globPattern = value;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(String value) {
        this.regularExpression = value;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> value) {
        this.parameters = value;
    }

    public String getSpecializedSchema() {
        return this.specializedSchema;
    }

    public void setSpecializedSchema(String value) {
        this.specializedSchema = value;
    }

    @Override
    public OffsetDateTime getLastFileStatusCheckTime() {
        return this.lastFileStatusCheckTime;
    }

    @Override
    public void setLastFileStatusCheckTime(OffsetDateTime value) {
        this.lastFileStatusCheckTime = value;
    }

    @Override
    public OffsetDateTime getLastFileModifiedTime() {
        return this.lastFileModifiedTime;
    }

    @Override
    public void setLastFileModifiedTime(OffsetDateTime value) {
        this.lastFileModifiedTime = value;
    }

    @Override
    public OffsetDateTime getLastChildFileModifiedTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLastChildFileModifiedTime(OffsetDateTime time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> fileStatusCheckAsync() {
        return CompletableFuture.runAsync(() -> {
            String nameSpace = this.getInDocument().getNamespace();
            StorageAdapter adapter = this.getCtx().getCorpus().getStorage().fetchAdapter(nameSpace);
            if (adapter == null) {
                Logger.error(CdmDataPartitionPatternDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Adapter not found for the document '{0}'", this.getInDocument().getName()), "fileStatusCheckAsync");
                return;
            }
            String rootCleaned = this.getRootLocation();
            if (rootCleaned == null) {
                rootCleaned = "";
            }
            String rootCorpus = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(rootCleaned, this.getInDocument());
            List<String> fileInfoList = null;
            try {
                ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(rootCorpus);
                if (pathTuple == null) {
                    Logger.error(CdmDataPartitionPatternDefinition.class.getSimpleName(), this.getCtx(), "The root corpus path should not be null or empty.", "fileStatusCheckAsync");
                    return;
                }
                fileInfoList = adapter.fetchAllFilesAsync((String)pathTuple.getRight()).join();
            }
            catch (Exception e) {
                Logger.warning(CdmDataPartitionPatternDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Failed to fetch all files in the folder location '{0}' described by a partition pattern. Exception: '{1}'", rootCorpus, e.getMessage()), "fileStatusCheckAsync");
            }
            if (fileInfoList != null) {
                for (int i = 0; i < fileInfoList.size(); ++i) {
                    fileInfoList.set(i, nameSpace + ":" + fileInfoList.get(i));
                    fileInfoList.set(i, StringUtils.slice(fileInfoList.get(i), rootCorpus.length()));
                }
                if (this.getOwner() instanceof CdmLocalEntityDeclarationDefinition) {
                    if (!StringUtils.isNullOrTrimEmpty(this.getGlobPattern()) && !StringUtils.isNullOrTrimEmpty(this.getRegularExpression())) {
                        Logger.warning(CdmDataPartitionPatternDefinition.class.getSimpleName(), this.getCtx(), String.format("The Data Partition Pattern contains both a glob pattern (%s) and a regular expression (%s) set, the glob pattern will be used.", this.getGlobPattern(), this.getRegularExpression()));
                    }
                    String regularExpression = !StringUtils.isNullOrTrimEmpty(this.globPattern) ? this.globPatternToRegex(this.globPattern) : this.regularExpression;
                    Pattern regexPattern = null;
                    try {
                        regexPattern = Pattern.compile(regularExpression);
                    }
                    catch (PatternSyntaxException e) {
                        Logger.error(CdmDataPartitionPatternDefinition.class.getSimpleName(), this.getCtx(), String.format("The %s '%s' could not form a valid regular expression. Reason: %s", !StringUtils.isNullOrTrimEmpty(this.globPattern) ? "glob pattern" : "regular expression", !StringUtils.isNullOrTrimEmpty(this.globPattern) ? this.globPattern : this.regularExpression, e.getMessage()));
                    }
                    if (regexPattern != null) {
                        for (String fi : fileInfoList) {
                            Matcher m = regexPattern.matcher(fi);
                            if (!m.matches() || !m.group().equals(fi)) continue;
                            LinkedHashMap<String, List<String>> args = new LinkedHashMap<String, List<String>>();
                            for (int i = 0; i < m.groupCount(); ++i) {
                                if (this.getParameters() == null || i >= this.getParameters().size()) continue;
                                String currentParam = this.getParameters().get(i);
                                if (!args.containsKey(currentParam)) {
                                    args.put(currentParam, new ArrayList());
                                }
                                ((List)args.get(currentParam)).add(m.group(i + 1));
                            }
                            String locationCorpusPath = rootCleaned + fi;
                            String fullPath = rootCorpus + fi;
                            ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(fullPath);
                            if (pathTuple == null) {
                                Logger.error(CdmDataPartitionPatternDefinition.class.getSimpleName(), this.getCtx(), "The corpus path should not be null or empty.", "fileStatusCheckAsync");
                                return;
                            }
                            OffsetDateTime lastModifiedTime = adapter.computeLastModifiedTimeAsync((String)pathTuple.getRight()).join();
                            ((CdmLocalEntityDeclarationDefinition)this.getOwner()).createDataPartitionFromPattern(locationCorpusPath, this.getExhibitsTraits(), args, this.getSpecializedSchema(), lastModifiedTime);
                        }
                    }
                }
            }
            this.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
        });
    }

    @Override
    public CompletableFuture<Void> reportMostRecentTimeAsync(OffsetDateTime childTime) {
        if (this.getOwner() instanceof CdmFileStatus && childTime != null) {
            return ((CdmFileStatus)this.getOwner()).reportMostRecentTimeAsync(childTime);
        }
        return CompletableFuture.completedFuture(null);
    }

    private String globPatternToRegex(String pattern) {
        ArrayList<String> newPattern = new ArrayList<String>();
        block6: for (int i = 0; i < pattern.length(); ++i) {
            char currChar = pattern.charAt(i);
            switch (currChar) {
                case '.': {
                    newPattern.add("\\.");
                    continue block6;
                }
                case '\\': {
                    newPattern.add("/");
                    continue block6;
                }
                case '?': {
                    newPattern.add(".");
                    continue block6;
                }
                case '*': {
                    Character nextChar;
                    Character c = nextChar = i + 1 < pattern.length() ? Character.valueOf(pattern.charAt(i + 1)) : null;
                    if (nextChar != null && nextChar.equals(Character.valueOf('*'))) {
                        Character postChar;
                        Character prevChar = i - 1 >= 0 ? Character.valueOf(pattern.charAt(i - 1)) : null;
                        Character c2 = postChar = i + 2 < pattern.length() ? Character.valueOf(pattern.charAt(i + 2)) : null;
                        if (!(prevChar != null && prevChar.charValue() != '/' && prevChar.charValue() != '\\' || postChar != null && postChar.charValue() != '/' && postChar.charValue() != '\\')) {
                            newPattern.add(".*");
                            if (!(prevChar == null || postChar == null || prevChar.charValue() != '/' && prevChar.charValue() != '\\' || postChar.charValue() != '/' && postChar.charValue() != '\\')) {
                                newPattern.add("/?");
                                ++i;
                            }
                        } else {
                            newPattern.add("[^/\\\\]*");
                        }
                        ++i;
                        continue block6;
                    }
                    newPattern.add("[^/\\\\]*");
                    continue block6;
                }
                default: {
                    newPattern.add(Character.toString(currChar));
                }
            }
        }
        return String.join((CharSequence)"", newPattern);
    }
}

