/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContextReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeResolutionGuidance;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataTypeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CardinalitySettings;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmProjection;
import com.microsoft.commondatamodel.objectmodel.enums.CdmDataFormat;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.AttributeResolutionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntityReferenceSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionDirective;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;

public class CdmTypeAttributeDefinition
extends CdmAttribute {
    private CdmDataTypeReference dataType;
    private CdmAttributeContextReference attributeContext;
    private CdmProjection projection;
    private TraitToPropertyMap t2pm;

    public CdmTypeAttributeDefinition(CdmCorpusContext ctx, String name) {
        super(ctx, name);
        this.setObjectType(CdmObjectType.TypeAttributeDef);
        this.setAttributeCount(1);
    }

    public CdmAttributeContextReference getAttributeContext() {
        return this.attributeContext;
    }

    public void setAttributeContext(CdmAttributeContextReference value) {
        this.attributeContext = value;
    }

    public CdmProjection getProjection() {
        return this.projection;
    }

    public void setProjection(CdmProjection projection) {
        this.projection = projection;
    }

    public CdmDataFormat fetchDataFormat() {
        Object dataFormat = this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.DATA_FORMAT);
        return dataFormat != null ? CdmDataFormat.valueOf((String)dataFormat) : CdmDataFormat.Unknown;
    }

    public void updateDataFormat(CdmDataFormat value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.DATA_FORMAT, (Object)value);
    }

    public CdmDataTypeReference getDataType() {
        return this.dataType;
    }

    public void setDataType(CdmDataTypeReference value) {
        this.dataType = value;
    }

    public Object fetchDefaultValue() {
        return this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.DEFAULT);
    }

    public void updateDefaultValue(Object value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.DEFAULT, value);
    }

    public String fetchDescription() {
        Object description = this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.DESCRIPTION);
        return description != null ? (String)description : null;
    }

    public void updateDescription(String value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.DESCRIPTION, value);
    }

    public String fetchDisplayName() {
        return (String)this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.DISPLAY_NAME);
    }

    @Deprecated
    public void setDisplayName(String value) {
        this.updateDisplayName(value);
    }

    public void updateDisplayName(String value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.DISPLAY_NAME, value);
    }

    public Boolean fetchIsNullable() {
        Object nullable = this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.IS_NULLABLE);
        return nullable != null ? (Boolean)nullable : null;
    }

    public void updateIsNullable(Boolean value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.IS_NULLABLE, value);
    }

    public Boolean fetchIsPrimaryKey() {
        Object primaryKey = this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.IS_PRIMARY_KEY);
        return primaryKey != null ? (Boolean)primaryKey : null;
    }

    public Boolean fetchIsReadOnly() {
        Object readOnly = this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.IS_READ_ONLY);
        return readOnly != null ? (Boolean)readOnly : null;
    }

    public void updateIsReadOnly(Boolean value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.IS_READ_ONLY, value);
    }

    public Integer fetchMaximumLength() {
        Object maximumLength = this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.MAXIMUM_LENGTH);
        if (maximumLength instanceof String) {
            return Integer.parseInt((String)maximumLength);
        }
        return maximumLength != null ? (Integer)maximumLength : null;
    }

    public void updateMaximumLength(Integer value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.MAXIMUM_LENGTH, value);
    }

    public String fetchMaximumValue() {
        Object maximumValue = this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.MAXIMUM_VALUE);
        return maximumValue != null ? (String)maximumValue : null;
    }

    public void updateMaximumValue(String value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.MAXIMUM_VALUE, value);
    }

    public String fetchMinimumValue() {
        Object minimumValue = this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.MINIMUM_VALUE);
        return minimumValue != null ? (String)minimumValue : null;
    }

    public void updateMinimumValue(String value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.MINIMUM_VALUE, value);
    }

    public String fetchSourceName() {
        return (String)this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.SOURCE_NAME);
    }

    public void updateSourceName(String value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.SOURCE_NAME, value);
    }

    public Integer fetchSourceOrdering() {
        Object sourceOrdering = this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.SOURCE_ORDERING);
        try {
            return Integer.parseInt((String)sourceOrdering);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Deprecated
    public void updateSourceOrderingToTrait(Integer value) {
        this.updateSourceOrdering(value);
    }

    public void updateSourceOrdering(Integer value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.SOURCE_ORDERING, value);
    }

    public Boolean fetchValueConstrainedToList() {
        return (Boolean)this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.VALUE_CONSTRAINED_TO_LIST);
    }

    public void updateValueConstrainedToList(Boolean value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.VALUE_CONSTRAINED_TO_LIST, value);
    }

    @Deprecated
    public Object fetchProperty(CdmPropertyName propertyName) {
        return this.getTraitToPropertyMap().fetchPropertyValue(propertyName, true);
    }

    private TraitToPropertyMap getTraitToPropertyMap() {
        if (this.t2pm == null) {
            this.t2pm = new TraitToPropertyMap(this);
        }
        return this.t2pm;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges && Strings.isNullOrEmpty((String)(path = this.getDeclaredPath()))) {
            path = pathFrom + this.getName();
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getDataType() != null && this.getDataType().visit(path + "/dataType/", preChildren, postChildren)) {
            return true;
        }
        if (this.getAttributeContext() != null && this.getAttributeContext().visit(path + "/attributeContext/", preChildren, postChildren)) {
            return true;
        }
        if (this.getProjection() != null) {
            this.getProjection().setOwner(this);
        }
        if (this.getProjection() != null && this.getProjection().visit(path + "/projection/", preChildren, postChildren)) {
            return true;
        }
        if (this.visitAtt(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (StringUtils.isNullOrTrimEmpty(this.getName())) {
            missingFields.add("name");
        }
        if (this.getCardinality() != null) {
            if (StringUtils.isNullOrTrimEmpty(this.getCardinality().getMinimum())) {
                missingFields.add("cardinality.minimum");
            }
            if (StringUtils.isNullOrTrimEmpty(this.getCardinality().getMaximum())) {
                missingFields.add("cardinality.maximum");
            }
        }
        if (missingFields.size() > 0) {
            Logger.error(CdmTypeAttributeDefinition.class.getSimpleName(), this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), missingFields));
            return false;
        }
        if (this.getCardinality() != null) {
            if (!CardinalitySettings.isMinimumValid(this.getCardinality().getMinimum())) {
                Logger.error(CdmTypeAttributeDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Invalid minimum cardinality {0}", this.getCardinality().getMinimum()), "validate");
                return false;
            }
            if (!CardinalitySettings.isMaximumValid(this.getCardinality().getMaximum())) {
                Logger.error(CdmTypeAttributeDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Invalid maximum cardinality {0}", this.getCardinality().getMaximum()), "validate");
                return false;
            }
        }
        return true;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        ResolvedAttributeSetBuilder rasb = new ResolvedAttributeSetBuilder();
        rasb.getResolvedAttributeSet().setAttributeContext(under);
        ResolvedAttribute newAtt = new ResolvedAttribute(resOpt, this, this.getName(), under);
        rasb.ownOne(newAtt);
        ResolvedTraitSet rts = this.fetchResolvedTraits(resOpt);
        CdmAttributeResolutionGuidance resGuideWithDefault = this.getResolutionGuidance() != null ? (CdmAttributeResolutionGuidance)this.getResolutionGuidance().copy(resOpt) : new CdmAttributeResolutionGuidance(this.getCtx());
        resGuideWithDefault.setRenameFormat(null);
        resGuideWithDefault.updateAttributeDefaults(null, this);
        AttributeResolutionContext arc = new AttributeResolutionContext(resOpt, resGuideWithDefault, rts);
        rasb.applyTraits(arc);
        rasb.generateApplierAttributes(arc, false);
        resOpt.getSymbolRefSet().merge(arc.getResOpt().getSymbolRefSet());
        if (this.getProjection() != null) {
            ProjectionDirective projDirective = new ProjectionDirective(resOpt, this);
            ProjectionContext projCtx = this.getProjection().constructProjectionContext(projDirective, under, rasb.getResolvedAttributeSet());
            ResolvedAttributeSet ras = this.getProjection().extractResolvedAttributes(projCtx, under);
            rasb.setResolvedAttributeSet(ras);
        }
        return rasb;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        if (this.getDataType() != null) {
            rtsb.takeReference(this.dataType.fetchResolvedTraits(resOpt));
        }
        if (this.getPurpose() != null) {
            rtsb.mergeTraits(this.getPurpose().fetchResolvedTraits(resOpt));
        }
        this.addResolvedTraitsApplied(rtsb, resOpt);
        ResolvedTraitSet resolvedTraitSet = rtsb.getResolvedTraitSet();
        if (resolvedTraitSet != null && resolvedTraitSet.getHasElevated() != null && resolvedTraitSet.getHasElevated().booleanValue()) {
            CdmAttributeReference replacement = new CdmAttributeReference(this.getCtx(), this.getName(), true);
            replacement.setCtx(this.getCtx());
            replacement.setExplicitReference(this);
            replacement.setInDocument(this.getInDocument());
            replacement.setOwner(this);
            rtsb.replaceTraitParameterValue(resOpt, "does.elevateAttribute", "attribute", "this.attribute", replacement);
        }
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmTypeAttributeDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmTypeAttributeDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmTypeAttributeDefinition(this.getCtx(), this.getName());
        } else {
            copy = (CdmTypeAttributeDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
        }
        if (this.getDataType() != null) {
            copy.setDataType((CdmDataTypeReference)this.getDataType().copy(resOpt));
        }
        if (this.getAttributeContext() != null) {
            copy.setAttributeContext((CdmAttributeContextReference)this.getAttributeContext().copy(resOpt));
        }
        this.copyAtt(resOpt, copy);
        return copy;
    }

    @Override
    public ResolvedEntityReferenceSet fetchResolvedEntityReferences(ResolveOptions resOpt) {
        return null;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }
}

