/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmConstantEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.EntityReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.ConstantEntity;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.util.List;

public class ConstantEntityPersistence {
    public static CdmConstantEntityDefinition fromData(CdmCorpusContext ctx, JsonNode obj) {
        String constantEntityName = obj.get("constantEntityName") != null ? obj.get("constantEntityName").asText() : null;
        CdmConstantEntityDefinition constantEntity = (CdmConstantEntityDefinition)ctx.getCorpus().makeObject(CdmObjectType.ConstantEntityDef, constantEntityName);
        if (obj.get("explanation") != null) {
            constantEntity.setExplanation(obj.get("explanation").asText());
        }
        constantEntity.setConstantValues((List)JMapper.MAP.convertValue((Object)obj.get("constantValues"), (TypeReference)new TypeReference<List<List<String>>>(){}));
        constantEntity.setEntityShape(EntityReferencePersistence.fromData(ctx, obj.get("entityShape")));
        return constantEntity;
    }

    public static ConstantEntity toData(CdmConstantEntityDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        ConstantEntity constantEntity = new ConstantEntity();
        constantEntity.setExplanation(instance.getExplanation());
        constantEntity.setConstantEntityName(instance.getConstantEntityName());
        constantEntity.setEntityShape(Utils.jsonForm(instance.getEntityShape(), resOpt, options));
        constantEntity.setConstantValues(instance.getConstantValues());
        return constantEntity;
    }
}

