/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmLocalEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataPartitionPatternPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataPartitionPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DataPartition;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DataPartitionPattern;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.LocalEntityDeclaration;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.util.ArrayList;

public class LocalEntityDeclarationPersistence {
    public static CdmEntityDeclarationDefinition fromData(CdmCorpusContext ctx, String prefixPath, LocalEntityDeclaration obj) {
        CdmEntityDeclarationDefinition localDec = (CdmEntityDeclarationDefinition)ctx.getCorpus().makeObject(CdmObjectType.LocalEntityDeclarationDef, obj.getEntityName());
        localDec.setEntityPath(obj.getEntityPath());
        if (obj.getLastChildFileModifiedTime() != null) {
            localDec.setLastChildFileModifiedTime(obj.getLastChildFileModifiedTime());
        }
        if (obj.getLastFileModifiedTime() != null) {
            localDec.setLastFileModifiedTime(obj.getLastFileModifiedTime());
        }
        if (obj.getLastFileStatusCheckTime() != null) {
            localDec.setLastFileStatusCheckTime(obj.getLastFileStatusCheckTime());
        }
        if (obj.getExplanation() != null) {
            localDec.setExplanation(obj.getExplanation());
        }
        if (obj.getExhibitsTraits() != null) {
            Utils.addListToCdmCollection(localDec.getExhibitsTraits(), Utils.createTraitReferenceList(ctx, obj.getExhibitsTraits()));
        }
        if (obj.getDataPartitions() != null) {
            obj.getDataPartitions().forEach(dataPartition -> localDec.getDataPartitions().add(DataPartitionPersistence.fromData(ctx, dataPartition)));
        }
        if (obj.getDataPartitionPatterns() != null) {
            obj.getDataPartitionPatterns().forEach(pattern -> localDec.getDataPartitionPatterns().add(DataPartitionPatternPersistence.fromData(ctx, pattern)));
        }
        return localDec;
    }

    public static LocalEntityDeclaration toData(CdmLocalEntityDeclarationDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        LocalEntityDeclaration result = new LocalEntityDeclaration();
        result.setType("LocalEntity");
        result.setEntityName(instance.getEntityName());
        result.setExplanation(instance.getExplanation());
        result.setLastFileStatusCheckTime(instance.getLastFileStatusCheckTime());
        result.setLastFileModifiedTime(instance.getLastFileModifiedTime());
        result.setLastChildFileModifiedTime(instance.getLastChildFileModifiedTime());
        result.setEntityPath(instance.getEntityPath());
        result.setExhibitsTraits(Utils.listCopyDataAsArrayNode(instance.getExhibitsTraits(), resOpt, options));
        if (instance.getDataPartitions().getCount() > 0) {
            result.setDataPartitions(new ArrayList<DataPartition>());
            instance.getDataPartitions().forEach(partition -> result.getDataPartitions().add(DataPartitionPersistence.toData(partition, resOpt, options)));
        }
        if (instance.getDataPartitionPatterns().getCount() > 0) {
            result.setDataPartitionPatterns(new ArrayList<DataPartitionPattern>());
            instance.getDataPartitionPatterns().forEach(pattern -> result.getDataPartitionPatterns().add(DataPartitionPatternPersistence.toData(pattern, resOpt, options)));
        }
        return result;
    }
}

