/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.modeljson;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.TraitReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ArgumentPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ExtensionHelper;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.Annotation;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.CsvFormatSettings;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.MetadataObject;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.NameValuePair;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class Utils {
    private static final Map<String, String> annotationToTraitMap = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1863481726936L;
        {
            this.put("version", "is.CDM.entityVersion");
        }
    };
    public static final Set<String> ignoredTraits = new LinkedHashSet<String>(){
        private static final long serialVersionUID = 1987129612639L;
        {
            this.add("is.propertyContent.multiTrait");
            this.add("is.modelConversion.referenceModelMap");
            this.add("is.modelConversion.modelVersion");
            this.add("means.measurement.version");
            this.add("is.CDM.entityVersion");
            this.add("is.partition.format.CSV");
            this.add("is.partition.culture");
            this.add("is.managedBy");
            this.add("is.hidden");
        }
    };
    public static final Set<String> modelJsonPropertyTraits = new LinkedHashSet<String>(){
        private static final long serialVersionUID = 1560087956924063099L;
        {
            this.add("is.localized.describedAs");
        }
    };

    public static CompletableFuture<Void> processAnnotationsFromData(CdmCorpusContext ctx, MetadataObject obj, CdmTraitCollection traits) {
        return CompletableFuture.runAsync(() -> {
            ArrayList<NameValuePair> multiTraitAnnotations = new ArrayList<NameValuePair>();
            if (obj.getAnnotations() != null) {
                for (Annotation element : obj.getAnnotations()) {
                    if (!Utils.shouldAnnotationGoIntoASingleTrait(element.getName())) {
                        NameValuePair cdmElement = new NameValuePair();
                        cdmElement.setName(element.getName());
                        cdmElement.setValue(element.getValue());
                        multiTraitAnnotations.add(cdmElement);
                        continue;
                    }
                    CdmTraitReference innerTrait = (CdmTraitReference)ctx.getCorpus().makeObject(CdmObjectType.TraitRef, Utils.convertAnnotationToTrait(element.getName()), false);
                    innerTrait.getArguments().add(ArgumentPersistence.fromData(ctx, element).join());
                    traits.add(innerTrait);
                }
                if (multiTraitAnnotations.size() > 0) {
                    CdmTraitReference trait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.modelConversion.otherAnnotations", false);
                    trait.setFromProperty(false);
                    CdmArgumentDefinition annotationsArgument = new CdmArgumentDefinition(ctx, "annotations");
                    annotationsArgument.setValue(multiTraitAnnotations);
                    trait.getArguments().add(annotationsArgument);
                    traits.add(trait);
                }
            }
            if (obj.getTraits() != null) {
                for (JsonNode trait : obj.getTraits()) {
                    CdmTraitReference traitInstance = TraitReferencePersistence.fromData(ctx, JMapper.MAP.valueToTree((Object)trait));
                    traits.add(traitInstance);
                }
            }
        });
    }

    static void processTraitsAndAnnotationsToData(CdmCorpusContext ctx, MetadataObject obj, CdmTraitCollection traits) {
        if (traits == null) {
            return;
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        ArrayList<JsonNode> extensions = new ArrayList<JsonNode>();
        for (CdmTraitReference trait : traits) {
            if (ExtensionHelper.traitRefIsExtension(trait)) {
                ExtensionHelper.processExtensionTraitToObject(trait, obj);
                continue;
            }
            if ("is.modelConversion.otherAnnotations".equals(trait.getNamedReference())) {
                Object traitArgument = ((CdmArgumentDefinition)trait.getArguments().get(0)).getValue();
                ArrayList traitArguments = new ArrayList();
                if (traitArgument instanceof List) {
                    traitArguments = (ArrayList)traitArgument;
                } else if (traitArgument instanceof JsonNode && ((JsonNode)traitArgument).isArray()) {
                    traitArguments = (JsonNode)traitArgument;
                } else {
                    Logger.error(Utils.class.getSimpleName(), ctx, "Unsupported annotation type.");
                }
                for (Object annotation : traitArguments) {
                    if (annotation instanceof JsonNode) {
                        JsonNode jAnnotation = (JsonNode)annotation;
                        annotations.add((Annotation)JMapper.MAP.convertValue((Object)jAnnotation, Annotation.class));
                        continue;
                    }
                    if (annotation instanceof NameValuePair) {
                        Annotation element = new Annotation();
                        element.setName(((NameValuePair)annotation).getName());
                        element.setValue(((NameValuePair)annotation).getValue());
                        annotations.add(element);
                        continue;
                    }
                    Logger.warning(Utils.class.getSimpleName(), ctx, "Unsupported annotation type.");
                }
                continue;
            }
            if (ignoredTraits.contains(trait.getNamedReference()) || trait.getNamedReference().startsWith("is.dataFormat") || modelJsonPropertyTraits.contains(trait.getNamedReference()) && trait.isFromProperty()) continue;
            Object extension = TraitReferencePersistence.toData(trait, null, null);
            extensions.add(JMapper.MAP.valueToTree(extension));
        }
        if (!annotations.isEmpty()) {
            obj.setAnnotations(annotations);
        }
        if (!extensions.isEmpty()) {
            obj.setTraits(extensions);
        }
    }

    private static String traitToAnnotationName(String traitName) {
        return "is.CDM.entityVersion".equals(traitName) ? "version" : null;
    }

    static CdmTraitReference createCsvTrait(CsvFormatSettings obj, CdmCorpusContext ctx) {
        CdmTraitReference csvFormatTrait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.partition.format.CSV", true);
        csvFormatTrait.setSimpleNamedReference(false);
        if (obj.isColumnHeaders() != null) {
            CdmArgumentDefinition columnHeadersArg = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, "columnHeaders");
            columnHeadersArg.setValue(obj.isColumnHeaders() != false ? "true" : "false");
            csvFormatTrait.getArguments().add(columnHeadersArg);
        }
        if (obj.getCsvStyle() != null) {
            CdmArgumentDefinition csvStyleArg = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, "csvStyle");
            csvStyleArg.setValue(obj.getCsvStyle());
            csvFormatTrait.getArguments().add(csvStyleArg);
        }
        if (obj.getDelimiter() != null) {
            CdmArgumentDefinition delimiterArg = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, "delimiter");
            delimiterArg.setValue(obj.getDelimiter());
            csvFormatTrait.getArguments().add(delimiterArg);
        }
        if (obj.getQuoteStyle() != null) {
            CdmArgumentDefinition quoteStyleArg = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, "quoteStyle");
            quoteStyleArg.setValue(obj.getQuoteStyle());
            csvFormatTrait.getArguments().add(quoteStyleArg);
        }
        if (obj.getEncoding() != null) {
            CdmArgumentDefinition encodingArg = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, "encoding");
            encodingArg.setValue(obj.getEncoding());
            csvFormatTrait.getArguments().add(encodingArg);
        }
        return csvFormatTrait;
    }

    static CsvFormatSettings createCsvFormatSettings(CdmTraitReference cdmTraitRef) {
        CsvFormatSettings result = new CsvFormatSettings();
        for (CdmArgumentDefinition argument : cdmTraitRef.getArguments()) {
            switch (argument.getName()) {
                case "columnHeaders": {
                    result.setColumnHeaders("true".equals(argument.getValue()));
                    break;
                }
                case "csvStyle": {
                    result.setCsvStyle((String)argument.getValue());
                    break;
                }
                case "delimiter": {
                    result.setDelimiter((String)argument.getValue());
                    break;
                }
                case "quoteStyle": {
                    result.setQuoteStyle((String)argument.getValue());
                    break;
                }
                case "encoding": {
                    result.setEncoding((String)argument.getValue());
                }
            }
        }
        return result;
    }

    private static boolean shouldAnnotationGoIntoASingleTrait(String name) {
        return annotationToTraitMap.containsKey(name);
    }

    private static String convertAnnotationToTrait(String name) {
        return annotationToTraitMap.get(name);
    }

    public static <T> List<JsonNode> listCopyData(Iterable<T> source, ResolveOptions resOpt, CopyOptions options) {
        if (source == null) {
            return null;
        }
        ArrayList<JsonNode> casted = new ArrayList<JsonNode>();
        for (T element : source) {
            if (!(element instanceof CdmObject)) continue;
            Object serialized = ((CdmObject)element).copyData(resOpt, options);
            if (serialized instanceof JsonNode) {
                casted.add((JsonNode)serialized);
                continue;
            }
            casted.add(JMapper.MAP.valueToTree(serialized));
        }
        if (casted.size() == 0) {
            return null;
        }
        return casted;
    }
}

