/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities.logger;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.enums.CdmStatusLevel;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public class Logger {
    private static final org.slf4j.Logger defaultLogger = LoggerFactory.getLogger(Logger.class);

    public static void debug(String tag, CdmCorpusContext ctx, String message) {
        Logger.debug(tag, ctx, message, null);
    }

    public static void debug(String tag, CdmCorpusContext ctx, String message, String path) {
        Consumer<String> statusEvent = arg_0 -> ((org.slf4j.Logger)defaultLogger).debug(arg_0);
        Logger.log(CdmStatusLevel.Progress, ctx, tag, message, path, statusEvent);
    }

    public static void info(String tag, CdmCorpusContext ctx, String message) {
        Logger.info(tag, ctx, message, null);
    }

    public static void info(String tag, CdmCorpusContext ctx, String message, String path) {
        Consumer<String> statusEvent = arg_0 -> ((org.slf4j.Logger)defaultLogger).info(arg_0);
        Logger.log(CdmStatusLevel.Info, ctx, tag, message, path, statusEvent);
    }

    public static void warning(String tag, CdmCorpusContext ctx, String message) {
        Logger.warning(tag, ctx, message, null);
    }

    public static void warning(String tag, CdmCorpusContext ctx, String message, String path) {
        Consumer<String> statusEvent = arg_0 -> ((org.slf4j.Logger)defaultLogger).warn(arg_0);
        Logger.log(CdmStatusLevel.Warning, ctx, tag, message, path, statusEvent);
    }

    public static void error(String tag, CdmCorpusContext ctx, String message) {
        Logger.error(tag, ctx, message, null);
    }

    public static void error(String tag, CdmCorpusContext ctx, String message, String path) {
        Consumer<String> statusEvent = arg_0 -> ((org.slf4j.Logger)defaultLogger).error(arg_0);
        Logger.log(CdmStatusLevel.Error, ctx, tag, message, path, statusEvent);
    }

    private static String formatMessage(String tag, String message) {
        return Logger.formatMessage(tag, message, null);
    }

    private static String formatMessage(String tag, String message, String path) {
        return Logger.formatMessage(tag, message, path, null);
    }

    private static String formatMessage(String tag, String message, String path, String correlationId) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(tag).append(" | ").append(message);
        if (path != null) {
            strBuf.append(" | ").append(path);
        }
        if (correlationId != null) {
            strBuf.append(" | ").append(correlationId);
        }
        return strBuf.toString();
    }

    private static void log(CdmStatusLevel level, CdmCorpusContext ctx, String tag, String message, String path, Consumer<String> defaultStatusEvent) {
        if (level.compareTo(ctx.getReportAtLevel()) >= 0) {
            if (ctx.getEvents().isRecording()) {
                HashMap<String, String> theEvent = new HashMap<String, String>();
                theEvent.put("timestamp", TimeUtils.formatDateStringIfNotNull(OffsetDateTime.now(ZoneOffset.UTC)));
                theEvent.put("level", level.name());
                theEvent.put("tag", tag);
                theEvent.put("message", message);
                theEvent.put("path", path);
                if (ctx.getCorrelationId() != null) {
                    theEvent.put("correlationId", ctx.getCorrelationId());
                }
                ctx.getEvents().add((Map<String, String>)theEvent);
            }
            String formattedMessage = Logger.formatMessage(tag, message, path, ctx.getCorrelationId());
            if (ctx.getStatusEvent() != null) {
                ctx.getStatusEvent().apply(level, formattedMessage);
            } else {
                defaultStatusEvent.accept(message);
            }
        }
    }

    @Deprecated
    public static String format(String str, Object ... arguments) {
        if (str == null) {
            return null;
        }
        return MessageFormat.format(str.replace("'", "''"), arguments);
    }

    public static LoggerScope enterScope(String tag, CdmCorpusContext ctx, String path) {
        return new LoggerScope(new TState(tag, ctx, path));
    }

    public static class LoggerScope
    implements AutoCloseable {
        private final TState state;

        public LoggerScope(TState state) {
            this.state = state;
            state.ctx.getEvents().enable();
            Logger.debug(state.tag, state.ctx, "Entering scope", state.path);
        }

        @Override
        public void close() {
            Logger.debug(this.state.tag, this.state.ctx, "Leaving scope", this.state.path);
            this.state.ctx.getEvents().disable();
        }
    }

    private static class TState {
        public String tag;
        public CdmCorpusContext ctx;
        public String path;

        public TState(String tag, CdmCorpusContext ctx, String path) {
            this.tag = tag;
            this.ctx = ctx;
            this.path = path;
        }
    }
}

