/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmContainerDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDefinitionCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmE2ERelationship;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImportCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectSimple;
import com.microsoft.commondatamodel.objectmodel.cdm.ImportPriorities;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class CdmDocumentDefinition
extends CdmObjectSimple
implements CdmContainerDefinition {
    protected Map<String, CdmObjectBase> internalDeclarations;
    protected boolean isDirty = true;
    protected boolean isValid;
    protected boolean declarationsIndexed;
    private ImportPriorities importPriorities;
    private boolean needsIndexing;
    private CdmDefinitionCollection definitions;
    private CdmImportCollection imports;
    private CdmFolderDefinition folder;
    private String folderPath;
    private String namespace;
    private boolean importsIndexed;
    private boolean currentlyIndexing;
    private String name;
    private String schema;
    private String jsonSchemaSemanticVersion;
    private OffsetDateTime _fileSystemModifiedTime;

    public CdmDocumentDefinition() {
    }

    public CdmDocumentDefinition(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setInDocument(this);
        this.setObjectType(CdmObjectType.DocumentDef);
        this.name = name;
        this.jsonSchemaSemanticVersion = "1.0.0";
        this.needsIndexing = true;
        this.isDirty = true;
        this.importsIndexed = false;
        this.currentlyIndexing = false;
        this.isValid = true;
        this.clearCaches();
        this.imports = new CdmImportCollection(this.getCtx(), this);
        this.definitions = new CdmDefinitionCollection(this.getCtx(), this);
    }

    @Deprecated
    public boolean getNeedsIndexing() {
        return this.needsIndexing;
    }

    @Deprecated
    public void setNeedsIndexing(boolean value) {
        this.needsIndexing = value;
    }

    @Override
    @Deprecated
    public String getFolderPath() {
        return this.folderPath;
    }

    @Override
    @Deprecated
    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    @Override
    @Deprecated
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Deprecated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Deprecated
    boolean isImportsIndexed() {
        return this.importsIndexed;
    }

    @Deprecated
    void setImportsIndexed(boolean importsIndexed) {
        this.importsIndexed = importsIndexed;
    }

    @Deprecated
    boolean isCurrentlyIndexing() {
        return this.currentlyIndexing;
    }

    @Deprecated
    void setCurrentlyIndexing(boolean currentlyIndexing) {
        this.currentlyIndexing = currentlyIndexing;
    }

    public CdmDefinitionCollection getDefinitions() {
        return this.definitions;
    }

    @Deprecated
    public CdmFolderDefinition getFolder() {
        return this.folder;
    }

    @Deprecated
    public void setFolder(CdmFolderDefinition folder) {
        this.folder = folder;
    }

    public CdmImportCollection getImports() {
        return this.imports;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getJsonSchemaSemanticVersion() {
        return this.jsonSchemaSemanticVersion;
    }

    public void setJsonSchemaSemanticVersion(String jsonSchemaSemanticVersion) {
        this.jsonSchemaSemanticVersion = jsonSchemaSemanticVersion;
    }

    void clearCaches() {
        this.internalDeclarations = new LinkedHashMap<String, CdmObjectBase>();
        this.visit("", null, (iObject, path) -> {
            ((CdmObjectBase)iObject).setDeclaredPath(null);
            return false;
        });
    }

    boolean localizeCorpusPaths(CdmFolderDefinition newFolder) {
        AtomicBoolean allWentWell = new AtomicBoolean(true);
        boolean wasBlocking = this.getCtx().getCorpus().blockDeclaredPathChanges;
        this.getCtx().getCorpus().blockDeclaredPathChanges = true;
        Logger.info(CdmDocumentDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Localizing corpus paths in document '{0}'.", this.getName()), "localizeCorpusPaths");
        this.visit("", (iObject, path) -> {
            switch (iObject.getObjectType()) {
                case Import: {
                    CdmImport typeObj = (CdmImport)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getCorpusPath(), newFolder, allWentWell);
                    typeObj.setCorpusPath(localizeCorpusPath == null ? typeObj.getCorpusPath() : localizeCorpusPath);
                    break;
                }
                case LocalEntityDeclarationDef: 
                case ReferencedEntityDeclarationDef: {
                    CdmEntityDeclarationDefinition typeObj = (CdmEntityDeclarationDefinition)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getEntityPath(), newFolder, allWentWell);
                    typeObj.setEntityPath(localizeCorpusPath == null ? typeObj.getEntityPath() : localizeCorpusPath);
                    break;
                }
                case DataPartitionDef: {
                    CdmDataPartitionDefinition typeObj = (CdmDataPartitionDefinition)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getLocation(), newFolder, allWentWell);
                    typeObj.setLocation(localizeCorpusPath == null ? typeObj.getLocation() : localizeCorpusPath);
                    localizeCorpusPath = this.localizeCorpusPath(typeObj.getSpecializedSchema(), newFolder, allWentWell);
                    typeObj.setSpecializedSchema(localizeCorpusPath == null ? typeObj.getSpecializedSchema() : localizeCorpusPath);
                    break;
                }
                case DataPartitionPatternDef: {
                    CdmDataPartitionPatternDefinition typeObj = (CdmDataPartitionPatternDefinition)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getRootLocation(), newFolder, allWentWell);
                    typeObj.setRootLocation(localizeCorpusPath == null ? typeObj.getRootLocation() : localizeCorpusPath);
                    localizeCorpusPath = this.localizeCorpusPath(typeObj.getSpecializedSchema(), newFolder, allWentWell);
                    typeObj.setSpecializedSchema(localizeCorpusPath == null ? typeObj.getSpecializedSchema() : localizeCorpusPath);
                    break;
                }
                case E2ERelationshipDef: {
                    CdmE2ERelationship typeObj = (CdmE2ERelationship)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getToEntity(), newFolder, allWentWell);
                    typeObj.setToEntity(localizeCorpusPath == null ? typeObj.getToEntity() : localizeCorpusPath);
                    localizeCorpusPath = this.localizeCorpusPath(typeObj.getFromEntity(), newFolder, allWentWell);
                    typeObj.setFromEntity(localizeCorpusPath == null ? typeObj.getFromEntity() : localizeCorpusPath);
                    break;
                }
                case ManifestDeclarationDef: {
                    CdmManifestDeclarationDefinition typeObj = (CdmManifestDeclarationDefinition)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getDefinition(), newFolder, allWentWell);
                    typeObj.setDefinition(localizeCorpusPath == null ? typeObj.getDefinition() : localizeCorpusPath);
                    break;
                }
            }
            return false;
        }, null);
        this.getCtx().getCorpus().blockDeclaredPathChanges = wasBlocking;
        return allWentWell.get();
    }

    private String localizeCorpusPath(String corpusPath, CdmFolderDefinition newFolder, AtomicBoolean allWentWell) {
        String absPath;
        if (StringUtils.isNullOrTrimEmpty(corpusPath)) {
            return corpusPath;
        }
        CdmFolderDefinition oldFolder = (CdmFolderDefinition)this.getOwner();
        String newPath = oldFolder == null ? this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(corpusPath, newFolder) : (Objects.equals(absPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(corpusPath, oldFolder), corpusPath) ? absPath : this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(absPath, newFolder));
        if (newPath == null) {
            allWentWell.set(false);
        }
        return newPath;
    }

    public CompletableFuture<Boolean> refreshAsync() {
        return this.refreshAsync(new ResolveOptions(this));
    }

    public CompletableFuture<Boolean> refreshAsync(ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        this.needsIndexing = true;
        this.declarationsIndexed = false;
        this.importPriorities = null;
        this.importsIndexed = false;
        this.isValid = true;
        return this.indexIfNeededAsync(resOpt, true);
    }

    @Deprecated
    public CompletableFuture<Boolean> indexIfNeededAsync(ResolveOptions resOpt, boolean strictValidation) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.getNeedsIndexing() && !this.currentlyIndexing) {
                boolean finalStrictValidation;
                if (this.getFolder() == null) {
                    Logger.error(CdmDocumentDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Document '{0}' is not in a folder", this.name), "indexIfNeededAsync");
                    return false;
                }
                CdmCorpusDefinition corpus = this.getFolder().getCorpus();
                boolean bl = finalStrictValidation = resOpt.getStrictValidation() != null ? resOpt.getStrictValidation() : strictValidation;
                if (finalStrictValidation) {
                    corpus.resolveImportsAsync(this, resOpt).join();
                }
                corpus.getDocumentLibrary().markDocumentForIndexing(this);
                return corpus.indexDocuments(resOpt, finalStrictValidation);
            }
            return true;
        });
    }

    public CompletableFuture<Boolean> saveAsAsync(String newName) {
        return this.saveAsAsync(newName, false);
    }

    public CompletableFuture<Boolean> saveAsAsync(String newName, boolean saveReferenced) {
        return this.saveAsAsync(newName, saveReferenced, new CopyOptions());
    }

    public CompletableFuture<Boolean> saveAsAsync(String newName, boolean saveReferenced, CopyOptions options) {
        ResolveOptions resOpt;
        if (options == null) {
            options = new CopyOptions();
        }
        if (!this.indexIfNeededAsync(resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives()), false).join().booleanValue()) {
            Logger.error(CdmDocumentDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Failed to index document prior to save '{0}'", this.getName()), "saveAsAsync");
            return CompletableFuture.completedFuture(false);
        }
        if (newName.equals(this.getName())) {
            this.isDirty = false;
        }
        return this.getCtx().getCorpus().getPersistence().saveDocumentAsAsync(this, newName, saveReferenced, options);
    }

    CdmObject fetchObjectFromDocumentPath(String objectPath, ResolveOptions resOpt) {
        if (this.internalDeclarations.containsKey(objectPath)) {
            return this.internalDeclarations.get(objectPath);
        }
        int lastObj = objectPath.lastIndexOf("/(object)");
        String thisDocPart = objectPath;
        while (lastObj > 0) {
            thisDocPart = objectPath.substring(0, lastObj);
            if (this.internalDeclarations.containsKey(thisDocPart)) {
                CdmObjectReferenceBase thisDocObjRef = (CdmObjectReferenceBase)this.internalDeclarations.get(thisDocPart);
                CdmObjectDefinitionBase thatDocObjDef = (CdmObjectDefinitionBase)thisDocObjRef.fetchObjectDefinition(resOpt);
                if (thatDocObjDef != null) {
                    String thatDocPart = objectPath.substring(lastObj + "/(object)".length());
                    thatDocPart = thatDocObjDef.getDeclaredPath() + thatDocPart;
                    if (thatDocPart == objectPath) {
                        return null;
                    }
                    return thatDocObjDef.getInDocument().fetchObjectFromDocumentPath(thatDocPart, resOpt);
                }
                return null;
            }
            lastObj = thisDocPart.lastIndexOf("/(object)");
        }
        return null;
    }

    @Override
    public String getAtCorpusPath() {
        if (this.folder == null) {
            return "NULL:/" + this.name;
        }
        return this.folder.getAtCorpusPath() + this.name;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        if (preChildren != null && preChildren.invoke(this, pathFrom)) {
            return false;
        }
        if (this.getDefinitions() != null && this.getDefinitions().visitList(pathFrom, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, pathFrom);
    }

    @Override
    public <T extends CdmObjectDefinition> T fetchObjectDefinition(ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        return null;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.getName())) {
            Logger.error(CdmDocumentDefinition.class.getSimpleName(), this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), new ArrayList<String>(Arrays.asList("name"))));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmDocumentDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmDocumentDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmDocumentDefinition(this.getCtx(), this.getName());
        } else {
            copy = (CdmDocumentDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
            copy.getDefinitions().clear();
            copy.internalDeclarations = new LinkedHashMap<String, CdmObjectBase>();
            copy.needsIndexing = true;
            copy.getImports().clear();
            copy.importsIndexed = false;
            copy.importPriorities = null;
        }
        copy.setInDocument(copy);
        copy.setDirty(true);
        copy.setFolderPath(this.getFolderPath());
        copy.setSchema(this.getSchema());
        copy.setJsonSchemaSemanticVersion(this.getJsonSchemaSemanticVersion());
        for (CdmObjectDefinition definition : this.getDefinitions()) {
            copy.getDefinitions().add(definition);
        }
        for (CdmImport anImport : this.getImports()) {
            copy.getImports().add(anImport);
        }
        return copy;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
    }

    OffsetDateTime getFileSystemModifiedTime() {
        return this._fileSystemModifiedTime;
    }

    @Deprecated
    public void setFileSystemModifiedTime(OffsetDateTime _fileSystemModifiedTime) {
        this._fileSystemModifiedTime = _fileSystemModifiedTime;
    }

    private int prioritizeImports(LinkedHashSet<CdmDocumentDefinition> processedSet, ImportPriorities importPriorities, int sequence, boolean skipMonikered) {
        Map<CdmDocumentDefinition, Integer> priorityMap = importPriorities.getImportPriority();
        Map<String, CdmDocumentDefinition> monikerMap = importPriorities.getMonikerPriorityMap();
        if (processedSet.contains(this)) {
            if (priorityMap.containsKey(this) && priorityMap.get(this) == 0) {
                importPriorities.setHasCircularImport(true);
            }
            return sequence;
        }
        processedSet.add(this);
        if (this.getImports() != null) {
            boolean isMoniker;
            CdmDocumentDefinition impDoc;
            CdmImport imp;
            int i;
            int l = this.getImports().getCount();
            for (i = l - 1; i >= 0; --i) {
                imp = (CdmImport)this.getImports().get(i);
                impDoc = imp.getDocument();
                boolean bl = isMoniker = !StringUtils.isNullOrTrimEmpty(imp.getMoniker());
                if (imp.getDocument() == null || isMoniker || priorityMap.containsKey(impDoc)) continue;
                priorityMap.put(impDoc, sequence);
                ++sequence;
            }
            for (i = l - 1; i >= 0; --i) {
                imp = (CdmImport)this.getImports().get(i);
                impDoc = imp.getDocument();
                boolean bl = isMoniker = !StringUtils.isNullOrTrimEmpty(imp.getMoniker());
                if (impDoc != null && impDoc.importPriorities != null && !impDoc.importPriorities.getHasCircularImport()) {
                    ImportPriorities impPriSub = impDoc.getImportPriorities();
                    impPriSub.getImportPriority().remove(impDoc);
                    for (Map.Entry ip : impPriSub.getImportPriority().entrySet().stream().sorted(Comparator.comparing(entry -> ((CdmDocumentDefinition)entry.getKey()).getName())).collect(Collectors.toList())) {
                        if (priorityMap.containsKey(ip.getKey())) continue;
                        priorityMap.put((CdmDocumentDefinition)ip.getKey(), sequence);
                        ++sequence;
                    }
                    if (isMoniker) continue;
                    impPriSub.getMonikerPriorityMap().entrySet().forEach(mp -> monikerMap.put((String)mp.getKey(), (CdmDocumentDefinition)mp.getValue()));
                    continue;
                }
                if (impDoc == null) continue;
                sequence = impDoc.prioritizeImports(processedSet, importPriorities, sequence, isMoniker);
            }
            if (!skipMonikered) {
                for (i = 0; i < l; ++i) {
                    boolean isMoniker2;
                    imp = (CdmImport)this.getImports().get(i);
                    boolean bl = isMoniker2 = !StringUtils.isNullOrTrimEmpty(imp.getMoniker());
                    if (imp.getDocument() == null || !isMoniker2) continue;
                    monikerMap.put(imp.getMoniker(), imp.getDocument());
                }
            }
        }
        return sequence;
    }

    @Deprecated
    public CompletableFuture<Boolean> saveLinkedDocumentsAsync() {
        return this.saveLinkedDocumentsAsync(null);
    }

    @Deprecated
    public CompletableFuture<Boolean> saveLinkedDocumentsAsync(CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.getImports() != null) {
                Iterator iterator = this.getImports().iterator();
                while (iterator.hasNext()) {
                    CdmImport anImport;
                    CdmImport imp = anImport = (CdmImport)iterator.next();
                    CdmDocumentDefinition docImp = (CdmDocumentDefinition)this.getCtx().getCorpus().fetchObjectAsync(imp.getCorpusPath(), this).join();
                    if (docImp == null || !docImp.isDirty || docImp.saveAsAsync(docImp.getName(), true, options).join().booleanValue()) continue;
                    Logger.error(CdmDocumentDefinition.class.getSimpleName(), this.getCtx(), Logger.format("Failed to save import '{0}'", docImp.getName()), "saveLinkedDocumentsAsync");
                    return false;
                }
            }
            return true;
        });
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    ImportPriorities getImportPriorities() {
        if (this.importPriorities == null) {
            ImportPriorities importPriorities = new ImportPriorities();
            importPriorities.getImportPriority().put(this, 0);
            this.prioritizeImports(new LinkedHashSet<CdmDocumentDefinition>(), importPriorities, 1, false);
            this.importPriorities = importPriorities;
        }
        return this.importPriorities.copy();
    }

    void setImportPriorities(ImportPriorities importPriorities) {
        this.importPriorities = importPriorities;
    }

    @Deprecated
    public boolean isDirty() {
        return this.isDirty;
    }

    @Deprecated
    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    CompletableFuture<Void> reloadAsync() {
        return this.getCtx().getCorpus().fetchObjectAsync(this.getAtCorpusPath(), null, true).thenAccept(v -> {});
    }
}

