/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.PersistenceLayer;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.SymbolSet;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class CdmObjectBase
implements CdmObject {
    private int id;
    private CdmCorpusContext ctx;
    private CdmDocumentDefinition inDocument;
    private String atCorpusPath;
    private CdmObjectType objectType;
    private CdmObject owner;
    private boolean resolvingTraits = false;
    private String declaredPath;
    private Map<String, ResolvedTraitSetBuilder> traitCache;
    protected boolean resolvingAttributes = false;

    public CdmObjectBase() {
    }

    public CdmObjectBase(CdmCorpusContext ctx) {
        this.id = CdmCorpusDefinition.getNextId();
        this.ctx = ctx;
    }

    @Deprecated
    public static <T extends CdmObject> Object copyData(T instance, ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(instance, resOpt, options, CdmObject.class);
    }

    @Deprecated
    public static <T extends CdmObject> Object copyData(T instance, ResolveOptions resOpt, CopyOptions options, Class<T> classInterface) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(instance, instance.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (options == null) {
            options = new CopyOptions();
        }
        String persistenceTypeName = "CdmFolder";
        return PersistenceLayer.toData(instance, resOpt, options, "CdmFolder", classInterface);
    }

    static CdmTraitReference resolvedTraitToTraitRef(ResolveOptions resOpt, ResolvedTrait rt) {
        CdmTraitReference traitRef;
        if (rt.getParameterValues() != null && rt.getParameterValues().length() > 0) {
            traitRef = (CdmTraitReference)rt.getTrait().getCtx().getCorpus().makeObject(CdmObjectType.TraitRef, rt.getTraitName(), false);
            int l = rt.getParameterValues().length();
            if (l == 1) {
                Object val = rt.getParameterValues().fetchValue(0);
                if (val != null) {
                    traitRef.getArguments().add(null, val);
                }
            } else {
                for (int i = 0; i < l; ++i) {
                    CdmParameterDefinition param = rt.getParameterValues().fetchParameter(i);
                    Object val = rt.getParameterValues().getValues().get(i);
                    if (val == null) continue;
                    traitRef.getArguments().add(param.getName(), val);
                }
            }
        } else {
            traitRef = (CdmTraitReference)rt.getTrait().getCtx().getCorpus().makeObject(CdmObjectType.TraitRef, rt.getTraitName(), true);
        }
        if (resOpt.isSaveResolutionsOnCopy()) {
            traitRef.setExplicitReference(rt.getTrait());
            traitRef.setInDocument(rt.getTrait().getInDocument());
        }
        if (rt.getTrait().getAssociatedProperties() != null && !rt.getTrait().isDerivedFrom("is.dataFormat", resOpt)) {
            traitRef.setFromProperty(true);
        }
        return traitRef;
    }

    static ResolveOptions copyResolveOptions(ResolveOptions resOpt) {
        ResolveOptions resOptCopy = new ResolveOptions();
        resOptCopy.setWrtDoc(resOpt.getWrtDoc());
        resOptCopy.setRelationshipDepth(resOpt.getRelationshipDepth());
        if (null != resOpt.getDirectives()) {
            resOptCopy.setDirectives(resOpt.getDirectives().copy());
        }
        resOptCopy.setLocalizeReferencesFor(resOpt.getLocalizeReferencesFor());
        resOptCopy.setIndexingDoc(resOpt.getIndexingDoc());
        resOptCopy.setShallowValidation(resOpt.getShallowValidation());
        resOptCopy.setResolvedAttributeLimit(resOpt.getResolvedAttributeLimit());
        return resOptCopy;
    }

    @Deprecated
    public static boolean visitList(Iterable<?> items, String path, VisitCallback preChildren, VisitCallback postChildren) {
        boolean result = false;
        if (items != null) {
            for (Object element : items) {
                if (element == null || !((CdmObjectBase)element).visit(path, preChildren, postChildren)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    void clearTraitCache() {
        this.traitCache = null;
    }

    @Deprecated
    public String getDeclaredPath() {
        return this.declaredPath;
    }

    @Deprecated
    public void setDeclaredPath(String declaredPath) {
        this.declaredPath = declaredPath;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int value) {
        this.id = value;
    }

    @Override
    public CdmCorpusContext getCtx() {
        return this.ctx;
    }

    @Override
    public void setCtx(CdmCorpusContext value) {
        this.ctx = value;
    }

    @Override
    public CdmDocumentDefinition getInDocument() {
        return this.inDocument;
    }

    @Override
    public void setInDocument(CdmDocumentDefinition value) {
        this.inDocument = value;
    }

    @Override
    public String getAtCorpusPath() {
        if (this.getInDocument() == null) {
            return "NULL:/NULL/" + this.declaredPath;
        }
        return this.getInDocument().getAtCorpusPath() + "/" + this.declaredPath;
    }

    @Override
    public CdmObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(CdmObjectType value) {
        this.objectType = value;
    }

    @Override
    public CdmObject getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(CdmObject value) {
        this.owner = value;
    }

    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
    }

    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOptl) {
        return this.constructResolvedAttributes(resOptl, null);
    }

    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits(ResolveOptions resOpt) {
        boolean wasPreviouslyResolving = this.getCtx().getCorpus().isCurrentlyResolving;
        this.getCtx().getCorpus().isCurrentlyResolving = true;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        String kind = "rtsb";
        ResolveContext ctx = (ResolveContext)this.getCtx();
        String cacheTagA = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rtsb");
        ResolvedTraitSetBuilder rtsbAll = null;
        if (this.getTraitCache() == null) {
            this.setTraitCache(new LinkedHashMap<String, ResolvedTraitSetBuilder>());
        } else if (!StringUtils.isNullOrTrimEmpty(cacheTagA)) {
            rtsbAll = this.getTraitCache().get(cacheTagA);
        }
        SymbolSet currDocRefSet = resOpt.getSymbolRefSet();
        if (currDocRefSet == null) {
            currDocRefSet = new SymbolSet();
        }
        resOpt.setSymbolRefSet(new SymbolSet());
        if (rtsbAll == null) {
            CdmObjectDefinitionBase objDef;
            rtsbAll = new ResolvedTraitSetBuilder();
            if (!this.resolvingTraits) {
                this.resolvingTraits = true;
                this.constructResolvedTraits(rtsbAll, resOpt);
                this.resolvingTraits = false;
            }
            if ((objDef = (CdmObjectDefinitionBase)this.fetchObjectDefinition(resOpt)) != null) {
                ctx.getCorpus().registerDefinitionReferenceSymbols(objDef, "rtsb", resOpt.getSymbolRefSet());
                if (rtsbAll.getResolvedTraitSet() == null) {
                    rtsbAll.setResolvedTraitSet(new ResolvedTraitSet(resOpt));
                }
                if (!StringUtils.isNullOrTrimEmpty(cacheTagA = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rtsb"))) {
                    this.getTraitCache().put(cacheTagA, rtsbAll);
                }
            }
        } else {
            String key = CdmCorpusDefinition.createCacheKeyFromObject(this, "rtsb");
            SymbolSet tempDocRefSet = ctx.getCorpus().getDefinitionReferenceSymbols().get(key);
            resOpt.setSymbolRefSet(tempDocRefSet);
        }
        currDocRefSet.merge(resOpt.getSymbolRefSet());
        resOpt.setSymbolRefSet(currDocRefSet);
        this.getCtx().getCorpus().isCurrentlyResolving = wasPreviouslyResolving;
        return rtsbAll.getResolvedTraitSet();
    }

    @Override
    @Deprecated
    public ResolvedAttributeSet fetchResolvedAttributes(ResolveOptions resOpt) {
        return this.fetchResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSet fetchResolvedAttributes(ResolveOptions resOpt, AttributeContextParameters acpInContext) {
        boolean wasPreviouslyResolving = this.getCtx().getCorpus().isCurrentlyResolving;
        this.getCtx().getCorpus().isCurrentlyResolving = true;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        String kind = "rasb";
        ResolveContext ctx = (ResolveContext)this.getCtx();
        String cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rasb", acpInContext != null ? "ctx" : "");
        Object rasbCache = null;
        if (cacheTag != null) {
            rasbCache = ctx.getCache().get(cacheTag);
        }
        CdmAttributeContext underCtx = null;
        SymbolSet currDocRefSet = resOpt.getSymbolRefSet();
        if (currDocRefSet == null) {
            currDocRefSet = new SymbolSet();
        }
        resOpt.setSymbolRefSet(new SymbolSet());
        String fromMoniker = resOpt.getFromMoniker();
        resOpt.setFromMoniker(null);
        if (rasbCache == null) {
            if (this.resolvingAttributes) {
                this.getCtx().getCorpus().isCurrentlyResolving = wasPreviouslyResolving;
                return new ResolvedAttributeSet();
            }
            this.resolvingAttributes = true;
            if (acpInContext != null) {
                underCtx = CdmAttributeContext.createChildUnder(resOpt, acpInContext);
            }
            if ((rasbCache = this.constructResolvedAttributes(resOpt, underCtx)) != null) {
                this.resolvingAttributes = false;
                Object oDef = this.fetchObjectDefinition(resOpt);
                if (oDef != null) {
                    ctx.getCorpus().registerDefinitionReferenceSymbols((CdmObject)oDef, "rasb", resOpt.getSymbolRefSet());
                    cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rasb", acpInContext != null ? "ctx" : null);
                    if (!StringUtils.isNullOrTrimEmpty(cacheTag) && rasbCache != null) {
                        ctx.getCache().put(cacheTag, rasbCache);
                    }
                    if (!StringUtils.isNullOrTrimEmpty(fromMoniker) && acpInContext != null && this instanceof CdmObjectReference && ((CdmObjectReference)((Object)this)).getNamedReference() != null) {
                        CdmAttributeContext oldContext = (CdmAttributeContext)acpInContext.getUnder().getContents().get(acpInContext.getUnder().getContents().size() - 1);
                        acpInContext.getUnder().getContents().removeAt(acpInContext.getUnder().getContents().size() - 1);
                        underCtx = CdmAttributeContext.createChildUnder(resOpt, acpInContext);
                        CdmAttributeContext newContext = oldContext.copyAttributeContextTree(resOpt, underCtx, ((ResolvedAttributeSetBuilder)rasbCache).getResolvedAttributeSet(), null, fromMoniker);
                        String monikerPathAdded = fromMoniker + "/";
                        if (newContext.getDefinition() != null && newContext.getDefinition().getNamedReference() != null && newContext.getDefinition().getNamedReference().startsWith(monikerPathAdded)) {
                            newContext.getDefinition().setNamedReference(newContext.getDefinition().getNamedReference().substring(monikerPathAdded.length()));
                        }
                    }
                }
            }
        } else if (acpInContext != null) {
            underCtx = CdmAttributeContext.createChildUnder(resOpt, acpInContext);
            ((ResolvedAttributeSetBuilder)rasbCache).getResolvedAttributeSet().getAttributeContext().copyAttributeContextTree(resOpt, underCtx, ((ResolvedAttributeSetBuilder)rasbCache).getResolvedAttributeSet(), null, fromMoniker);
        }
        currDocRefSet.merge(resOpt.getSymbolRefSet());
        resOpt.setSymbolRefSet(currDocRefSet);
        if (rasbCache instanceof ResolvedAttributeSetBuilder) {
            this.getCtx().getCorpus().isCurrentlyResolving = wasPreviouslyResolving;
            return ((ResolvedAttributeSetBuilder)rasbCache).getResolvedAttributeSet();
        }
        this.getCtx().getCorpus().isCurrentlyResolving = wasPreviouslyResolving;
        return null;
    }

    @Deprecated
    public Map<String, ResolvedTraitSetBuilder> getTraitCache() {
        return this.traitCache;
    }

    @Deprecated
    public void setTraitCache(Map<String, ResolvedTraitSetBuilder> traitCache) {
        this.traitCache = traitCache;
    }
}

