/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class CdmReferencedEntityDeclarationDefinition
extends CdmObjectDefinitionBase
implements CdmEntityDeclarationDefinition {
    private String entityName;
    private String entitySchema;
    private OffsetDateTime lastFileStatusCheckTime;
    private OffsetDateTime lastFileModifiedTime;
    private OffsetDateTime lastChildFileModifiedTime;

    public CdmReferencedEntityDeclarationDefinition(CdmCorpusContext ctx, String entityName) {
        super(ctx);
        this.setObjectType(CdmObjectType.ReferencedEntityDeclarationDef);
        this.setEntityName(entityName);
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Override
    public String getEntityPath() {
        return this.entitySchema;
    }

    @Override
    public void setEntityPath(String value) {
        this.entitySchema = value;
    }

    @Override
    public OffsetDateTime getLastFileStatusCheckTime() {
        return this.lastFileStatusCheckTime;
    }

    @Override
    public void setLastFileStatusCheckTime(OffsetDateTime lastFileStatusCheckTime) {
        this.lastFileStatusCheckTime = lastFileStatusCheckTime;
    }

    @Override
    public OffsetDateTime getLastFileModifiedTime() {
        return this.lastFileModifiedTime;
    }

    @Override
    public void setLastFileModifiedTime(OffsetDateTime lastFileModifiedTime) {
        this.lastFileModifiedTime = lastFileModifiedTime;
    }

    @Override
    public OffsetDateTime getLastChildFileModifiedTime() {
        return this.lastChildFileModifiedTime;
    }

    @Override
    public void setLastChildFileModifiedTime(OffsetDateTime lastChildFileModifiedTime) {
        this.lastChildFileModifiedTime = lastChildFileModifiedTime;
    }

    @Override
    public String getName() {
        return this.getEntityName();
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathRoot, VisitCallback preChildren, VisitCallback postChildren) {
        return false;
    }

    @Override
    public CompletableFuture<Void> fileStatusCheckAsync() {
        return CompletableFuture.runAsync(() -> {
            String fullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getEntityPath(), this.getInDocument());
            OffsetDateTime modifiedTime = this.getCtx().getCorpus().computeLastModifiedTimeAsync(fullPath, this).join();
            this.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
            this.setLastFileModifiedTime(TimeUtils.maxTime(modifiedTime, this.getLastFileModifiedTime()));
            this.reportMostRecentTimeAsync(this.getLastFileModifiedTime()).join();
        });
    }

    @Override
    public CompletableFuture<Void> reportMostRecentTimeAsync(OffsetDateTime childTime) {
        if (this.getOwner() instanceof CdmFileStatus && childTime != null) {
            return ((CdmFileStatus)this.getOwner()).reportMostRecentTimeAsync(childTime);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (StringUtils.isNullOrTrimEmpty(this.getEntityName())) {
            missingFields.add("entityName");
        }
        if (StringUtils.isNullOrTrimEmpty(this.getEntityPath())) {
            missingFields.add("entityPath");
        }
        if (missingFields.size() > 0) {
            Logger.error(CdmReferencedEntityDeclarationDefinition.class.getSimpleName(), this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), missingFields));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmReferencedEntityDeclarationDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmReferencedEntityDeclarationDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmReferencedEntityDeclarationDefinition(this.getCtx(), this.getEntityName());
        } else {
            copy = (CdmReferencedEntityDeclarationDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setEntityName(this.getEntityName());
        }
        copy.setEntityPath(this.getEntityPath());
        copy.setLastFileStatusCheckTime(this.getLastFileStatusCheckTime());
        copy.setLastFileModifiedTime(this.getLastFileModifiedTime());
        return copy;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        this.constructResolvedTraitsDef(null, rtsb, resOpt);
    }

    @Override
    public CdmCollection<CdmDataPartitionDefinition> getDataPartitions() {
        return null;
    }

    @Override
    public CdmCollection<CdmDataPartitionPatternDefinition> getDataPartitionPatterns() {
        return null;
    }
}

