/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Deprecated
public class DocumentLibrary {
    List<Pair<CdmFolderDefinition, CdmDocumentDefinition>> allDocuments = new ArrayList<Pair<CdmFolderDefinition, CdmDocumentDefinition>>();
    Map<String, Pair<CdmFolderDefinition, CdmDocumentDefinition>> pathLookup = new LinkedHashMap<String, Pair<CdmFolderDefinition, CdmDocumentDefinition>>();
    Map<String, Short> docsNotLoaded = new LinkedHashMap<String, Short>();
    Map<String, Short> docsCurrentlyLoading = new LinkedHashMap<String, Short>();
    Map<CdmDocumentDefinition, Short> docsNotIndexed;
    Map<String, Short> docsNotFound = new LinkedHashMap<String, Short>();
    Lock documentLibraryLock;

    DocumentLibrary() {
        this.docsNotIndexed = new LinkedHashMap<CdmDocumentDefinition, Short>();
        this.documentLibraryLock = new ReentrantLock();
    }

    void addDocumentPath(String path, CdmFolderDefinition folder, CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        if (!this.pathLookup.containsKey(path)) {
            this.allDocuments.add((Pair<CdmFolderDefinition, CdmDocumentDefinition>)new ImmutablePair((Object)folder, (Object)doc));
            this.pathLookup.put(path, (Pair<CdmFolderDefinition, CdmDocumentDefinition>)new ImmutablePair((Object)folder, (Object)doc));
        }
        this.documentLibraryLock.unlock();
    }

    void removeDocumentPath(String path, CdmFolderDefinition folder, CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        if (this.pathLookup.containsKey(path)) {
            this.pathLookup.remove(path);
            int index = this.allDocuments.indexOf(ImmutablePair.of((Object)folder, (Object)doc));
            this.allDocuments.remove(index);
        }
        this.documentLibraryLock.unlock();
    }

    List<String> listDocsNotLoaded() {
        this.documentLibraryLock.lock();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Short> entry : this.docsNotLoaded.entrySet()) {
            list.add(entry.getKey());
        }
        this.documentLibraryLock.unlock();
        return list;
    }

    List<CdmDocumentDefinition> listDocsNotIndexed() {
        this.documentLibraryLock.lock();
        ArrayList<CdmDocumentDefinition> list = new ArrayList<CdmDocumentDefinition>();
        for (Map.Entry<CdmDocumentDefinition, Short> entry : this.docsNotIndexed.entrySet()) {
            CdmDocumentDefinition doc = entry.getKey();
            doc.setCurrentlyIndexing(true);
            list.add(doc);
        }
        this.documentLibraryLock.unlock();
        return list;
    }

    @Deprecated
    public List<CdmDocumentDefinition> listAllDocuments() {
        this.documentLibraryLock.lock();
        ArrayList<CdmDocumentDefinition> list = new ArrayList<CdmDocumentDefinition>();
        for (Pair<CdmFolderDefinition, CdmDocumentDefinition> pair : this.allDocuments) {
            list.add((CdmDocumentDefinition)pair.getRight());
        }
        this.documentLibraryLock.unlock();
        return list;
    }

    void addToDocsNotLoaded(String path) {
        Pair<CdmFolderDefinition, CdmDocumentDefinition> lookup;
        this.documentLibraryLock.lock();
        if (!this.docsNotFound.containsKey(path) && (lookup = this.pathLookup.get(path.toLowerCase())) == null) {
            this.docsNotLoaded.put(path, (short)1);
        }
        this.documentLibraryLock.unlock();
    }

    CdmDocumentDefinition fetchDocumentAndMarkForIndexing(String path) {
        Pair<CdmFolderDefinition, CdmDocumentDefinition> lookup;
        this.documentLibraryLock.lock();
        CdmDocumentDefinition doc = null;
        if (!this.docsNotFound.containsKey(path) && (lookup = this.pathLookup.get(path.toLowerCase())) != null) {
            if (!((CdmDocumentDefinition)lookup.getRight()).isImportsIndexed() && !((CdmDocumentDefinition)lookup.getRight()).isCurrentlyIndexing()) {
                ((CdmDocumentDefinition)lookup.getRight()).setCurrentlyIndexing(true);
                this.docsNotIndexed.put((CdmDocumentDefinition)lookup.getRight(), (short)1);
            }
            doc = (CdmDocumentDefinition)lookup.getRight();
        }
        this.documentLibraryLock.unlock();
        return doc;
    }

    boolean needToLoadDocument(String docName) {
        this.documentLibraryLock.lock();
        boolean needToLoad = false;
        if (this.docsNotLoaded.containsKey(docName) && !this.docsNotFound.containsKey(docName) && !this.docsCurrentlyLoading.containsKey(docName)) {
            this.docsNotLoaded.remove(docName);
            this.docsCurrentlyLoading.put(docName, (short)1);
            needToLoad = true;
        }
        this.documentLibraryLock.unlock();
        return needToLoad;
    }

    boolean markDocumentAsLoadedOrFailed(CdmDocumentDefinition doc, String docName, Map<CdmDocumentDefinition, Short> docsNowLoaded) {
        this.documentLibraryLock.lock();
        boolean hasLoaded = false;
        this.docsCurrentlyLoading.remove(docName);
        if (doc != null) {
            docsNowLoaded.put(doc, (short)1);
            this.docsNotIndexed.put(doc, (short)1);
            doc.setCurrentlyIndexing(true);
            hasLoaded = true;
        } else {
            this.docsNotFound.put(docName, (short)1);
        }
        this.documentLibraryLock.unlock();
        return hasLoaded;
    }

    void markDocumentAsIndexed(CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        this.docsNotIndexed.remove(doc);
        this.documentLibraryLock.unlock();
    }

    void markDocumentForIndexing(CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        this.docsNotIndexed.put(doc, (short)1);
        this.documentLibraryLock.unlock();
    }

    @Deprecated
    public boolean contains(Pair<CdmFolderDefinition, CdmDocumentDefinition> fd) {
        return this.allDocuments.contains(fd);
    }
}

