/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionResolutionCommonUtil;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CdmOperationExcludeAttributes
extends CdmOperationBase {
    private String TAG = CdmOperationExcludeAttributes.class.getSimpleName();
    private List<String> excludeAttributes;

    public CdmOperationExcludeAttributes(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.OperationExcludeAttributesDef);
        this.setType(CdmOperationType.ExcludeAttributes);
        this.excludeAttributes = new ArrayList<String>();
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        Logger.error(this.TAG, this.getCtx(), "Projection operation not implemented yet.", "copy");
        return new CdmOperationExcludeAttributes(this.getCtx());
    }

    public List<String> getExcludeAttributes() {
        return this.excludeAttributes;
    }

    public void setExcludeAttributes(List<String> excludeAttributes) {
        this.excludeAttributes = excludeAttributes;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmOperationExcludeAttributes.class);
    }

    @Override
    public String getName() {
        return "operationExcludeAttributes";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.OperationExcludeAttributesDef;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        Logger.error(this.TAG, this.getCtx(), "Projection operation not implemented yet.", "isDerivedFrom");
        return false;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.excludeAttributes == null) {
            missingFields.add("excludeAttributes");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.TAG, this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), missingFields));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().getBlockDeclaredPathChanges() && StringUtils.isNullOrEmpty(path = this.getDeclaredPath())) {
            path = pathFrom + "operationExcludeAttributes";
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ProjectionAttributeStateSet appendProjectionAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet, CdmAttributeContext attrCtx) {
        AttributeContextParameters attrCtxOpExcludeAttrsParam = new AttributeContextParameters();
        attrCtxOpExcludeAttrsParam.setUnder(attrCtx);
        attrCtxOpExcludeAttrsParam.setType(CdmAttributeContextType.OperationExcludeAttributes);
        attrCtxOpExcludeAttrsParam.setName("operation/index" + this.getIndex() + "/operationExcludeAttributes");
        CdmAttributeContext attrCtxOpExcludeAttrs = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxOpExcludeAttrsParam);
        Map<String, String> topLevelExcludeAttributeNames = ProjectionResolutionCommonUtil.getTopList(projCtx, this.excludeAttributes);
        for (ProjectionAttributeState currentPAS : projCtx.getCurrentAttributeStateSet().getValues()) {
            if (!topLevelExcludeAttributeNames.containsKey(currentPAS.getCurrentResolvedAttribute().getResolvedName())) {
                AttributeContextParameters attrCtxAddedAttrParam = new AttributeContextParameters();
                attrCtxAddedAttrParam.setUnder(attrCtx);
                attrCtxAddedAttrParam.setType(CdmAttributeContextType.AttributeDefinition);
                attrCtxAddedAttrParam.setName(currentPAS.getCurrentResolvedAttribute().getResolvedName());
                CdmAttributeContext attrCtxAddedAttr = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxAddedAttrParam);
                ProjectionAttributeState newPAS = new ProjectionAttributeState(projOutputSet.getCtx());
                newPAS.setCurrentResolvedAttribute(currentPAS.getCurrentResolvedAttribute());
                newPAS.setPreviousStateList(new ArrayList<ProjectionAttributeState>(Arrays.asList(currentPAS)));
                projOutputSet.add(newPAS);
                continue;
            }
            String excludeAttributeName = topLevelExcludeAttributeNames.get(currentPAS.getCurrentResolvedAttribute().getResolvedName());
            AttributeContextParameters attrCtxExcludedAttrParam = new AttributeContextParameters();
            attrCtxExcludedAttrParam.setUnder(attrCtxOpExcludeAttrs);
            attrCtxExcludedAttrParam.setType(CdmAttributeContextType.AttributeDefinition);
            attrCtxExcludedAttrParam.setName(excludeAttributeName);
            CdmAttributeContext cdmAttributeContext = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxExcludedAttrParam);
        }
        return projOutputSet;
    }
}

