/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionResolutionCommonUtil;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CdmOperationReplaceAsForeignKey
extends CdmOperationBase {
    private static String TAG = CdmOperationReplaceAsForeignKey.class.getSimpleName();
    private String reference;
    private CdmTypeAttributeDefinition replaceWith;

    public CdmOperationReplaceAsForeignKey(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.OperationReplaceAsForeignKeyDef);
        this.setType(CdmOperationType.ReplaceAsForeignKey);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        Logger.error(TAG, this.getCtx(), "Projection operation not implemented yet.", "copy");
        return new CdmOperationReplaceAsForeignKey(this.getCtx());
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public CdmTypeAttributeDefinition getReplaceWith() {
        return this.replaceWith;
    }

    public void setReplaceWith(CdmTypeAttributeDefinition replaceWith) {
        this.replaceWith = replaceWith;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmOperationReplaceAsForeignKey.class);
    }

    @Override
    public String getName() {
        return "operationReplaceAsForeignKey";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.OperationReplaceAsForeignKeyDef;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        Logger.error(TAG, this.getCtx(), "Projection operation not implemented yet.", "isDerivedFrom");
        return false;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (StringUtils.isNullOrTrimEmpty(this.reference)) {
            missingFields.add("reference");
        }
        if (this.replaceWith == null) {
            missingFields.add("replaceWith");
        }
        if (missingFields.size() > 0) {
            Logger.error(TAG, this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), missingFields));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().getBlockDeclaredPathChanges() && StringUtils.isNullOrTrimEmpty(path = this.getDeclaredPath())) {
            path = pathFrom + "operationReplaceAsForeignKey";
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.replaceWith != null && this.replaceWith.visit(pathFrom + "foreignKeyAttribute/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ProjectionAttributeStateSet appendProjectionAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet, CdmAttributeContext attrCtx) {
        AttributeContextParameters attrCtxOpFKParam = new AttributeContextParameters();
        attrCtxOpFKParam.setUnder(attrCtx);
        attrCtxOpFKParam.setType(CdmAttributeContextType.OperationReplaceAsForeignKey);
        attrCtxOpFKParam.setName("operation/index" + this.getIndex() + "/operationReplaceAsForeignKey");
        CdmAttributeContext attrCtxOpFK = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxOpFKParam);
        AttributeContextParameters attrCtxFKParam = new AttributeContextParameters();
        attrCtxFKParam.setUnder(attrCtxOpFK);
        attrCtxFKParam.setType(CdmAttributeContextType.AddedAttributeIdentity);
        attrCtxFKParam.setName("_foreignKey");
        CdmAttributeContext attrCtxFK = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxFKParam);
        CdmTypeAttributeDefinition subFK = this.replaceWith;
        ArrayList<String> addTrait = new ArrayList<String>(Arrays.asList("is.linkedEntity.identifier"));
        ResolvedAttribute resAttrNewFK = CdmOperationReplaceAsForeignKey.createNewResolvedAttribute(projCtx, attrCtxFK, subFK, null, addTrait);
        ProjectionAttributeStateSet outputFromOpPasSet = CdmOperationReplaceAsForeignKey.createNewProjectionAttributeStateSet(projCtx, projOutputSet, resAttrNewFK, this.reference);
        return outputFromOpPasSet;
    }

    private static ProjectionAttributeStateSet createNewProjectionAttributeStateSet(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet, ResolvedAttribute newResAttrFK, String refAttrName) {
        List<ProjectionAttributeState> pasList = ProjectionResolutionCommonUtil.getLeafList(projCtx, refAttrName);
        if (pasList != null) {
            ResolvedTrait reqdTrait = newResAttrFK.fetchResolvedTraits().find(projCtx.getProjectionDirective().getResOpt(), "is.linkedEntity.identifier");
            if (reqdTrait != null) {
                CdmEntityReference traitParamEntRef = ProjectionResolutionCommonUtil.createForeignKeyLinkedEntityIdentifierTraitParameter(projCtx.getProjectionDirective(), projOutputSet.getCtx().getCorpus(), pasList);
                reqdTrait.getParameterValues().setParameterValue(projCtx.getProjectionDirective().getResOpt(), "entityReferences", traitParamEntRef);
            }
            ProjectionAttributeState newProjAttrStateFK = new ProjectionAttributeState(projOutputSet.getCtx());
            newProjAttrStateFK.setCurrentResolvedAttribute(newResAttrFK);
            newProjAttrStateFK.setPreviousStateList(pasList);
            projOutputSet.add(newProjAttrStateFK);
        } else {
            Logger.error(TAG, projOutputSet.getCtx(), Logger.format("Unable to locate state for reference attribute \"{0}\".", refAttrName), "createNewProjectionAttributeStateSet");
        }
        return projOutputSet;
    }
}

