/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationCollection;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.expressionparser.ExpressionTree;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.expressionparser.InputValues;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.expressionparser.Node;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ConditionExpression;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionDirective;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionResolutionCommonUtil;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.Errors;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CdmProjection
extends CdmObjectDefinitionBase {
    private String TAG = CdmProjection.class.getSimpleName();
    private String condition;
    private Node conditionExpressionTreeRoot;
    private CdmOperationCollection operations;
    private CdmEntityReference source;

    public CdmProjection(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.ProjectionDef);
        this.operations = new CdmOperationCollection(ctx, this);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Deprecated
    public Node getConditionExpressionTreeRoot() {
        return this.conditionExpressionTreeRoot;
    }

    @Deprecated
    public void setConditionExpressionTreeRoot(Node conditionExpressionTreeRoot) {
        this.conditionExpressionTreeRoot = conditionExpressionTreeRoot;
    }

    public CdmOperationCollection getOperations() {
        return this.operations;
    }

    public CdmEntityReference getSource() {
        return this.source;
    }

    public void setSource(CdmEntityReference source) {
        this.source = source;
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        Logger.error(this.TAG, this.getCtx(), "Projection operation not implemented yet.", "copy");
        return new CdmProjection(this.getCtx());
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmProjection.class);
    }

    @Override
    public String getName() {
        return "projection";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.ProjectionDef;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.source == null) {
            missingFields.add("source");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.TAG, this.getCtx(), Errors.validateErrorString(this.getAtCorpusPath(), missingFields));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().getBlockDeclaredPathChanges() && StringUtils.isNullOrTrimEmpty(path = this.getDeclaredPath())) {
            path = pathFrom + "projection";
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.source != null && this.source.visit(path + "/source/", preChildren, postChildren)) {
            return true;
        }
        boolean result = false;
        if (this.operations != null && this.operations.size() > 0) {
            for (int opIndex = 0; opIndex < this.operations.size(); ++opIndex) {
                ((CdmOperationBase)this.operations.get(opIndex)).setIndex(opIndex + 1);
                result = this.operations.getAllItems().get(opIndex) != null && ((CdmOperationBase)this.operations.getAllItems().get(opIndex)).visit(path + "/operation/index" + (opIndex + 1) + "/", preChildren, postChildren);
            }
            if (result) {
                return true;
            }
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits() {
        return this.source.fetchResolvedTraits(null);
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits(ResolveOptions resOpt) {
        return this.source.fetchResolvedTraits(resOpt);
    }

    @Deprecated
    public ProjectionContext constructProjectionContext(ProjectionDirective projDirective, CdmAttributeContext attrCtx) {
        ProjectionContext projContext = null;
        if (StringUtils.isNullOrTrimEmpty(this.condition)) {
            this.condition = ConditionExpression.getDefaultConditionExpression(this.operations, this.getOwner());
        }
        ExpressionTree tree = new ExpressionTree();
        this.conditionExpressionTreeRoot = tree.constructExpressionTree(this.condition);
        if (this.conditionExpressionTreeRoot == null) {
            Logger.info(this.TAG, this.getCtx(), "Optional expression missing. Implicit expression will automatically apply.", "constructProjectionContext");
        }
        if (attrCtx != null) {
            AttributeContextParameters acpProj = new AttributeContextParameters();
            acpProj.setUnder(attrCtx);
            acpProj.setType(CdmAttributeContextType.Projection);
            acpProj.setName(this.fetchObjectDefinitionName());
            acpProj.setRegarding(projDirective.getOwnerRef());
            acpProj.setIncludeTraits(false);
            CdmAttributeContext acProj = CdmAttributeContext.createChildUnder(projDirective.getResOpt(), acpProj);
            AttributeContextParameters acpSource = new AttributeContextParameters();
            acpSource.setUnder(acProj);
            acpSource.setType(CdmAttributeContextType.Source);
            acpSource.setName("source");
            acpSource.setRegarding(null);
            acpSource.setIncludeTraits(false);
            CdmAttributeContext acSource = CdmAttributeContext.createChildUnder(projDirective.getResOpt(), acpSource);
            if (this.source.fetchObjectDefinition(projDirective.getResOpt()).getObjectType() == CdmObjectType.ProjectionDef) {
                projContext = ((CdmProjection)this.source.getExplicitReference()).constructProjectionContext(projDirective, acSource);
            } else {
                AttributeContextParameters acpSourceProjection = new AttributeContextParameters();
                acpSourceProjection.setUnder(acSource);
                acpSourceProjection.setType(CdmAttributeContextType.Entity);
                acpSourceProjection.setName(this.source.getNamedReference() != null ? this.source.getNamedReference() : this.source.getExplicitReference().getName());
                acpSourceProjection.setRegarding(this.source);
                acpSourceProjection.setIncludeTraits(false);
                ResolvedAttributeSet ras = this.source.fetchResolvedAttributes(projDirective.getResOpt(), acpSourceProjection);
                CdmCorpusContext ctx = projDirective.getOwner() != null ? projDirective.getOwner().getCtx() : null;
                ProjectionAttributeStateSet pasSet = null;
                Map<String, List<ProjectionAttributeState>> polySourceSet = null;
                if (projDirective.getIsSourcePolymorphic()) {
                    polySourceSet = ProjectionResolutionCommonUtil.getPolymorphicSourceSet(projDirective, ctx, this.source, acpSourceProjection);
                }
                pasSet = ProjectionResolutionCommonUtil.initializeProjectionAttributeStateSet(projDirective, ctx, ras, projDirective.getIsSourcePolymorphic(), polySourceSet);
                projContext = new ProjectionContext(projDirective, ras.getAttributeContext());
                projContext.setCurrentAttributeStateSet(pasSet);
            }
            boolean isConditionValid = false;
            if (this.conditionExpressionTreeRoot != null) {
                InputValues input = new InputValues();
                input.setNoMaxDepth(projDirective.getHasNoMaximumDepth());
                input.setIsArray(projDirective.getIsArray());
                input.setReferenceOnly(projDirective.getIsReferenceOnly());
                input.setNormalized(projDirective.getIsNormalized());
                input.setStructured(projDirective.getIsStructured());
                int currentDepth = projDirective.getCurrentDepth();
                input.setNextDepth(++currentDepth);
                projDirective.setCurrentDepth(currentDepth);
                input.setMaxDepth(projDirective.getMaximumDepth());
                input.setMinCardinality(projDirective.getCardinality() != null ? Integer.valueOf(projDirective.getCardinality().getMinimumNumber()) : null);
                input.setMaxCardinality(projDirective.getCardinality() != null ? Integer.valueOf(projDirective.getCardinality().getMaximumNumber()) : null);
                isConditionValid = (Boolean)ExpressionTree.evaluateExpressionTree(this.conditionExpressionTreeRoot, input);
            }
            if (isConditionValid && this.operations != null && this.operations.size() > 0) {
                for (int i = 0; i < this.operations.size(); ++i) {
                    ((CdmOperationBase)this.operations.get(i)).setIndex(i + 1);
                }
                AttributeContextParameters acpGenAttrSet = new AttributeContextParameters();
                acpGenAttrSet.setUnder(attrCtx);
                acpGenAttrSet.setType(CdmAttributeContextType.GeneratedSet);
                acpGenAttrSet.setName("_generatedAttributeSet");
                CdmAttributeContext acGenAttrSet = CdmAttributeContext.createChildUnder(projDirective.getResOpt(), acpGenAttrSet);
                AttributeContextParameters acpGenAttrRound0 = new AttributeContextParameters();
                acpGenAttrRound0.setUnder(acGenAttrSet);
                acpGenAttrRound0.setType(CdmAttributeContextType.GeneratedRound);
                acpGenAttrRound0.setName("_generatedAttributeRound0");
                CdmAttributeContext acGenAttrRound0 = CdmAttributeContext.createChildUnder(projDirective.getResOpt(), acpGenAttrRound0);
                ProjectionAttributeStateSet pasOperations = new ProjectionAttributeStateSet(projContext.getCurrentAttributeStateSet().getCtx());
                for (CdmOperationBase operation : this.operations) {
                    ProjectionAttributeStateSet newPasOperations = operation.appendProjectionAttributeState(projContext, pasOperations, acGenAttrRound0);
                    if (newPasOperations == null) continue;
                    pasOperations = newPasOperations;
                }
                projContext.setCurrentAttributeStateSet(pasOperations);
            }
        }
        return projContext;
    }

    @Deprecated
    public ResolvedAttributeSet extractResolvedAttributes(ProjectionContext projCtx) {
        ResolvedAttributeSet resolvedAttributeSet = new ResolvedAttributeSet();
        resolvedAttributeSet.setAttributeContext(projCtx.getCurrentAttributeContext());
        for (ProjectionAttributeState pas : projCtx.getCurrentAttributeStateSet().getValues()) {
            resolvedAttributeSet.merge(pas.getCurrentResolvedAttribute(), pas.getCurrentResolvedAttribute().getAttCtx());
        }
        return resolvedAttributeSet;
    }
}

