/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeGroupDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.AttributeContextReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.AttributeGroup;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;

public class AttributeGroupPersistence {
    public static CdmAttributeGroupDefinition fromData(CdmCorpusContext ctx, JsonNode obj) {
        return AttributeGroupPersistence.fromData(ctx, obj, null);
    }

    public static CdmAttributeGroupDefinition fromData(CdmCorpusContext ctx, JsonNode obj, String entityName) {
        if (obj == null) {
            return null;
        }
        CdmAttributeGroupDefinition attributeGroup = (CdmAttributeGroupDefinition)ctx.getCorpus().makeObject(CdmObjectType.AttributeGroupDef, obj.has("attributeGroupName") ? obj.get("attributeGroupName").asText() : null);
        if (obj.get("explanation") != null) {
            attributeGroup.setExplanation(obj.get("explanation").asText());
        }
        attributeGroup.setAttributeContext(AttributeContextReferencePersistence.fromData(ctx, obj.get("attributeContext")));
        Utils.addListToCdmCollection(attributeGroup.getExhibitsTraits(), Utils.createTraitReferenceList(ctx, obj.get("exhibitsTraits")));
        if (obj.get("members") != null) {
            for (JsonNode att : obj.get("members")) {
                attributeGroup.getMembers().add(Utils.createAttribute(ctx, att, entityName));
            }
        }
        return attributeGroup;
    }

    public static Object toData(CdmAttributeGroupDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        AttributeGroup result = new AttributeGroup();
        result.setExplanation(instance.getExplanation());
        result.setAttributeGroupName(instance.getAttributeGroupName());
        result.setExhibitsTraits(Utils.listCopyDataAsArrayNode(instance.getExhibitsTraits(), resOpt, options));
        if (instance.getAttributeContext() != null) {
            result.setAttributeContext((String)instance.getAttributeContext().copyData(resOpt, options));
        }
        result.setMembers(Utils.listCopyDataAsArrayNode(instance.getMembers(), resOpt, options));
        return result;
    }
}

