/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DataPartition;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.KeyValuePair;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataPartitionPersistence {
    public static CdmDataPartitionDefinition fromData(CdmCorpusContext ctx, DataPartition obj) {
        CdmDataPartitionDefinition newPartition = (CdmDataPartitionDefinition)ctx.getCorpus().makeObject(CdmObjectType.DataPartitionDef);
        newPartition.setLocation(obj.getLocation());
        if (obj.getName() != null) {
            newPartition.setName(obj.getName());
        }
        if (obj.getSpecializedSchema() != null) {
            newPartition.setSpecializedSchema(obj.getSpecializedSchema());
        }
        if (obj.getLastFileStatusCheckTime() != null) {
            newPartition.setLastFileStatusCheckTime(obj.getLastFileStatusCheckTime());
        }
        if (obj.getLastFileModifiedTime() != null) {
            newPartition.setLastFileModifiedTime(obj.getLastFileModifiedTime());
        }
        if (obj.getExhibitsTraits() != null) {
            Utils.addListToCdmCollection(newPartition.getExhibitsTraits(), Utils.createTraitReferenceList(ctx, obj.getExhibitsTraits()));
        }
        if (obj.getArguments() == null) {
            return newPartition;
        }
        for (KeyValuePair<String, String> arg : obj.getArguments()) {
            if (newPartition.getArguments().containsKey(arg.getName())) {
                newPartition.getArguments().get(arg.getName()).add(arg.getValue());
                continue;
            }
            ArrayList<String> newArgList = new ArrayList<String>();
            newArgList.add(arg.getValue());
            newPartition.getArguments().put(arg.getName(), newArgList);
        }
        return newPartition;
    }

    public static DataPartition toData(CdmDataPartitionDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        ArrayList<KeyValuePair<String, String>> argumentsCopy = new ArrayList<KeyValuePair<String, String>>();
        if (instance.getArguments() != null) {
            for (Map.Entry<String, List<String>> argumentList : instance.getArguments().entrySet()) {
                argumentList.getValue().forEach(argumentValue -> argumentsCopy.add(new KeyValuePair<String, String>((String)argumentList.getKey(), (String)argumentValue)));
            }
        }
        DataPartition result = new DataPartition();
        result.setName(instance.getName());
        result.setLocation(instance.getLocation());
        result.setLastFileStatusCheckTime(instance.getLastFileStatusCheckTime());
        result.setLastFileModifiedTime(instance.getLastFileModifiedTime());
        result.setExhibitsTraits(DataPartitionPersistence.exhibitsTraitsToData(instance.getExhibitsTraits(), resOpt, options));
        result.setArguments(argumentsCopy.size() > 0 ? argumentsCopy : null);
        result.setSpecializedSchema(instance.getSpecializedSchema());
        return result;
    }

    private static ArrayNode exhibitsTraitsToData(CdmTraitCollection traits, ResolveOptions resOpt, CopyOptions options) {
        if (traits == null) {
            return null;
        }
        List filteredTraits = traits.getAllItems().stream().filter(trait -> !trait.isFromProperty()).collect(Collectors.toList());
        if (filteredTraits == null || filteredTraits.isEmpty()) {
            return null;
        }
        return Utils.listCopyDataAsArrayNode(filteredTraits, resOpt, options);
    }
}

