/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataTypeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.CdmObjectRefPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataTypePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DataType;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.io.IOException;
import java.util.ArrayList;

public class DataTypeReferencePersistence {
    public static CdmDataTypeReference fromData(CdmCorpusContext ctx, JsonNode obj) {
        if (obj == null) {
            return null;
        }
        boolean simpleReference = true;
        Object dataType = null;
        ArrayList<CdmTraitReference> appliedTraits = null;
        if (obj.isValueNode()) {
            dataType = obj;
        } else {
            simpleReference = false;
            if (obj.get("dataTypeReference").isValueNode()) {
                dataType = obj.get("dataTypeReference").asText();
            } else {
                try {
                    dataType = DataTypePersistence.fromData(ctx, (DataType)JMapper.MAP.treeToValue((TreeNode)obj.get("dataTypeReference"), DataType.class));
                }
                catch (IOException ex) {
                    Logger.error(DataTypeReferencePersistence.class.getSimpleName(), ctx, Logger.format("There was an error while trying to convert from JSON to DataTypeRef. Reason: '{0}'", ex.getLocalizedMessage()), "fromData");
                }
            }
        }
        CdmDataTypeReference dataTypeReference = (CdmDataTypeReference)ctx.getCorpus().makeRef(CdmObjectType.DataTypeRef, dataType, simpleReference);
        if (!obj.isValueNode()) {
            appliedTraits = Utils.createTraitReferenceList(ctx, obj.get("appliedTraits"));
        }
        Utils.addListToCdmCollection(dataTypeReference.getAppliedTraits(), appliedTraits);
        return dataTypeReference;
    }

    public static Object toData(CdmDataTypeReference instance, ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectRefPersistence.toData(instance, resOpt, options);
    }
}

