/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDefinitionCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.AttributeGroupPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ConstantEntityPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataTypePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.EntityPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ImportPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.PurposePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.TraitPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DataType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DocumentContent;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.Import;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.DynamicObjectExtensions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;

public class DocumentPersistence {
    public static final boolean isPersistenceAsync = false;
    public static final String[] formats = new String[]{".cdm.json"};

    public static CdmDocumentDefinition fromObject(CdmCorpusContext ctx, String name, String nameSpace, String path, DocumentContent obj) {
        CdmDocumentDefinition doc = (CdmDocumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.DocumentDef);
        doc.setFolderPath(path);
        doc.setNamespace(nameSpace);
        if (!Strings.isNullOrEmpty((String)obj.getSchema())) {
            doc.setSchema(obj.getSchema());
        }
        if (DynamicObjectExtensions.hasProperty(obj, "JsonSchemaSemanticVersion") && !Strings.isNullOrEmpty((String)obj.getJsonSchemaSemanticVersion())) {
            doc.setJsonSchemaSemanticVersion(obj.getJsonSchemaSemanticVersion());
        }
        if (obj.getImports() != null) {
            for (Import imp : obj.getImports()) {
                doc.getImports().add(ImportPersistence.fromData(ctx, imp));
            }
        }
        if (obj.getDefinitions() != null) {
            for (int i = 0; i < obj.getDefinitions().size(); ++i) {
                CdmDefinitionCollection definitions = doc.getDefinitions();
                JsonNode d = obj.getDefinitions().get(i);
                if (d.has("dataTypeName")) {
                    definitions.add(DataTypePersistence.fromData(ctx, (DataType)JMapper.MAP.convertValue((Object)d, DataType.class)));
                    continue;
                }
                if (d.has("purposeName")) {
                    definitions.add(PurposePersistence.fromData(ctx, d));
                    continue;
                }
                if (d.has("attributeGroupName")) {
                    definitions.add(AttributeGroupPersistence.fromData(ctx, d));
                    continue;
                }
                if (d.has("traitName")) {
                    definitions.add(TraitPersistence.fromData(ctx, d));
                    continue;
                }
                if (d.has("entityShape")) {
                    definitions.add(ConstantEntityPersistence.fromData(ctx, d));
                    continue;
                }
                if (!d.has("entityName")) continue;
                definitions.add(EntityPersistence.fromData(ctx, d));
            }
        }
        return doc;
    }

    public static CdmDocumentDefinition fromData(CdmCorpusContext ctx, String docName, String jsonData, CdmFolderDefinition folder) {
        try {
            DocumentContent obj = (DocumentContent)JMapper.MAP.readValue(jsonData, DocumentContent.class);
            return DocumentPersistence.fromObject(ctx, docName, folder.getNamespace(), folder.getFolderPath(), obj);
        }
        catch (Exception e) {
            Logger.error(DocumentPersistence.class.getSimpleName(), ctx, Logger.format("Could not convert '{0}'. Reason '{1}'.", docName, e.getLocalizedMessage()), "fromData");
            return null;
        }
    }

    public static DocumentContent toData(CdmDocumentDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        DocumentContent documentContent = new DocumentContent();
        documentContent.setSchema(instance.getSchema());
        documentContent.setJsonSchemaSemanticVersion(instance.getJsonSchemaSemanticVersion());
        documentContent.setImports(Utils.listCopyDataAsCdmObject(instance.getImports(), resOpt, options));
        documentContent.setDefinitions(Utils.listCopyDataAsCdmObject(instance.getDefinitions(), resOpt, options));
        return documentContent;
    }
}

