/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.modeljson;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeItem;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ExtensionHelper;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.TypeAttributePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.Attribute;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.LocalEntity;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class EntityPersistence {
    public static CompletableFuture<CdmEntityDefinition> fromData(CdmCorpusContext ctx, LocalEntity obj, List<CdmTraitDefinition> extensionTraitDefList, List<CdmTraitDefinition> localExtensionTraitDefList) {
        CdmEntityDefinition entity = (CdmEntityDefinition)ctx.getCorpus().makeObject(CdmObjectType.EntityDef, obj.getName());
        if (!StringUtils.isNullOrTrimEmpty(obj.getDescription())) {
            entity.setDescription(obj.getDescription());
        }
        return Utils.processAnnotationsFromData(ctx, obj, entity.getExhibitsTraits()).thenApply(v -> {
            if (obj.getAttributes() != null) {
                for (Attribute attribute : obj.getAttributes()) {
                    CdmAttributeItem typeAttribute = TypeAttributePersistence.fromData(ctx, attribute, extensionTraitDefList, localExtensionTraitDefList).join();
                    if (typeAttribute != null) {
                        entity.getAttributes().add(typeAttribute);
                        continue;
                    }
                    Logger.error(EntityPersistence.class.getSimpleName(), ctx, "There was an error while trying to convert model.json attribute to cdm attribute.");
                    return null;
                }
            }
            ExtensionHelper.processExtensionFromJson(ctx, obj, entity.getExhibitsTraits(), extensionTraitDefList, localExtensionTraitDefList);
            return entity;
        });
    }

    public static CompletableFuture<LocalEntity> toData(CdmEntityDefinition instance, CdmCorpusContext ctx, ResolveOptions resOpt, CopyOptions options) {
        LocalEntity result = new LocalEntity();
        result.setName(instance.getEntityName());
        result.setDescription((String)instance.getProperty(CdmPropertyName.DESCRIPTION));
        result.setType("LocalEntity");
        Utils.processTraitsAndAnnotationsToData(instance.getCtx(), result, instance.getExhibitsTraits());
        if (instance.getAttributes() != null) {
            result.setAttributes(new ArrayList<Attribute>());
            for (CdmAttributeItem element : instance.getAttributes()) {
                if (element.getObjectType() != CdmObjectType.TypeAttributeDef) {
                    Logger.error(EntityPersistence.class.getSimpleName(), ctx, "Saving a manifest, with an entity containing an entity attribute, to model.json format is currently not supported.");
                    return null;
                }
                if (!(element instanceof CdmTypeAttributeDefinition)) continue;
                Attribute attribute = TypeAttributePersistence.toData((CdmTypeAttributeDefinition)element, resOpt, options).join();
                if (attribute != null) {
                    result.getAttributes().add(attribute);
                    continue;
                }
                Logger.error(EntityPersistence.class.getSimpleName(), ctx, "There was an error while trying to convert model.json attribute to cdm attribute.");
                return null;
            }
        }
        return CompletableFuture.completedFuture(result);
    }
}

