/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.modeljson;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmE2ERelationship;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ImportPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.Import;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ExtensionHelper;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.LocalEntityDeclarationPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ReferencedEntityDeclarationPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.RelationshipPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.Entity;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.LocalEntity;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.Model;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.ReferenceEntity;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.ReferenceModel;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.SingleKeyRelationship;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class ManifestPersistence {
    private static final String FOUNDATIONS = "cdm:/foundations.cdm.json";
    public static final boolean isPersistenceAsync = true;
    public static final String[] formats = new String[]{"model.json"};

    public static CompletableFuture<CdmManifestDefinition> fromObject(CdmCorpusContext ctx, Model obj, CdmFolderDefinition folder) {
        CdmArgumentDefinition arg;
        ArrayList<CdmTraitDefinition> extensionTraitDefList = new ArrayList<CdmTraitDefinition>();
        CdmManifestDefinition manifest = (CdmManifestDefinition)ctx.getCorpus().makeObject(CdmObjectType.ManifestDef, obj.getName());
        folder.getDocuments().add(manifest);
        if (obj.getImports() != null) {
            obj.getImports().forEach(element -> manifest.getImports().add(ImportPersistence.fromData(ctx, element)));
        }
        if (manifest.getImports().getAllItems().parallelStream().noneMatch(importPresent -> Objects.equals(importPresent.getCorpusPath(), FOUNDATIONS))) {
            manifest.getImports().add(FOUNDATIONS);
        }
        manifest.setExplanation(obj.getDescription());
        manifest.setLastFileModifiedTime(obj.getModifiedTime());
        manifest.setLastChildFileModifiedTime(obj.getLastChildFileModifiedTime());
        manifest.setLastFileStatusCheckTime(obj.getLastFileStatusCheckTime());
        if (obj.getApplication() != null) {
            CdmTraitReference applicationTrait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.managedBy", false);
            applicationTrait.setFromProperty(true);
            arg = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, "application");
            arg.setValue(obj.getApplication());
            applicationTrait.getArguments().add(arg);
            manifest.getExhibitsTraits().add(applicationTrait);
        }
        if (obj.getVersion() != null) {
            CdmTraitReference versionTrait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.modelConversion.modelVersion", false);
            arg = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, "version");
            arg.setValue(obj.getVersion());
            versionTrait.getArguments().add(arg);
            manifest.getExhibitsTraits().add(versionTrait);
        }
        if (obj.getCulture() != null) {
            CdmTraitReference cultureTrait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.partition.culture", false);
            cultureTrait.setFromProperty(true);
            arg = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, "culture");
            arg.setValue(obj.getCulture());
            cultureTrait.getArguments().add(arg);
            manifest.getExhibitsTraits().add(cultureTrait);
        }
        if (obj.isHidden() != null && obj.isHidden().booleanValue()) {
            CdmTraitReference isHiddenTrait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.hidden", true);
            isHiddenTrait.setFromProperty(true);
            manifest.getExhibitsTraits().add(isHiddenTrait);
        }
        LinkedHashMap referenceModels = new LinkedHashMap();
        if (obj.getReferenceModels() != null) {
            CdmTraitReference referenceModelsTrait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.modelConversion.referenceModelMap", false);
            CdmArgumentDefinition arg2 = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, "referenceModelMap");
            arg2.setValue(JMapper.MAP.valueToTree(obj.getReferenceModels()));
            referenceModelsTrait.getArguments().add(arg2);
            manifest.getExhibitsTraits().add(referenceModelsTrait);
            obj.getReferenceModels().forEach(referenceModel -> referenceModels.put(referenceModel.getId(), referenceModel.getLocation()));
        }
        LinkedHashMap<String, String> entityPathByName = new LinkedHashMap<String, String>();
        if (obj.getEntities() != null && obj.getEntities().size() > 0) {
            for (Entity element2 : obj.getEntities()) {
                CdmEntityDeclarationDefinition entity = null;
                String type = element2.getType();
                if ("LocalEntity".equals(type)) {
                    entity = LocalEntityDeclarationPersistence.fromData(ctx, folder, (LocalEntity)element2, extensionTraitDefList, manifest).join();
                } else if ("ReferenceEntity".equals(type)) {
                    ReferenceEntity referenceEntity = (ReferenceEntity)element2;
                    if (!referenceModels.containsKey(referenceEntity.getModelId())) {
                        Logger.error(ManifestPersistence.class.getSimpleName(), ctx, Logger.format("Model Id '{0}' from '{1}' not found in referenceModels.", referenceEntity.getModelId(), referenceEntity.getName()));
                        return CompletableFuture.completedFuture(null);
                    }
                    entity = ReferencedEntityDeclarationPersistence.fromData(ctx, referenceEntity, (String)referenceModels.get(referenceEntity.getModelId())).join();
                } else {
                    Logger.error(ManifestPersistence.class.getSimpleName(), ctx, "There was an error while trying to parse entity type.");
                }
                if (entity != null) {
                    manifest.getEntities().add(entity);
                    entityPathByName.put(entity.getEntityName(), entity.getEntityPath());
                    continue;
                }
                Logger.error(ManifestPersistence.class.getSimpleName(), ctx, "There was an error while trying to parse entity type.");
            }
        }
        if (null != obj.getRelationships() && obj.getRelationships().size() > 0) {
            obj.getRelationships().forEach(element -> {
                CdmE2ERelationship relationship = RelationshipPersistence.fromData(ctx, element, entityPathByName).join();
                if (null != relationship) {
                    manifest.getRelationships().add(relationship);
                } else {
                    Logger.error(ManifestPersistence.class.getSimpleName(), ctx, "There was an error while trying to convert model.json local entity to cdm local entity declaration.");
                }
            });
        }
        return Utils.processAnnotationsFromData(ctx, obj, manifest.getExhibitsTraits()).thenCompose(v -> {
            ArrayList<CdmTraitDefinition> localExtensionTraitDefList = new ArrayList<CdmTraitDefinition>();
            ExtensionHelper.processExtensionFromJson(ctx, obj, manifest.getExhibitsTraits(), extensionTraitDefList, localExtensionTraitDefList);
            List<CdmImport> importDocs = ExtensionHelper.standardImportDetection(ctx, extensionTraitDefList, localExtensionTraitDefList).join();
            ExtensionHelper.addImportDocsToManifest(ctx, importDocs, manifest);
            ManifestPersistence.createExtensionDocAndAddToFolderAndImports(ctx, extensionTraitDefList, folder);
            folder.getDocuments().add(manifest);
            return CompletableFuture.completedFuture(manifest);
        });
    }

    public static CompletableFuture<CdmManifestDefinition> fromData(CdmCorpusContext ctx, String docName, String jsonData, CdmFolderDefinition folder) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Model obj = (Model)JMapper.MAP.readValue(jsonData, Model.class);
                return ManifestPersistence.fromObject(ctx, obj, folder).join();
            }
            catch (Exception e) {
                Logger.error(ManifestPersistence.class.getSimpleName(), ctx, Logger.format("Could not convert '{0}'. Reason '{1}'.", docName, e.getLocalizedMessage()));
                return null;
            }
        });
    }

    private static void createExtensionDocAndAddToFolderAndImports(CdmCorpusContext ctx, List<CdmTraitDefinition> extensionTraitDefList, CdmFolderDefinition folder) {
        if (extensionTraitDefList.size() > 0) {
            CdmDocumentDefinition extensionDoc = (CdmDocumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.DocumentDef, "custom.extension.cdm.json");
            extensionTraitDefList.parallelStream().map(cdmTraitDef -> cdmTraitDef).collect(Collectors.toList()).forEach(cdmObjectDef -> extensionDoc.getDefinitions().add(cdmObjectDef));
            extensionDoc.getImports().add("cdm:/extensions/base.extension.cdm.json");
            extensionDoc.setJsonSchemaSemanticVersion("1.0.0");
            extensionDoc.setFolderPath(folder.getFolderPath());
            extensionDoc.setNamespace(folder.getNamespace());
            folder.getDocuments().add(extensionDoc);
        }
    }

    public static CompletableFuture<Model> toData(CdmManifestDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            CdmTraitReference versionTrait;
            CdmTraitReference applicationTrait;
            Model result = new Model();
            result.setName(instance.getManifestName());
            result.setDescription(instance.getExplanation());
            result.setModifiedTime(instance.getLastFileModifiedTime());
            result.setLastChildFileModifiedTime(instance.getLastChildFileModifiedTime());
            result.setLastFileStatusCheckTime(instance.getLastFileStatusCheckTime());
            TraitToPropertyMap t2pm = new TraitToPropertyMap(instance);
            CdmTraitReference isHiddenTrait = t2pm.fetchTraitReferenceName("is.hidden");
            if (isHiddenTrait != null) {
                result.setHidden(true);
            }
            if ((applicationTrait = t2pm.fetchTraitReferenceName("is.managedBy")) != null) {
                result.setApplication(((CdmArgumentDefinition)applicationTrait.getArguments().get(0)).getValue().toString());
            }
            if ((versionTrait = t2pm.fetchTraitReferenceName("is.modelConversion.modelVersion")) != null) {
                result.setVersion(((CdmArgumentDefinition)versionTrait.getArguments().get(0)).getValue().toString());
            } else {
                result.setVersion("1.0");
            }
            CdmTraitReference cultureTrait = t2pm.fetchTraitReferenceName("is.partition.culture");
            if (cultureTrait != null) {
                result.setCulture(((CdmArgumentDefinition)cultureTrait.getArguments().get(0)).getValue().toString());
            }
            LinkedHashMap referenceEntityLocations = new LinkedHashMap();
            LinkedHashMap referenceModels = new LinkedHashMap();
            CdmTraitReference referenceModelsTrait = t2pm.fetchTraitReferenceName("is.modelConversion.referenceModelMap");
            if (referenceModelsTrait != null) {
                JsonNode refModels = JMapper.MAP.valueToTree(((CdmArgumentDefinition)referenceModelsTrait.getArguments().getAllItems().get(0)).getValue());
                refModels.forEach(referenceModel -> {
                    JsonNode referenceModelId = referenceModel.get("id");
                    String referenceModelIdAsString = referenceModelId.asText();
                    JsonNode referenceModelLocation = referenceModel.get("location");
                    String referenceModelLocationAsString = referenceModelLocation.asText();
                    referenceModels.put(referenceModelIdAsString, referenceModelLocationAsString);
                    referenceEntityLocations.put(referenceModelLocationAsString, referenceModelIdAsString);
                });
            }
            Utils.processTraitsAndAnnotationsToData(instance.getCtx(), result, instance.getExhibitsTraits());
            if (instance.getEntities() != null && instance.getEntities().getCount() > 0) {
                ArrayList<CompletableFuture<Void>> promises = new ArrayList<CompletableFuture<Void>>();
                CopyOnWriteArrayList obtainedEntities = new CopyOnWriteArrayList();
                for (CdmEntityDeclarationDefinition cdmEntityDeclarationDefinition : instance.getEntities()) {
                    CompletableFuture<Void> createdPromise = CompletableFuture.runAsync(() -> {
                        Entity element = null;
                        if (entity.getObjectType() == CdmObjectType.LocalEntityDeclarationDef) {
                            element = LocalEntityDeclarationPersistence.toData(entity, instance, resOpt, options).join();
                        } else if (entity.getObjectType() == CdmObjectType.ReferencedEntityDeclarationDef) {
                            element = ReferencedEntityDeclarationPersistence.toData(entity, resOpt, options).join();
                            String location = instance.getCtx().getCorpus().getStorage().corpusPathToAdapterPath(entity.getEntityPath());
                            if (Strings.isNullOrEmpty((String)location)) {
                                Logger.error(ManifestPersistence.class.getSimpleName(), instance.getCtx(), Logger.format("Invalid entity path set in entity {0}.", entity.getEntityName()));
                                element = null;
                            }
                            if (element instanceof ReferenceEntity) {
                                ReferenceEntity referenceEntity = (ReferenceEntity)element;
                                location = location.substring(0, location.lastIndexOf("/"));
                                if (referenceEntity.getModelId() != null) {
                                    String savedLocation = (String)referenceModels.get(referenceEntity.getModelId());
                                    if (savedLocation != null && !Objects.equals(savedLocation, location)) {
                                        Logger.error(ManifestPersistence.class.getSimpleName(), instance.getCtx(), "Same ModelId pointing to different locations");
                                        element = null;
                                    } else if (savedLocation == null) {
                                        referenceModels.put(referenceEntity.getModelId(), location);
                                        referenceEntityLocations.put(location, referenceEntity.getModelId());
                                    }
                                } else if (referenceEntityLocations.containsKey(location)) {
                                    referenceEntity.setModelId((String)referenceEntityLocations.get(location));
                                } else {
                                    referenceEntity.setModelId(UUID.randomUUID().toString());
                                    referenceModels.put(referenceEntity.getModelId(), location);
                                    referenceEntityLocations.put(location, referenceEntity.getModelId());
                                }
                            }
                        }
                        if (element != null) {
                            obtainedEntities.add(element);
                        } else {
                            Logger.error(ManifestPersistence.class.getSimpleName(), instance.getCtx(), Logger.format("There was an error while trying to convert {0} to model json format.", entity.getEntityName()));
                        }
                    });
                    try {
                        createdPromise.get();
                        promises.add(createdPromise);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        Logger.error(ManifestPersistence.class.getSimpleName(), instance.getCtx(), Logger.format("There was an error while trying to convert {0}'s entity declaration to model json format for reason {1}.", cdmEntityDeclarationDefinition.getEntityName(), e.getMessage()));
                    }
                }
                for (CompletableFuture completableFuture : promises) {
                    completableFuture.join();
                }
                result.setEntities(new ArrayList<Entity>(obtainedEntities));
            }
            if (!referenceModels.isEmpty()) {
                result.setReferenceModels(new ArrayList<ReferenceModel>());
                for (Map.Entry referenceModel2 : referenceModels.entrySet()) {
                    ReferenceModel newReferenceModel = new ReferenceModel();
                    newReferenceModel.setId((String)referenceModel2.getKey());
                    newReferenceModel.setLocation((String)referenceModel2.getValue());
                    result.getReferenceModels().add(newReferenceModel);
                }
            }
            if (null != instance.getRelationships() && instance.getRelationships().getCount() > 0) {
                result.setRelationships(new ArrayList<SingleKeyRelationship>());
                instance.getRelationships().forEach(cdmRelationship -> {
                    SingleKeyRelationship relationship = RelationshipPersistence.toData(cdmRelationship, resOpt, options).join();
                    if (null != relationship) {
                        result.getRelationships().add(relationship);
                    } else {
                        Logger.error(ManifestPersistence.class.getSimpleName(), instance.getCtx(), "There was an error while trying to convert cdm relationship to model.json relationship.");
                    }
                });
            }
            if (instance.getImports() != null && instance.getImports().getCount() > 0) {
                result.setImports(new ArrayList<Import>());
                instance.getImports().forEach(element -> result.getImports().add(ImportPersistence.toData(element, resOpt, options)));
            }
            return result;
        });
    }
}

